/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorage;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageBuilder;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageFluent;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryStatus;
import io.fabric8.openshift.api.model.operator.v1.GenerationStatus;
import io.fabric8.openshift.api.model.operator.v1.OperatorCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageRegistryStatusFluent<A extends ImageRegistryStatusFluent<A>>
extends BaseFluent<A> {
    private List<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
    private List<GenerationStatus> generations = new ArrayList<GenerationStatus>();
    private Long observedGeneration;
    private Integer readyReplicas;
    private ImageRegistryConfigStorageBuilder storage;
    private Boolean storageManaged;
    private String version;
    private Map<String, Object> additionalProperties;

    public ImageRegistryStatusFluent() {
    }

    public ImageRegistryStatusFluent(ImageRegistryStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageRegistryStatus instance) {
        ImageRegistryStatus imageRegistryStatus = instance = instance != null ? instance : new ImageRegistryStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withGenerations(instance.getGenerations());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withStorage(instance.getStorage());
            this.withStorageManaged(instance.getStorageManaged());
            this.withVersion(instance.getVersion());
            this.withConditions(instance.getConditions());
            this.withGenerations(instance.getGenerations());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withStorage(instance.getStorage());
            this.withStorageManaged(instance.getStorageManaged());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorCondition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorCondition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorCondition>();
        }
        for (OperatorCondition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorCondition>();
        }
        for (OperatorCondition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (OperatorCondition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<OperatorCondition> getConditions() {
        return this.conditions;
    }

    public OperatorCondition getCondition(int index) {
        return this.conditions.get(index);
    }

    public OperatorCondition getFirstCondition() {
        return this.conditions.get(0);
    }

    public OperatorCondition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public OperatorCondition getMatchingCondition(Predicate<OperatorCondition> predicate) {
        for (OperatorCondition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<OperatorCondition> predicate) {
        for (OperatorCondition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<OperatorCondition>();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public A addToGenerations(int index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList<GenerationStatus>();
        }
        this.generations.add(index, item);
        return (A)this;
    }

    public A setToGenerations(int index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList<GenerationStatus>();
        }
        this.generations.set(index, item);
        return (A)this;
    }

    public A addToGenerations(GenerationStatus ... items) {
        if (this.generations == null) {
            this.generations = new ArrayList<GenerationStatus>();
        }
        for (GenerationStatus item : items) {
            this.generations.add(item);
        }
        return (A)this;
    }

    public A addAllToGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {
            this.generations = new ArrayList<GenerationStatus>();
        }
        for (GenerationStatus item : items) {
            this.generations.add(item);
        }
        return (A)this;
    }

    public A removeFromGenerations(GenerationStatus ... items) {
        if (this.generations == null) {
            return (A)this;
        }
        for (GenerationStatus item : items) {
            this.generations.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {
            return (A)this;
        }
        for (GenerationStatus item : items) {
            this.generations.remove(item);
        }
        return (A)this;
    }

    public List<GenerationStatus> getGenerations() {
        return this.generations;
    }

    public GenerationStatus getGeneration(int index) {
        return this.generations.get(index);
    }

    public GenerationStatus getFirstGeneration() {
        return this.generations.get(0);
    }

    public GenerationStatus getLastGeneration() {
        return this.generations.get(this.generations.size() - 1);
    }

    public GenerationStatus getMatchingGeneration(Predicate<GenerationStatus> predicate) {
        for (GenerationStatus item : this.generations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGeneration(Predicate<GenerationStatus> predicate) {
        for (GenerationStatus item : this.generations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGenerations(List<GenerationStatus> generations) {
        if (generations != null) {
            this.generations = new ArrayList<GenerationStatus>();
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        } else {
            this.generations = null;
        }
        return (A)this;
    }

    public A withGenerations(GenerationStatus ... generations) {
        if (this.generations != null) {
            this.generations.clear();
            this._visitables.remove("generations");
        }
        if (generations != null) {
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasGenerations() {
        return this.generations != null && !this.generations.isEmpty();
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    public boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public ImageRegistryConfigStorage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    public A withStorage(ImageRegistryConfigStorage storage) {
        this._visitables.remove(this.storage);
        if (storage != null) {
            this.storage = new ImageRegistryConfigStorageBuilder(storage);
            this._visitables.get("storage").add(this.storage);
        } else {
            this.storage = null;
            this._visitables.get("storage").remove(this.storage);
        }
        return (A)this;
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public StorageNested<A> withNewStorage() {
        return new StorageNested(null);
    }

    public StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item) {
        return new StorageNested(item);
    }

    public StorageNested<A> editStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(null));
    }

    public StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(new ImageRegistryConfigStorageBuilder().build()));
    }

    public StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item) {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(item));
    }

    public Boolean getStorageManaged() {
        return this.storageManaged;
    }

    public A withStorageManaged(Boolean storageManaged) {
        this.storageManaged = storageManaged;
        return (A)this;
    }

    public boolean hasStorageManaged() {
        return this.storageManaged != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageRegistryStatusFluent that = (ImageRegistryStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.generations, that.generations)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.storageManaged, that.storageManaged)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.generations, this.observedGeneration, this.readyReplicas, this.storage, this.storageManaged, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.generations != null && !this.generations.isEmpty()) {
            sb.append("generations:");
            sb.append(this.generations + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.storageManaged != null) {
            sb.append("storageManaged:");
            sb.append(this.storageManaged + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withStorageManaged() {
        return this.withStorageManaged(true);
    }

    public class StorageNested<N>
    extends ImageRegistryConfigStorageFluent<StorageNested<N>>
    implements Nested<N> {
        ImageRegistryConfigStorageBuilder builder;

        StorageNested(ImageRegistryConfigStorage item) {
            this.builder = new ImageRegistryConfigStorageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistryStatusFluent.this.withStorage(this.builder.build());
        }

        public N endStorage() {
            return this.and();
        }
    }
}

