/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlace;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlaceBuilder;
import io.fabric8.openshift.api.model.installer.v1.BootstrapInPlaceFluent;
import io.fabric8.openshift.api.model.installer.v1.Capabilities;
import io.fabric8.openshift.api.model.installer.v1.CapabilitiesBuilder;
import io.fabric8.openshift.api.model.installer.v1.CapabilitiesFluent;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSource;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSourceBuilder;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSourceFluent;
import io.fabric8.openshift.api.model.installer.v1.InstallConfig;
import io.fabric8.openshift.api.model.installer.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.v1.Networking;
import io.fabric8.openshift.api.model.installer.v1.NetworkingBuilder;
import io.fabric8.openshift.api.model.installer.v1.NetworkingFluent;
import io.fabric8.openshift.api.model.installer.v1.Platform;
import io.fabric8.openshift.api.model.installer.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.installer.v1.PlatformFluent;
import io.fabric8.openshift.api.model.installer.v1.Proxy;
import io.fabric8.openshift.api.model.installer.v1.ProxyBuilder;
import io.fabric8.openshift.api.model.installer.v1.ProxyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class InstallConfigFluent<A extends InstallConfigFluent<A>>
extends BaseFluent<A> {
    private String additionalTrustBundle;
    private String additionalTrustBundlePolicy;
    private String apiVersion;
    private String baseDomain;
    private BootstrapInPlaceBuilder bootstrapInPlace;
    private CapabilitiesBuilder capabilities;
    private ArrayList<MachinePoolBuilder> compute = new ArrayList();
    private MachinePoolBuilder controlPlane;
    private String cpuPartitioningMode;
    private String credentialsMode;
    private String featureSet;
    private Boolean fips;
    private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private NetworkingBuilder networking;
    private PlatformBuilder platform;
    private ProxyBuilder proxy;
    private String publish;
    private String pullSecret;
    private String sshKey;
    private Map<String, Object> additionalProperties;

    public InstallConfigFluent() {
    }

    public InstallConfigFluent(InstallConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InstallConfig instance) {
        InstallConfig installConfig = instance = instance != null ? instance : new InstallConfig();
        if (instance != null) {
            this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
            this.withAdditionalTrustBundlePolicy(instance.getAdditionalTrustBundlePolicy());
            this.withApiVersion(instance.getApiVersion());
            this.withBaseDomain(instance.getBaseDomain());
            this.withBootstrapInPlace(instance.getBootstrapInPlace());
            this.withCapabilities(instance.getCapabilities());
            this.withCompute(instance.getCompute());
            this.withControlPlane(instance.getControlPlane());
            this.withCpuPartitioningMode(instance.getCpuPartitioningMode());
            this.withCredentialsMode(instance.getCredentialsMode());
            this.withFeatureSet(instance.getFeatureSet());
            this.withFips(instance.getFips());
            this.withImageContentSources(instance.getImageContentSources());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNetworking(instance.getNetworking());
            this.withPlatform(instance.getPlatform());
            this.withProxy(instance.getProxy());
            this.withPublish(instance.getPublish());
            this.withPullSecret(instance.getPullSecret());
            this.withSshKey(instance.getSshKey());
            this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
            this.withAdditionalTrustBundlePolicy(instance.getAdditionalTrustBundlePolicy());
            this.withApiVersion(instance.getApiVersion());
            this.withBaseDomain(instance.getBaseDomain());
            this.withBootstrapInPlace(instance.getBootstrapInPlace());
            this.withCapabilities(instance.getCapabilities());
            this.withCompute(instance.getCompute());
            this.withControlPlane(instance.getControlPlane());
            this.withCpuPartitioningMode(instance.getCpuPartitioningMode());
            this.withCredentialsMode(instance.getCredentialsMode());
            this.withFeatureSet(instance.getFeatureSet());
            this.withFips(instance.getFips());
            this.withImageContentSources(instance.getImageContentSources());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNetworking(instance.getNetworking());
            this.withPlatform(instance.getPlatform());
            this.withProxy(instance.getProxy());
            this.withPublish(instance.getPublish());
            this.withPullSecret(instance.getPullSecret());
            this.withSshKey(instance.getSshKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAdditionalTrustBundle() {
        return this.additionalTrustBundle;
    }

    public A withAdditionalTrustBundle(String additionalTrustBundle) {
        this.additionalTrustBundle = additionalTrustBundle;
        return (A)this;
    }

    public boolean hasAdditionalTrustBundle() {
        return this.additionalTrustBundle != null;
    }

    public String getAdditionalTrustBundlePolicy() {
        return this.additionalTrustBundlePolicy;
    }

    public A withAdditionalTrustBundlePolicy(String additionalTrustBundlePolicy) {
        this.additionalTrustBundlePolicy = additionalTrustBundlePolicy;
        return (A)this;
    }

    public boolean hasAdditionalTrustBundlePolicy() {
        return this.additionalTrustBundlePolicy != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public BootstrapInPlace buildBootstrapInPlace() {
        return this.bootstrapInPlace != null ? this.bootstrapInPlace.build() : null;
    }

    public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
        this._visitables.remove(this.bootstrapInPlace);
        if (bootstrapInPlace != null) {
            this.bootstrapInPlace = new BootstrapInPlaceBuilder(bootstrapInPlace);
            this._visitables.get("bootstrapInPlace").add(this.bootstrapInPlace);
        } else {
            this.bootstrapInPlace = null;
            this._visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace);
        }
        return (A)this;
    }

    public boolean hasBootstrapInPlace() {
        return this.bootstrapInPlace != null;
    }

    public A withNewBootstrapInPlace(String installationDisk) {
        return this.withBootstrapInPlace(new BootstrapInPlace(installationDisk));
    }

    public BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
        return new BootstrapInPlaceNested(null);
    }

    public BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return new BootstrapInPlaceNested(item);
    }

    public BootstrapInPlaceNested<A> editBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(null));
    }

    public BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(new BootstrapInPlaceBuilder().build()));
    }

    public BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
        return this.withNewBootstrapInPlaceLike(Optional.ofNullable(this.buildBootstrapInPlace()).orElse(item));
    }

    public Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public A withCapabilities(Capabilities capabilities) {
        this._visitables.remove(this.capabilities);
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get("capabilities").remove(this.capabilities);
        }
        return (A)this;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new CapabilitiesBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public A addToCompute(int index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        if (index < 0 || index >= this.compute.size()) {
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        } else {
            this._visitables.get("compute").add(index, builder);
            this.compute.add(index, builder);
        }
        return (A)this;
    }

    public A setToCompute(int index, MachinePool item) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        MachinePoolBuilder builder = new MachinePoolBuilder(item);
        if (index < 0 || index >= this.compute.size()) {
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        } else {
            this._visitables.get("compute").set(index, builder);
            this.compute.set(index, builder);
        }
        return (A)this;
    }

    public A addToCompute(MachinePool ... items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        }
        return (A)this;
    }

    public A addAllToCompute(Collection<MachinePool> items) {
        if (this.compute == null) {
            this.compute = new ArrayList();
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").add(builder);
            this.compute.add(builder);
        }
        return (A)this;
    }

    public A removeFromCompute(MachinePool ... items) {
        if (this.compute == null) {
            return (A)this;
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").remove(builder);
            this.compute.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCompute(Collection<MachinePool> items) {
        if (this.compute == null) {
            return (A)this;
        }
        for (MachinePool item : items) {
            MachinePoolBuilder builder = new MachinePoolBuilder(item);
            this._visitables.get("compute").remove(builder);
            this.compute.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
        if (this.compute == null) {
            return (A)this;
        }
        Iterator<MachinePoolBuilder> each = this.compute.iterator();
        Object visitables = this._visitables.get("compute");
        while (each.hasNext()) {
            MachinePoolBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MachinePool> buildCompute() {
        return this.compute != null ? InstallConfigFluent.build(this.compute) : null;
    }

    public MachinePool buildCompute(int index) {
        return this.compute.get(index).build();
    }

    public MachinePool buildFirstCompute() {
        return this.compute.get(0).build();
    }

    public MachinePool buildLastCompute() {
        return this.compute.get(this.compute.size() - 1).build();
    }

    public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        for (MachinePoolBuilder item : this.compute) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCompute(List<MachinePool> compute) {
        if (this.compute != null) {
            this._visitables.get("compute").clear();
        }
        if (compute != null) {
            this.compute = new ArrayList();
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        } else {
            this.compute = null;
        }
        return (A)this;
    }

    public A withCompute(MachinePool ... compute) {
        if (this.compute != null) {
            this.compute.clear();
            this._visitables.remove("compute");
        }
        if (compute != null) {
            for (MachinePool item : compute) {
                this.addToCompute(item);
            }
        }
        return (A)this;
    }

    public boolean hasCompute() {
        return this.compute != null && !this.compute.isEmpty();
    }

    public ComputeNested<A> addNewCompute() {
        return new ComputeNested(-1, null);
    }

    public ComputeNested<A> addNewComputeLike(MachinePool item) {
        return new ComputeNested(-1, item);
    }

    public ComputeNested<A> setNewComputeLike(int index, MachinePool item) {
        return new ComputeNested(index, item);
    }

    public ComputeNested<A> editCompute(int index) {
        if (this.compute.size() <= index) {
            throw new RuntimeException("Can't edit compute. Index exceeds size.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public ComputeNested<A> editFirstCompute() {
        if (this.compute.size() == 0) {
            throw new RuntimeException("Can't edit first compute. The list is empty.");
        }
        return this.setNewComputeLike(0, this.buildCompute(0));
    }

    public ComputeNested<A> editLastCompute() {
        int index = this.compute.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last compute. The list is empty.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.compute.size(); ++i) {
            if (!predicate.test(this.compute.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching compute. No match found.");
        }
        return this.setNewComputeLike(index, this.buildCompute(index));
    }

    public MachinePool buildControlPlane() {
        return this.controlPlane != null ? this.controlPlane.build() : null;
    }

    public A withControlPlane(MachinePool controlPlane) {
        this._visitables.remove(this.controlPlane);
        if (controlPlane != null) {
            this.controlPlane = new MachinePoolBuilder(controlPlane);
            this._visitables.get("controlPlane").add(this.controlPlane);
        } else {
            this.controlPlane = null;
            this._visitables.get("controlPlane").remove(this.controlPlane);
        }
        return (A)this;
    }

    public boolean hasControlPlane() {
        return this.controlPlane != null;
    }

    public ControlPlaneNested<A> withNewControlPlane() {
        return new ControlPlaneNested(null);
    }

    public ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
        return new ControlPlaneNested(item);
    }

    public ControlPlaneNested<A> editControlPlane() {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(null));
    }

    public ControlPlaneNested<A> editOrNewControlPlane() {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(new MachinePoolBuilder().build()));
    }

    public ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
        return this.withNewControlPlaneLike(Optional.ofNullable(this.buildControlPlane()).orElse(item));
    }

    public String getCpuPartitioningMode() {
        return this.cpuPartitioningMode;
    }

    public A withCpuPartitioningMode(String cpuPartitioningMode) {
        this.cpuPartitioningMode = cpuPartitioningMode;
        return (A)this;
    }

    public boolean hasCpuPartitioningMode() {
        return this.cpuPartitioningMode != null;
    }

    public String getCredentialsMode() {
        return this.credentialsMode;
    }

    public A withCredentialsMode(String credentialsMode) {
        this.credentialsMode = credentialsMode;
        return (A)this;
    }

    public boolean hasCredentialsMode() {
        return this.credentialsMode != null;
    }

    public String getFeatureSet() {
        return this.featureSet;
    }

    public A withFeatureSet(String featureSet) {
        this.featureSet = featureSet;
        return (A)this;
    }

    public boolean hasFeatureSet() {
        return this.featureSet != null;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public A withFips(Boolean fips) {
        this.fips = fips;
        return (A)this;
    }

    public boolean hasFips() {
        return this.fips != null;
    }

    public A addToImageContentSources(int index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        if (index < 0 || index >= this.imageContentSources.size()) {
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        } else {
            this._visitables.get("imageContentSources").add(index, builder);
            this.imageContentSources.add(index, builder);
        }
        return (A)this;
    }

    public A setToImageContentSources(int index, ImageContentSource item) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
        if (index < 0 || index >= this.imageContentSources.size()) {
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        } else {
            this._visitables.get("imageContentSources").set(index, builder);
            this.imageContentSources.set(index, builder);
        }
        return (A)this;
    }

    public A addToImageContentSources(ImageContentSource ... items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)this;
    }

    public A addAllToImageContentSources(Collection<ImageContentSource> items) {
        if (this.imageContentSources == null) {
            this.imageContentSources = new ArrayList();
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").add(builder);
            this.imageContentSources.add(builder);
        }
        return (A)this;
    }

    public A removeFromImageContentSources(ImageContentSource ... items) {
        if (this.imageContentSources == null) {
            return (A)this;
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").remove(builder);
            this.imageContentSources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
        if (this.imageContentSources == null) {
            return (A)this;
        }
        for (ImageContentSource item : items) {
            ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
            this._visitables.get("imageContentSources").remove(builder);
            this.imageContentSources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
        if (this.imageContentSources == null) {
            return (A)this;
        }
        Iterator<ImageContentSourceBuilder> each = this.imageContentSources.iterator();
        Object visitables = this._visitables.get("imageContentSources");
        while (each.hasNext()) {
            ImageContentSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ImageContentSource> buildImageContentSources() {
        return this.imageContentSources != null ? InstallConfigFluent.build(this.imageContentSources) : null;
    }

    public ImageContentSource buildImageContentSource(int index) {
        return this.imageContentSources.get(index).build();
    }

    public ImageContentSource buildFirstImageContentSource() {
        return this.imageContentSources.get(0).build();
    }

    public ImageContentSource buildLastImageContentSource() {
        return this.imageContentSources.get(this.imageContentSources.size() - 1).build();
    }

    public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        for (ImageContentSourceBuilder item : this.imageContentSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImageContentSources(List<ImageContentSource> imageContentSources) {
        if (this.imageContentSources != null) {
            this._visitables.get("imageContentSources").clear();
        }
        if (imageContentSources != null) {
            this.imageContentSources = new ArrayList();
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        } else {
            this.imageContentSources = null;
        }
        return (A)this;
    }

    public A withImageContentSources(ImageContentSource ... imageContentSources) {
        if (this.imageContentSources != null) {
            this.imageContentSources.clear();
            this._visitables.remove("imageContentSources");
        }
        if (imageContentSources != null) {
            for (ImageContentSource item : imageContentSources) {
                this.addToImageContentSources(item);
            }
        }
        return (A)this;
    }

    public boolean hasImageContentSources() {
        return this.imageContentSources != null && !this.imageContentSources.isEmpty();
    }

    public ImageContentSourcesNested<A> addNewImageContentSource() {
        return new ImageContentSourcesNested(-1, null);
    }

    public ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
        return new ImageContentSourcesNested(-1, item);
    }

    public ImageContentSourcesNested<A> setNewImageContentSourceLike(int index, ImageContentSource item) {
        return new ImageContentSourcesNested(index, item);
    }

    public ImageContentSourcesNested<A> editImageContentSource(int index) {
        if (this.imageContentSources.size() <= index) {
            throw new RuntimeException("Can't edit imageContentSources. Index exceeds size.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public ImageContentSourcesNested<A> editFirstImageContentSource() {
        if (this.imageContentSources.size() == 0) {
            throw new RuntimeException("Can't edit first imageContentSources. The list is empty.");
        }
        return this.setNewImageContentSourceLike(0, this.buildImageContentSource(0));
    }

    public ImageContentSourcesNested<A> editLastImageContentSource() {
        int index = this.imageContentSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageContentSources. The list is empty.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageContentSources.size(); ++i) {
            if (!predicate.test(this.imageContentSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageContentSources. No match found.");
        }
        return this.setNewImageContentSourceLike(index, this.buildImageContentSource(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Networking buildNetworking() {
        return this.networking != null ? this.networking.build() : null;
    }

    public A withNetworking(Networking networking) {
        this._visitables.remove(this.networking);
        if (networking != null) {
            this.networking = new NetworkingBuilder(networking);
            this._visitables.get("networking").add(this.networking);
        } else {
            this.networking = null;
            this._visitables.get("networking").remove(this.networking);
        }
        return (A)this;
    }

    public boolean hasNetworking() {
        return this.networking != null;
    }

    public NetworkingNested<A> withNewNetworking() {
        return new NetworkingNested(null);
    }

    public NetworkingNested<A> withNewNetworkingLike(Networking item) {
        return new NetworkingNested(item);
    }

    public NetworkingNested<A> editNetworking() {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(null));
    }

    public NetworkingNested<A> editOrNewNetworking() {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(new NetworkingBuilder().build()));
    }

    public NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
        return this.withNewNetworkingLike(Optional.ofNullable(this.buildNetworking()).orElse(item));
    }

    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public A withPlatform(Platform platform) {
        this._visitables.remove(this.platform);
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNested(item);
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new PlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public Proxy buildProxy() {
        return this.proxy != null ? this.proxy.build() : null;
    }

    public A withProxy(Proxy proxy) {
        this._visitables.remove(this.proxy);
        if (proxy != null) {
            this.proxy = new ProxyBuilder(proxy);
            this._visitables.get("proxy").add(this.proxy);
        } else {
            this.proxy = null;
            this._visitables.get("proxy").remove(this.proxy);
        }
        return (A)this;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public A withNewProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
    }

    public ProxyNested<A> withNewProxy() {
        return new ProxyNested(null);
    }

    public ProxyNested<A> withNewProxyLike(Proxy item) {
        return new ProxyNested(item);
    }

    public ProxyNested<A> editProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(null));
    }

    public ProxyNested<A> editOrNewProxy() {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(new ProxyBuilder().build()));
    }

    public ProxyNested<A> editOrNewProxyLike(Proxy item) {
        return this.withNewProxyLike(Optional.ofNullable(this.buildProxy()).orElse(item));
    }

    public String getPublish() {
        return this.publish;
    }

    public A withPublish(String publish) {
        this.publish = publish;
        return (A)this;
    }

    public boolean hasPublish() {
        return this.publish != null;
    }

    public String getPullSecret() {
        return this.pullSecret;
    }

    public A withPullSecret(String pullSecret) {
        this.pullSecret = pullSecret;
        return (A)this;
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public A withSshKey(String sshKey) {
        this.sshKey = sshKey;
        return (A)this;
    }

    public boolean hasSshKey() {
        return this.sshKey != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstallConfigFluent that = (InstallConfigFluent)o;
        if (!Objects.equals(this.additionalTrustBundle, that.additionalTrustBundle)) {
            return false;
        }
        if (!Objects.equals(this.additionalTrustBundlePolicy, that.additionalTrustBundlePolicy)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapInPlace, that.bootstrapInPlace)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.compute, that.compute)) {
            return false;
        }
        if (!Objects.equals(this.controlPlane, that.controlPlane)) {
            return false;
        }
        if (!Objects.equals(this.cpuPartitioningMode, that.cpuPartitioningMode)) {
            return false;
        }
        if (!Objects.equals(this.credentialsMode, that.credentialsMode)) {
            return false;
        }
        if (!Objects.equals(this.featureSet, that.featureSet)) {
            return false;
        }
        if (!Objects.equals(this.fips, that.fips)) {
            return false;
        }
        if (!Objects.equals(this.imageContentSources, that.imageContentSources)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.networking, that.networking)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.proxy, that.proxy)) {
            return false;
        }
        if (!Objects.equals(this.publish, that.publish)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.sshKey, that.sshKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalTrustBundle, this.additionalTrustBundlePolicy, this.apiVersion, this.baseDomain, this.bootstrapInPlace, this.capabilities, this.compute, this.controlPlane, this.cpuPartitioningMode, this.credentialsMode, this.featureSet, this.fips, this.imageContentSources, this.kind, this.metadata, this.networking, this.platform, this.proxy, this.publish, this.pullSecret, this.sshKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustBundle != null) {
            sb.append("additionalTrustBundle:");
            sb.append(this.additionalTrustBundle + ",");
        }
        if (this.additionalTrustBundlePolicy != null) {
            sb.append("additionalTrustBundlePolicy:");
            sb.append(this.additionalTrustBundlePolicy + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.bootstrapInPlace != null) {
            sb.append("bootstrapInPlace:");
            sb.append(this.bootstrapInPlace + ",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.compute != null && !this.compute.isEmpty()) {
            sb.append("compute:");
            sb.append(this.compute + ",");
        }
        if (this.controlPlane != null) {
            sb.append("controlPlane:");
            sb.append(this.controlPlane + ",");
        }
        if (this.cpuPartitioningMode != null) {
            sb.append("cpuPartitioningMode:");
            sb.append(this.cpuPartitioningMode + ",");
        }
        if (this.credentialsMode != null) {
            sb.append("credentialsMode:");
            sb.append(this.credentialsMode + ",");
        }
        if (this.featureSet != null) {
            sb.append("featureSet:");
            sb.append(this.featureSet + ",");
        }
        if (this.fips != null) {
            sb.append("fips:");
            sb.append(this.fips + ",");
        }
        if (this.imageContentSources != null && !this.imageContentSources.isEmpty()) {
            sb.append("imageContentSources:");
            sb.append(this.imageContentSources + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.networking != null) {
            sb.append("networking:");
            sb.append(this.networking + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append(this.proxy + ",");
        }
        if (this.publish != null) {
            sb.append("publish:");
            sb.append(this.publish + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.sshKey != null) {
            sb.append("sshKey:");
            sb.append(this.sshKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withFips() {
        return this.withFips(true);
    }

    public class ProxyNested<N>
    extends ProxyFluent<ProxyNested<N>>
    implements Nested<N> {
        ProxyBuilder builder;

        ProxyNested(Proxy item) {
            this.builder = new ProxyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withProxy(this.builder.build());
        }

        public N endProxy() {
            return this.and();
        }
    }

    public class PlatformNested<N>
    extends PlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        PlatformBuilder builder;

        PlatformNested(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }

    public class NetworkingNested<N>
    extends NetworkingFluent<NetworkingNested<N>>
    implements Nested<N> {
        NetworkingBuilder builder;

        NetworkingNested(Networking item) {
            this.builder = new NetworkingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withNetworking(this.builder.build());
        }

        public N endNetworking() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ImageContentSourcesNested<N>
    extends ImageContentSourceFluent<ImageContentSourcesNested<N>>
    implements Nested<N> {
        ImageContentSourceBuilder builder;
        int index;

        ImageContentSourcesNested(int index, ImageContentSource item) {
            this.index = index;
            this.builder = new ImageContentSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.setToImageContentSources(this.index, this.builder.build());
        }

        public N endImageContentSource() {
            return this.and();
        }
    }

    public class ControlPlaneNested<N>
    extends MachinePoolFluent<ControlPlaneNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        ControlPlaneNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withControlPlane(this.builder.build());
        }

        public N endControlPlane() {
            return this.and();
        }
    }

    public class ComputeNested<N>
    extends MachinePoolFluent<ComputeNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;
        int index;

        ComputeNested(int index, MachinePool item) {
            this.index = index;
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.setToCompute(this.index, this.builder.build());
        }

        public N endCompute() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilitiesFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        CapabilitiesBuilder builder;

        CapabilitiesNested(Capabilities item) {
            this.builder = new CapabilitiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }

    public class BootstrapInPlaceNested<N>
    extends BootstrapInPlaceFluent<BootstrapInPlaceNested<N>>
    implements Nested<N> {
        BootstrapInPlaceBuilder builder;

        BootstrapInPlaceNested(BootstrapInPlace item) {
            this.builder = new BootstrapInPlaceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InstallConfigFluent.this.withBootstrapInPlace(this.builder.build());
        }

        public N endBootstrapInPlace() {
            return this.and();
        }
    }
}

