/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.EncryptionKeyReference;
import io.fabric8.openshift.api.model.installer.gcp.v1.KMSKeyReference;
import io.fabric8.openshift.api.model.installer.gcp.v1.KMSKeyReferenceBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.KMSKeyReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EncryptionKeyReferenceFluent<A extends EncryptionKeyReferenceFluent<A>>
extends BaseFluent<A> {
    private KMSKeyReferenceBuilder kmsKey;
    private String kmsKeyServiceAccount;
    private Map<String, Object> additionalProperties;

    public EncryptionKeyReferenceFluent() {
    }

    public EncryptionKeyReferenceFluent(EncryptionKeyReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EncryptionKeyReference instance) {
        EncryptionKeyReference encryptionKeyReference = instance = instance != null ? instance : new EncryptionKeyReference();
        if (instance != null) {
            this.withKmsKey(instance.getKmsKey());
            this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount());
            this.withKmsKey(instance.getKmsKey());
            this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public KMSKeyReference buildKmsKey() {
        return this.kmsKey != null ? this.kmsKey.build() : null;
    }

    public A withKmsKey(KMSKeyReference kmsKey) {
        this._visitables.remove(this.kmsKey);
        if (kmsKey != null) {
            this.kmsKey = new KMSKeyReferenceBuilder(kmsKey);
            this._visitables.get("kmsKey").add(this.kmsKey);
        } else {
            this.kmsKey = null;
            this._visitables.get("kmsKey").remove(this.kmsKey);
        }
        return (A)this;
    }

    public boolean hasKmsKey() {
        return this.kmsKey != null;
    }

    public A withNewKmsKey(String keyRing, String location, String name, String projectID) {
        return this.withKmsKey(new KMSKeyReference(keyRing, location, name, projectID));
    }

    public KmsKeyNested<A> withNewKmsKey() {
        return new KmsKeyNested(null);
    }

    public KmsKeyNested<A> withNewKmsKeyLike(KMSKeyReference item) {
        return new KmsKeyNested(item);
    }

    public KmsKeyNested<A> editKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(null));
    }

    public KmsKeyNested<A> editOrNewKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(new KMSKeyReferenceBuilder().build()));
    }

    public KmsKeyNested<A> editOrNewKmsKeyLike(KMSKeyReference item) {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(item));
    }

    public String getKmsKeyServiceAccount() {
        return this.kmsKeyServiceAccount;
    }

    public A withKmsKeyServiceAccount(String kmsKeyServiceAccount) {
        this.kmsKeyServiceAccount = kmsKeyServiceAccount;
        return (A)this;
    }

    public boolean hasKmsKeyServiceAccount() {
        return this.kmsKeyServiceAccount != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EncryptionKeyReferenceFluent that = (EncryptionKeyReferenceFluent)o;
        if (!Objects.equals(this.kmsKey, that.kmsKey)) {
            return false;
        }
        if (!Objects.equals(this.kmsKeyServiceAccount, that.kmsKeyServiceAccount)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kmsKey, this.kmsKeyServiceAccount, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kmsKey != null) {
            sb.append("kmsKey:");
            sb.append(this.kmsKey + ",");
        }
        if (this.kmsKeyServiceAccount != null) {
            sb.append("kmsKeyServiceAccount:");
            sb.append(this.kmsKeyServiceAccount + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KmsKeyNested<N>
    extends KMSKeyReferenceFluent<KmsKeyNested<N>>
    implements Nested<N> {
        KMSKeyReferenceBuilder builder;

        KmsKeyNested(KMSKeyReference item) {
            this.builder = new KMSKeyReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EncryptionKeyReferenceFluent.this.withKmsKey(this.builder.build());
        }

        public N endKmsKey() {
            return this.and();
        }
    }
}

