/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReference;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.Provisioning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ProvisioningFluent<A extends ProvisioningFluent<A>>
extends BaseFluent<A> {
    private ClusterImageSetReferenceBuilder imageSetRef;
    private LocalObjectReferenceBuilder installConfigSecretRef;
    private List<EnvVar> installerEnv = new ArrayList<EnvVar>();
    private String installerImageOverride;
    private LocalObjectReferenceBuilder manifestsConfigMapRef;
    private LocalObjectReferenceBuilder manifestsSecretRef;
    private String releaseImage;
    private List<String> sshKnownHosts = new ArrayList<String>();
    private LocalObjectReferenceBuilder sshPrivateKeySecretRef;
    private Map<String, Object> additionalProperties;

    public ProvisioningFluent() {
    }

    public ProvisioningFluent(Provisioning instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Provisioning instance) {
        Provisioning provisioning = instance = instance != null ? instance : new Provisioning();
        if (instance != null) {
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
            this.withInstallerEnv(instance.getInstallerEnv());
            this.withInstallerImageOverride(instance.getInstallerImageOverride());
            this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
            this.withManifestsSecretRef(instance.getManifestsSecretRef());
            this.withReleaseImage(instance.getReleaseImage());
            this.withSshKnownHosts(instance.getSshKnownHosts());
            this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
            this.withInstallerEnv(instance.getInstallerEnv());
            this.withInstallerImageOverride(instance.getInstallerImageOverride());
            this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
            this.withManifestsSecretRef(instance.getManifestsSecretRef());
            this.withReleaseImage(instance.getReleaseImage());
            this.withSshKnownHosts(instance.getSshKnownHosts());
            this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterImageSetReference buildImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    public A withImageSetRef(ClusterImageSetReference imageSetRef) {
        this._visitables.remove(this.imageSetRef);
        if (imageSetRef != null) {
            this.imageSetRef = new ClusterImageSetReferenceBuilder(imageSetRef);
            this._visitables.get("imageSetRef").add(this.imageSetRef);
        } else {
            this.imageSetRef = null;
            this._visitables.get("imageSetRef").remove(this.imageSetRef);
        }
        return (A)this;
    }

    public boolean hasImageSetRef() {
        return this.imageSetRef != null;
    }

    public A withNewImageSetRef(String name) {
        return this.withImageSetRef(new ClusterImageSetReference(name));
    }

    public ImageSetRefNested<A> withNewImageSetRef() {
        return new ImageSetRefNested(null);
    }

    public ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
        return new ImageSetRefNested(item);
    }

    public ImageSetRefNested<A> editImageSetRef() {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(null));
    }

    public ImageSetRefNested<A> editOrNewImageSetRef() {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(new ClusterImageSetReferenceBuilder().build()));
    }

    public ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(item));
    }

    public LocalObjectReference buildInstallConfigSecretRef() {
        return this.installConfigSecretRef != null ? this.installConfigSecretRef.build() : null;
    }

    public A withInstallConfigSecretRef(LocalObjectReference installConfigSecretRef) {
        this._visitables.remove(this.installConfigSecretRef);
        if (installConfigSecretRef != null) {
            this.installConfigSecretRef = new LocalObjectReferenceBuilder(installConfigSecretRef);
            this._visitables.get("installConfigSecretRef").add(this.installConfigSecretRef);
        } else {
            this.installConfigSecretRef = null;
            this._visitables.get("installConfigSecretRef").remove(this.installConfigSecretRef);
        }
        return (A)this;
    }

    public boolean hasInstallConfigSecretRef() {
        return this.installConfigSecretRef != null;
    }

    public A withNewInstallConfigSecretRef(String name) {
        return this.withInstallConfigSecretRef(new LocalObjectReference(name));
    }

    public InstallConfigSecretRefNested<A> withNewInstallConfigSecretRef() {
        return new InstallConfigSecretRefNested(null);
    }

    public InstallConfigSecretRefNested<A> withNewInstallConfigSecretRefLike(LocalObjectReference item) {
        return new InstallConfigSecretRefNested(item);
    }

    public InstallConfigSecretRefNested<A> editInstallConfigSecretRef() {
        return this.withNewInstallConfigSecretRefLike(Optional.ofNullable(this.buildInstallConfigSecretRef()).orElse(null));
    }

    public InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRef() {
        return this.withNewInstallConfigSecretRefLike(Optional.ofNullable(this.buildInstallConfigSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRefLike(LocalObjectReference item) {
        return this.withNewInstallConfigSecretRefLike(Optional.ofNullable(this.buildInstallConfigSecretRef()).orElse(item));
    }

    public A addToInstallerEnv(int index, EnvVar item) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        this.installerEnv.add(index, item);
        return (A)this;
    }

    public A setToInstallerEnv(int index, EnvVar item) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        this.installerEnv.set(index, item);
        return (A)this;
    }

    public A addToInstallerEnv(EnvVar ... items) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.installerEnv.add(item);
        }
        return (A)this;
    }

    public A addAllToInstallerEnv(Collection<EnvVar> items) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.installerEnv.add(item);
        }
        return (A)this;
    }

    public A removeFromInstallerEnv(EnvVar ... items) {
        if (this.installerEnv == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.installerEnv.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromInstallerEnv(Collection<EnvVar> items) {
        if (this.installerEnv == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.installerEnv.remove(item);
        }
        return (A)this;
    }

    public List<EnvVar> getInstallerEnv() {
        return this.installerEnv;
    }

    public EnvVar getInstallerEnv(int index) {
        return this.installerEnv.get(index);
    }

    public EnvVar getFirstInstallerEnv() {
        return this.installerEnv.get(0);
    }

    public EnvVar getLastInstallerEnv() {
        return this.installerEnv.get(this.installerEnv.size() - 1);
    }

    public EnvVar getMatchingInstallerEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.installerEnv) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingInstallerEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.installerEnv) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInstallerEnv(List<EnvVar> installerEnv) {
        if (installerEnv != null) {
            this.installerEnv = new ArrayList<EnvVar>();
            for (EnvVar item : installerEnv) {
                this.addToInstallerEnv(item);
            }
        } else {
            this.installerEnv = null;
        }
        return (A)this;
    }

    public A withInstallerEnv(EnvVar ... installerEnv) {
        if (this.installerEnv != null) {
            this.installerEnv.clear();
            this._visitables.remove("installerEnv");
        }
        if (installerEnv != null) {
            for (EnvVar item : installerEnv) {
                this.addToInstallerEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasInstallerEnv() {
        return this.installerEnv != null && !this.installerEnv.isEmpty();
    }

    public String getInstallerImageOverride() {
        return this.installerImageOverride;
    }

    public A withInstallerImageOverride(String installerImageOverride) {
        this.installerImageOverride = installerImageOverride;
        return (A)this;
    }

    public boolean hasInstallerImageOverride() {
        return this.installerImageOverride != null;
    }

    public LocalObjectReference buildManifestsConfigMapRef() {
        return this.manifestsConfigMapRef != null ? this.manifestsConfigMapRef.build() : null;
    }

    public A withManifestsConfigMapRef(LocalObjectReference manifestsConfigMapRef) {
        this._visitables.remove(this.manifestsConfigMapRef);
        if (manifestsConfigMapRef != null) {
            this.manifestsConfigMapRef = new LocalObjectReferenceBuilder(manifestsConfigMapRef);
            this._visitables.get("manifestsConfigMapRef").add(this.manifestsConfigMapRef);
        } else {
            this.manifestsConfigMapRef = null;
            this._visitables.get("manifestsConfigMapRef").remove(this.manifestsConfigMapRef);
        }
        return (A)this;
    }

    public boolean hasManifestsConfigMapRef() {
        return this.manifestsConfigMapRef != null;
    }

    public A withNewManifestsConfigMapRef(String name) {
        return this.withManifestsConfigMapRef(new LocalObjectReference(name));
    }

    public ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRef() {
        return new ManifestsConfigMapRefNested(null);
    }

    public ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRefLike(LocalObjectReference item) {
        return new ManifestsConfigMapRefNested(item);
    }

    public ManifestsConfigMapRefNested<A> editManifestsConfigMapRef() {
        return this.withNewManifestsConfigMapRefLike(Optional.ofNullable(this.buildManifestsConfigMapRef()).orElse(null));
    }

    public ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRef() {
        return this.withNewManifestsConfigMapRefLike(Optional.ofNullable(this.buildManifestsConfigMapRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRefLike(LocalObjectReference item) {
        return this.withNewManifestsConfigMapRefLike(Optional.ofNullable(this.buildManifestsConfigMapRef()).orElse(item));
    }

    public LocalObjectReference buildManifestsSecretRef() {
        return this.manifestsSecretRef != null ? this.manifestsSecretRef.build() : null;
    }

    public A withManifestsSecretRef(LocalObjectReference manifestsSecretRef) {
        this._visitables.remove(this.manifestsSecretRef);
        if (manifestsSecretRef != null) {
            this.manifestsSecretRef = new LocalObjectReferenceBuilder(manifestsSecretRef);
            this._visitables.get("manifestsSecretRef").add(this.manifestsSecretRef);
        } else {
            this.manifestsSecretRef = null;
            this._visitables.get("manifestsSecretRef").remove(this.manifestsSecretRef);
        }
        return (A)this;
    }

    public boolean hasManifestsSecretRef() {
        return this.manifestsSecretRef != null;
    }

    public A withNewManifestsSecretRef(String name) {
        return this.withManifestsSecretRef(new LocalObjectReference(name));
    }

    public ManifestsSecretRefNested<A> withNewManifestsSecretRef() {
        return new ManifestsSecretRefNested(null);
    }

    public ManifestsSecretRefNested<A> withNewManifestsSecretRefLike(LocalObjectReference item) {
        return new ManifestsSecretRefNested(item);
    }

    public ManifestsSecretRefNested<A> editManifestsSecretRef() {
        return this.withNewManifestsSecretRefLike(Optional.ofNullable(this.buildManifestsSecretRef()).orElse(null));
    }

    public ManifestsSecretRefNested<A> editOrNewManifestsSecretRef() {
        return this.withNewManifestsSecretRefLike(Optional.ofNullable(this.buildManifestsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ManifestsSecretRefNested<A> editOrNewManifestsSecretRefLike(LocalObjectReference item) {
        return this.withNewManifestsSecretRefLike(Optional.ofNullable(this.buildManifestsSecretRef()).orElse(item));
    }

    public String getReleaseImage() {
        return this.releaseImage;
    }

    public A withReleaseImage(String releaseImage) {
        this.releaseImage = releaseImage;
        return (A)this;
    }

    public boolean hasReleaseImage() {
        return this.releaseImage != null;
    }

    public A addToSshKnownHosts(int index, String item) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        this.sshKnownHosts.add(index, item);
        return (A)this;
    }

    public A setToSshKnownHosts(int index, String item) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        this.sshKnownHosts.set(index, item);
        return (A)this;
    }

    public A addToSshKnownHosts(String ... items) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.sshKnownHosts.add(item);
        }
        return (A)this;
    }

    public A addAllToSshKnownHosts(Collection<String> items) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.sshKnownHosts.add(item);
        }
        return (A)this;
    }

    public A removeFromSshKnownHosts(String ... items) {
        if (this.sshKnownHosts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.sshKnownHosts.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSshKnownHosts(Collection<String> items) {
        if (this.sshKnownHosts == null) {
            return (A)this;
        }
        for (String item : items) {
            this.sshKnownHosts.remove(item);
        }
        return (A)this;
    }

    public List<String> getSshKnownHosts() {
        return this.sshKnownHosts;
    }

    public String getSshKnownHost(int index) {
        return this.sshKnownHosts.get(index);
    }

    public String getFirstSshKnownHost() {
        return this.sshKnownHosts.get(0);
    }

    public String getLastSshKnownHost() {
        return this.sshKnownHosts.get(this.sshKnownHosts.size() - 1);
    }

    public String getMatchingSshKnownHost(Predicate<String> predicate) {
        for (String item : this.sshKnownHosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSshKnownHost(Predicate<String> predicate) {
        for (String item : this.sshKnownHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSshKnownHosts(List<String> sshKnownHosts) {
        if (sshKnownHosts != null) {
            this.sshKnownHosts = new ArrayList<String>();
            for (String item : sshKnownHosts) {
                this.addToSshKnownHosts(item);
            }
        } else {
            this.sshKnownHosts = null;
        }
        return (A)this;
    }

    public A withSshKnownHosts(String ... sshKnownHosts) {
        if (this.sshKnownHosts != null) {
            this.sshKnownHosts.clear();
            this._visitables.remove("sshKnownHosts");
        }
        if (sshKnownHosts != null) {
            for (String item : sshKnownHosts) {
                this.addToSshKnownHosts(item);
            }
        }
        return (A)this;
    }

    public boolean hasSshKnownHosts() {
        return this.sshKnownHosts != null && !this.sshKnownHosts.isEmpty();
    }

    public LocalObjectReference buildSshPrivateKeySecretRef() {
        return this.sshPrivateKeySecretRef != null ? this.sshPrivateKeySecretRef.build() : null;
    }

    public A withSshPrivateKeySecretRef(LocalObjectReference sshPrivateKeySecretRef) {
        this._visitables.remove(this.sshPrivateKeySecretRef);
        if (sshPrivateKeySecretRef != null) {
            this.sshPrivateKeySecretRef = new LocalObjectReferenceBuilder(sshPrivateKeySecretRef);
            this._visitables.get("sshPrivateKeySecretRef").add(this.sshPrivateKeySecretRef);
        } else {
            this.sshPrivateKeySecretRef = null;
            this._visitables.get("sshPrivateKeySecretRef").remove(this.sshPrivateKeySecretRef);
        }
        return (A)this;
    }

    public boolean hasSshPrivateKeySecretRef() {
        return this.sshPrivateKeySecretRef != null;
    }

    public A withNewSshPrivateKeySecretRef(String name) {
        return this.withSshPrivateKeySecretRef(new LocalObjectReference(name));
    }

    public SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRef() {
        return new SshPrivateKeySecretRefNested(null);
    }

    public SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
        return new SshPrivateKeySecretRefNested(item);
    }

    public SshPrivateKeySecretRefNested<A> editSshPrivateKeySecretRef() {
        return this.withNewSshPrivateKeySecretRefLike(Optional.ofNullable(this.buildSshPrivateKeySecretRef()).orElse(null));
    }

    public SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRef() {
        return this.withNewSshPrivateKeySecretRefLike(Optional.ofNullable(this.buildSshPrivateKeySecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
        return this.withNewSshPrivateKeySecretRefLike(Optional.ofNullable(this.buildSshPrivateKeySecretRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProvisioningFluent that = (ProvisioningFluent)o;
        if (!Objects.equals(this.imageSetRef, that.imageSetRef)) {
            return false;
        }
        if (!Objects.equals(this.installConfigSecretRef, that.installConfigSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.installerEnv, that.installerEnv)) {
            return false;
        }
        if (!Objects.equals(this.installerImageOverride, that.installerImageOverride)) {
            return false;
        }
        if (!Objects.equals(this.manifestsConfigMapRef, that.manifestsConfigMapRef)) {
            return false;
        }
        if (!Objects.equals(this.manifestsSecretRef, that.manifestsSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.releaseImage, that.releaseImage)) {
            return false;
        }
        if (!Objects.equals(this.sshKnownHosts, that.sshKnownHosts)) {
            return false;
        }
        if (!Objects.equals(this.sshPrivateKeySecretRef, that.sshPrivateKeySecretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.imageSetRef, this.installConfigSecretRef, this.installerEnv, this.installerImageOverride, this.manifestsConfigMapRef, this.manifestsSecretRef, this.releaseImage, this.sshKnownHosts, this.sshPrivateKeySecretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageSetRef != null) {
            sb.append("imageSetRef:");
            sb.append(this.imageSetRef + ",");
        }
        if (this.installConfigSecretRef != null) {
            sb.append("installConfigSecretRef:");
            sb.append(this.installConfigSecretRef + ",");
        }
        if (this.installerEnv != null && !this.installerEnv.isEmpty()) {
            sb.append("installerEnv:");
            sb.append(this.installerEnv + ",");
        }
        if (this.installerImageOverride != null) {
            sb.append("installerImageOverride:");
            sb.append(this.installerImageOverride + ",");
        }
        if (this.manifestsConfigMapRef != null) {
            sb.append("manifestsConfigMapRef:");
            sb.append(this.manifestsConfigMapRef + ",");
        }
        if (this.manifestsSecretRef != null) {
            sb.append("manifestsSecretRef:");
            sb.append(this.manifestsSecretRef + ",");
        }
        if (this.releaseImage != null) {
            sb.append("releaseImage:");
            sb.append(this.releaseImage + ",");
        }
        if (this.sshKnownHosts != null && !this.sshKnownHosts.isEmpty()) {
            sb.append("sshKnownHosts:");
            sb.append(this.sshKnownHosts + ",");
        }
        if (this.sshPrivateKeySecretRef != null) {
            sb.append("sshPrivateKeySecretRef:");
            sb.append(this.sshPrivateKeySecretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SshPrivateKeySecretRefNested<N>
    extends LocalObjectReferenceFluent<SshPrivateKeySecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SshPrivateKeySecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluent.this.withSshPrivateKeySecretRef(this.builder.build());
        }

        public N endSshPrivateKeySecretRef() {
            return this.and();
        }
    }

    public class ManifestsSecretRefNested<N>
    extends LocalObjectReferenceFluent<ManifestsSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ManifestsSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluent.this.withManifestsSecretRef(this.builder.build());
        }

        public N endManifestsSecretRef() {
            return this.and();
        }
    }

    public class ManifestsConfigMapRefNested<N>
    extends LocalObjectReferenceFluent<ManifestsConfigMapRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ManifestsConfigMapRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluent.this.withManifestsConfigMapRef(this.builder.build());
        }

        public N endManifestsConfigMapRef() {
            return this.and();
        }
    }

    public class InstallConfigSecretRefNested<N>
    extends LocalObjectReferenceFluent<InstallConfigSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstallConfigSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluent.this.withInstallConfigSecretRef(this.builder.build());
        }

        public N endInstallConfigSecretRef() {
            return this.and();
        }
    }

    public class ImageSetRefNested<N>
    extends ClusterImageSetReferenceFluent<ImageSetRefNested<N>>
    implements Nested<N> {
        ClusterImageSetReferenceBuilder builder;

        ImageSetRefNested(ClusterImageSetReference item) {
            this.builder = new ClusterImageSetReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluent.this.withImageSetRef(this.builder.build());
        }

        public N endImageSetRef() {
            return this.and();
        }
    }
}

