/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimitBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimitFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRange;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRangeBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRangeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceLimitsFluent<A extends ResourceLimitsFluent<A>>
extends BaseFluent<A> {
    private ResourceRangeBuilder cores;
    private ArrayList<GPULimitBuilder> gpus = new ArrayList();
    private Integer maxNodesTotal;
    private ResourceRangeBuilder memory;
    private Map<String, Object> additionalProperties;

    public ResourceLimitsFluent() {
    }

    public ResourceLimitsFluent(ResourceLimits instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceLimits instance) {
        ResourceLimits resourceLimits = instance = instance != null ? instance : new ResourceLimits();
        if (instance != null) {
            this.withCores(instance.getCores());
            this.withGpus(instance.getGpus());
            this.withMaxNodesTotal(instance.getMaxNodesTotal());
            this.withMemory(instance.getMemory());
            this.withCores(instance.getCores());
            this.withGpus(instance.getGpus());
            this.withMaxNodesTotal(instance.getMaxNodesTotal());
            this.withMemory(instance.getMemory());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResourceRange buildCores() {
        return this.cores != null ? this.cores.build() : null;
    }

    public A withCores(ResourceRange cores) {
        this._visitables.remove(this.cores);
        if (cores != null) {
            this.cores = new ResourceRangeBuilder(cores);
            this._visitables.get("cores").add(this.cores);
        } else {
            this.cores = null;
            this._visitables.get("cores").remove(this.cores);
        }
        return (A)this;
    }

    public boolean hasCores() {
        return this.cores != null;
    }

    public A withNewCores(Integer max, Integer min) {
        return this.withCores(new ResourceRange(max, min));
    }

    public CoresNested<A> withNewCores() {
        return new CoresNested(null);
    }

    public CoresNested<A> withNewCoresLike(ResourceRange item) {
        return new CoresNested(item);
    }

    public CoresNested<A> editCores() {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(null));
    }

    public CoresNested<A> editOrNewCores() {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(new ResourceRangeBuilder().build()));
    }

    public CoresNested<A> editOrNewCoresLike(ResourceRange item) {
        return this.withNewCoresLike(Optional.ofNullable(this.buildCores()).orElse(item));
    }

    public A addToGpus(int index, GPULimit item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        GPULimitBuilder builder = new GPULimitBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get("gpus").add(index, builder);
            this.gpus.add(index, builder);
        }
        return (A)this;
    }

    public A setToGpus(int index, GPULimit item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        GPULimitBuilder builder = new GPULimitBuilder(item);
        if (index < 0 || index >= this.gpus.size()) {
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        } else {
            this._visitables.get("gpus").set(index, builder);
            this.gpus.set(index, builder);
        }
        return (A)this;
    }

    public A addToGpus(GPULimit ... items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)this;
    }

    public A addAllToGpus(Collection<GPULimit> items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList();
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)this;
    }

    public A removeFromGpus(GPULimit ... items) {
        if (this.gpus == null) {
            return (A)this;
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").remove(builder);
            this.gpus.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromGpus(Collection<GPULimit> items) {
        if (this.gpus == null) {
            return (A)this;
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").remove(builder);
            this.gpus.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromGpus(Predicate<GPULimitBuilder> predicate) {
        if (this.gpus == null) {
            return (A)this;
        }
        Iterator<GPULimitBuilder> each = this.gpus.iterator();
        Object visitables = this._visitables.get("gpus");
        while (each.hasNext()) {
            GPULimitBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GPULimit> buildGpus() {
        return this.gpus != null ? ResourceLimitsFluent.build(this.gpus) : null;
    }

    public GPULimit buildGpus(int index) {
        return this.gpus.get(index).build();
    }

    public GPULimit buildFirstGpus() {
        return this.gpus.get(0).build();
    }

    public GPULimit buildLastGpus() {
        return this.gpus.get(this.gpus.size() - 1).build();
    }

    public GPULimit buildMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        for (GPULimitBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        for (GPULimitBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGpus(List<GPULimit> gpus) {
        if (this.gpus != null) {
            this._visitables.get("gpus").clear();
        }
        if (gpus != null) {
            this.gpus = new ArrayList();
            for (GPULimit item : gpus) {
                this.addToGpus(item);
            }
        } else {
            this.gpus = null;
        }
        return (A)this;
    }

    public A withGpus(GPULimit ... gpus) {
        if (this.gpus != null) {
            this.gpus.clear();
            this._visitables.remove("gpus");
        }
        if (gpus != null) {
            for (GPULimit item : gpus) {
                this.addToGpus(item);
            }
        }
        return (A)this;
    }

    public boolean hasGpus() {
        return this.gpus != null && !this.gpus.isEmpty();
    }

    public A addNewGpus(Integer max, Integer min, String type) {
        return this.addToGpus(new GPULimit(max, min, type));
    }

    public GpusNested<A> addNewGpus() {
        return new GpusNested(-1, null);
    }

    public GpusNested<A> addNewGpusLike(GPULimit item) {
        return new GpusNested(-1, item);
    }

    public GpusNested<A> setNewGpusLike(int index, GPULimit item) {
        return new GpusNested(index, item);
    }

    public GpusNested<A> editGpus(int index) {
        if (this.gpus.size() <= index) {
            throw new RuntimeException("Can't edit gpus. Index exceeds size.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editFirstGpus() {
        if (this.gpus.size() == 0) {
            throw new RuntimeException("Can't edit first gpus. The list is empty.");
        }
        return this.setNewGpusLike(0, this.buildGpus(0));
    }

    public GpusNested<A> editLastGpus() {
        int index = this.gpus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gpus. The list is empty.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public GpusNested<A> editMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gpus.size(); ++i) {
            if (!predicate.test(this.gpus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gpus. No match found.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    public Integer getMaxNodesTotal() {
        return this.maxNodesTotal;
    }

    public A withMaxNodesTotal(Integer maxNodesTotal) {
        this.maxNodesTotal = maxNodesTotal;
        return (A)this;
    }

    public boolean hasMaxNodesTotal() {
        return this.maxNodesTotal != null;
    }

    public ResourceRange buildMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    public A withMemory(ResourceRange memory) {
        this._visitables.remove(this.memory);
        if (memory != null) {
            this.memory = new ResourceRangeBuilder(memory);
            this._visitables.get("memory").add(this.memory);
        } else {
            this.memory = null;
            this._visitables.get("memory").remove(this.memory);
        }
        return (A)this;
    }

    public boolean hasMemory() {
        return this.memory != null;
    }

    public A withNewMemory(Integer max, Integer min) {
        return this.withMemory(new ResourceRange(max, min));
    }

    public MemoryNested<A> withNewMemory() {
        return new MemoryNested(null);
    }

    public MemoryNested<A> withNewMemoryLike(ResourceRange item) {
        return new MemoryNested(item);
    }

    public MemoryNested<A> editMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(null));
    }

    public MemoryNested<A> editOrNewMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(new ResourceRangeBuilder().build()));
    }

    public MemoryNested<A> editOrNewMemoryLike(ResourceRange item) {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceLimitsFluent that = (ResourceLimitsFluent)o;
        if (!Objects.equals(this.cores, that.cores)) {
            return false;
        }
        if (!Objects.equals(this.gpus, that.gpus)) {
            return false;
        }
        if (!Objects.equals(this.maxNodesTotal, that.maxNodesTotal)) {
            return false;
        }
        if (!Objects.equals(this.memory, that.memory)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cores, this.gpus, this.maxNodesTotal, this.memory, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cores != null) {
            sb.append("cores:");
            sb.append(this.cores + ",");
        }
        if (this.gpus != null && !this.gpus.isEmpty()) {
            sb.append("gpus:");
            sb.append(this.gpus + ",");
        }
        if (this.maxNodesTotal != null) {
            sb.append("maxNodesTotal:");
            sb.append(this.maxNodesTotal + ",");
        }
        if (this.memory != null) {
            sb.append("memory:");
            sb.append(this.memory + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MemoryNested<N>
    extends ResourceRangeFluent<MemoryNested<N>>
    implements Nested<N> {
        ResourceRangeBuilder builder;

        MemoryNested(ResourceRange item) {
            this.builder = new ResourceRangeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluent.this.withMemory(this.builder.build());
        }

        public N endMemory() {
            return this.and();
        }
    }

    public class GpusNested<N>
    extends GPULimitFluent<GpusNested<N>>
    implements Nested<N> {
        GPULimitBuilder builder;
        int index;

        GpusNested(int index, GPULimit item) {
            this.index = index;
            this.builder = new GPULimitBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluent.this.setToGpus(this.index, this.builder.build());
        }

        public N endGpus() {
            return this.and();
        }
    }

    public class CoresNested<N>
    extends ResourceRangeFluent<CoresNested<N>>
    implements Nested<N> {
        ResourceRangeBuilder builder;

        CoresNested(ResourceRange item) {
            this.builder = new ResourceRangeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluent.this.withCores(this.builder.build());
        }

        public N endCores() {
            return this.and();
        }
    }
}

