/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.FlowDistinguisherMethod;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.FlowDistinguisherMethodBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.FlowDistinguisherMethodFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.FlowSchemaSpec;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PolicyRulesWithSubjects;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PolicyRulesWithSubjectsBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PolicyRulesWithSubjectsFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PriorityLevelConfigurationReference;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PriorityLevelConfigurationReferenceBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.PriorityLevelConfigurationReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class FlowSchemaSpecFluent<A extends FlowSchemaSpecFluent<A>>
extends BaseFluent<A> {
    private FlowDistinguisherMethodBuilder distinguisherMethod;
    private Integer matchingPrecedence;
    private PriorityLevelConfigurationReferenceBuilder priorityLevelConfiguration;
    private ArrayList<PolicyRulesWithSubjectsBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public FlowSchemaSpecFluent() {
    }

    public FlowSchemaSpecFluent(FlowSchemaSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FlowSchemaSpec instance) {
        FlowSchemaSpec flowSchemaSpec = instance = instance != null ? instance : new FlowSchemaSpec();
        if (instance != null) {
            this.withDistinguisherMethod(instance.getDistinguisherMethod());
            this.withMatchingPrecedence(instance.getMatchingPrecedence());
            this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());
            this.withRules(instance.getRules());
            this.withDistinguisherMethod(instance.getDistinguisherMethod());
            this.withMatchingPrecedence(instance.getMatchingPrecedence());
            this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FlowDistinguisherMethod buildDistinguisherMethod() {
        return this.distinguisherMethod != null ? this.distinguisherMethod.build() : null;
    }

    public A withDistinguisherMethod(FlowDistinguisherMethod distinguisherMethod) {
        this._visitables.remove(this.distinguisherMethod);
        if (distinguisherMethod != null) {
            this.distinguisherMethod = new FlowDistinguisherMethodBuilder(distinguisherMethod);
            this._visitables.get("distinguisherMethod").add(this.distinguisherMethod);
        } else {
            this.distinguisherMethod = null;
            this._visitables.get("distinguisherMethod").remove(this.distinguisherMethod);
        }
        return (A)this;
    }

    public boolean hasDistinguisherMethod() {
        return this.distinguisherMethod != null;
    }

    public A withNewDistinguisherMethod(String type) {
        return this.withDistinguisherMethod(new FlowDistinguisherMethod(type));
    }

    public DistinguisherMethodNested<A> withNewDistinguisherMethod() {
        return new DistinguisherMethodNested(null);
    }

    public DistinguisherMethodNested<A> withNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
        return new DistinguisherMethodNested(item);
    }

    public DistinguisherMethodNested<A> editDistinguisherMethod() {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(null));
    }

    public DistinguisherMethodNested<A> editOrNewDistinguisherMethod() {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(new FlowDistinguisherMethodBuilder().build()));
    }

    public DistinguisherMethodNested<A> editOrNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
        return this.withNewDistinguisherMethodLike(Optional.ofNullable(this.buildDistinguisherMethod()).orElse(item));
    }

    public Integer getMatchingPrecedence() {
        return this.matchingPrecedence;
    }

    public A withMatchingPrecedence(Integer matchingPrecedence) {
        this.matchingPrecedence = matchingPrecedence;
        return (A)this;
    }

    public boolean hasMatchingPrecedence() {
        return this.matchingPrecedence != null;
    }

    public PriorityLevelConfigurationReference buildPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration != null ? this.priorityLevelConfiguration.build() : null;
    }

    public A withPriorityLevelConfiguration(PriorityLevelConfigurationReference priorityLevelConfiguration) {
        this._visitables.remove(this.priorityLevelConfiguration);
        if (priorityLevelConfiguration != null) {
            this.priorityLevelConfiguration = new PriorityLevelConfigurationReferenceBuilder(priorityLevelConfiguration);
            this._visitables.get("priorityLevelConfiguration").add(this.priorityLevelConfiguration);
        } else {
            this.priorityLevelConfiguration = null;
            this._visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration);
        }
        return (A)this;
    }

    public boolean hasPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration != null;
    }

    public A withNewPriorityLevelConfiguration(String name) {
        return this.withPriorityLevelConfiguration(new PriorityLevelConfigurationReference(name));
    }

    public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfiguration() {
        return new PriorityLevelConfigurationNested(null);
    }

    public PriorityLevelConfigurationNested<A> withNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
        return new PriorityLevelConfigurationNested(item);
    }

    public PriorityLevelConfigurationNested<A> editPriorityLevelConfiguration() {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(null));
    }

    public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfiguration() {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(new PriorityLevelConfigurationReferenceBuilder().build()));
    }

    public PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
        return this.withNewPriorityLevelConfigurationLike(Optional.ofNullable(this.buildPriorityLevelConfiguration()).orElse(item));
    }

    public A addToRules(int index, PolicyRulesWithSubjects item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, PolicyRulesWithSubjects item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(PolicyRulesWithSubjects ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PolicyRulesWithSubjects item : items) {
            PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<PolicyRulesWithSubjects> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PolicyRulesWithSubjects item : items) {
            PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(PolicyRulesWithSubjects ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRulesWithSubjects item : items) {
            PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRulesWithSubjects> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRulesWithSubjects item : items) {
            PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<PolicyRulesWithSubjectsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            PolicyRulesWithSubjectsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PolicyRulesWithSubjects> buildRules() {
        return this.rules != null ? FlowSchemaSpecFluent.build(this.rules) : null;
    }

    public PolicyRulesWithSubjects buildRule(int index) {
        return this.rules.get(index).build();
    }

    public PolicyRulesWithSubjects buildFirstRule() {
        return this.rules.get(0).build();
    }

    public PolicyRulesWithSubjects buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public PolicyRulesWithSubjects buildMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
        for (PolicyRulesWithSubjectsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
        for (PolicyRulesWithSubjectsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<PolicyRulesWithSubjects> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (PolicyRulesWithSubjects item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(PolicyRulesWithSubjects ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (PolicyRulesWithSubjects item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(PolicyRulesWithSubjects item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, PolicyRulesWithSubjects item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowSchemaSpecFluent that = (FlowSchemaSpecFluent)o;
        if (!Objects.equals(this.distinguisherMethod, that.distinguisherMethod)) {
            return false;
        }
        if (!Objects.equals(this.matchingPrecedence, that.matchingPrecedence)) {
            return false;
        }
        if (!Objects.equals(this.priorityLevelConfiguration, that.priorityLevelConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinguisherMethod, this.matchingPrecedence, this.priorityLevelConfiguration, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.distinguisherMethod != null) {
            sb.append("distinguisherMethod:");
            sb.append(this.distinguisherMethod + ",");
        }
        if (this.matchingPrecedence != null) {
            sb.append("matchingPrecedence:");
            sb.append(this.matchingPrecedence + ",");
        }
        if (this.priorityLevelConfiguration != null) {
            sb.append("priorityLevelConfiguration:");
            sb.append(this.priorityLevelConfiguration + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends PolicyRulesWithSubjectsFluent<RulesNested<N>>
    implements Nested<N> {
        PolicyRulesWithSubjectsBuilder builder;
        int index;

        RulesNested(int index, PolicyRulesWithSubjects item) {
            this.index = index;
            this.builder = new PolicyRulesWithSubjectsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FlowSchemaSpecFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class PriorityLevelConfigurationNested<N>
    extends PriorityLevelConfigurationReferenceFluent<PriorityLevelConfigurationNested<N>>
    implements Nested<N> {
        PriorityLevelConfigurationReferenceBuilder builder;

        PriorityLevelConfigurationNested(PriorityLevelConfigurationReference item) {
            this.builder = new PriorityLevelConfigurationReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FlowSchemaSpecFluent.this.withPriorityLevelConfiguration(this.builder.build());
        }

        public N endPriorityLevelConfiguration() {
            return this.and();
        }
    }

    public class DistinguisherMethodNested<N>
    extends FlowDistinguisherMethodFluent<DistinguisherMethodNested<N>>
    implements Nested<N> {
        FlowDistinguisherMethodBuilder builder;

        DistinguisherMethodNested(FlowDistinguisherMethod item) {
            this.builder = new FlowDistinguisherMethodBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FlowSchemaSpecFluent.this.withDistinguisherMethod(this.builder.build());
        }

        public N endDistinguisherMethod() {
            return this.and();
        }
    }
}

