/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TopologySpreadConstraintFluent<A extends TopologySpreadConstraintFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<String> matchLabelKeys = new ArrayList<String>();
    private Integer maxSkew;
    private Integer minDomains;
    private String nodeAffinityPolicy;
    private String nodeTaintsPolicy;
    private String topologyKey;
    private String whenUnsatisfiable;
    private Map<String, Object> additionalProperties;

    public TopologySpreadConstraintFluent() {
    }

    public TopologySpreadConstraintFluent(TopologySpreadConstraint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TopologySpreadConstraint instance) {
        TopologySpreadConstraint topologySpreadConstraint = instance = instance != null ? instance : new TopologySpreadConstraint();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withMatchLabelKeys(instance.getMatchLabelKeys());
            this.withMaxSkew(instance.getMaxSkew());
            this.withMinDomains(instance.getMinDomains());
            this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
            this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
            this.withTopologyKey(instance.getTopologyKey());
            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
            this.withLabelSelector(instance.getLabelSelector());
            this.withMatchLabelKeys(instance.getMatchLabelKeys());
            this.withMaxSkew(instance.getMaxSkew());
            this.withMinDomains(instance.getMinDomains());
            this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
            this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
            this.withTopologyKey(instance.getTopologyKey());
            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public A addToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(index, item);
        return (A)this;
    }

    public A setToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.set(index, item);
        return (A)this;
    }

    public A addToMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    public A addAllToMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    public A removeFromMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    public String getMatchLabelKey(int index) {
        return this.matchLabelKeys.get(index);
    }

    public String getFirstMatchLabelKey() {
        return this.matchLabelKeys.get(0);
    }

    public String getLastMatchLabelKey() {
        return this.matchLabelKeys.get(this.matchLabelKeys.size() - 1);
    }

    public String getMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchLabelKeys(List<String> matchLabelKeys) {
        if (matchLabelKeys != null) {
            this.matchLabelKeys = new ArrayList<String>();
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        } else {
            this.matchLabelKeys = null;
        }
        return (A)this;
    }

    public A withMatchLabelKeys(String ... matchLabelKeys) {
        if (this.matchLabelKeys != null) {
            this.matchLabelKeys.clear();
            this._visitables.remove("matchLabelKeys");
        }
        if (matchLabelKeys != null) {
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchLabelKeys() {
        return this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty();
    }

    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return (A)this;
    }

    public boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    public Integer getMinDomains() {
        return this.minDomains;
    }

    public A withMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return (A)this;
    }

    public boolean hasMinDomains() {
        return this.minDomains != null;
    }

    public String getNodeAffinityPolicy() {
        return this.nodeAffinityPolicy;
    }

    public A withNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
        return (A)this;
    }

    public boolean hasNodeAffinityPolicy() {
        return this.nodeAffinityPolicy != null;
    }

    public String getNodeTaintsPolicy() {
        return this.nodeTaintsPolicy;
    }

    public A withNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
        return (A)this;
    }

    public boolean hasNodeTaintsPolicy() {
        return this.nodeTaintsPolicy != null;
    }

    public String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    public boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return (A)this;
    }

    public boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopologySpreadConstraintFluent that = (TopologySpreadConstraintFluent)o;
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.matchLabelKeys, that.matchLabelKeys)) {
            return false;
        }
        if (!Objects.equals(this.maxSkew, that.maxSkew)) {
            return false;
        }
        if (!Objects.equals(this.minDomains, that.minDomains)) {
            return false;
        }
        if (!Objects.equals(this.nodeAffinityPolicy, that.nodeAffinityPolicy)) {
            return false;
        }
        if (!Objects.equals(this.nodeTaintsPolicy, that.nodeTaintsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.topologyKey, that.topologyKey)) {
            return false;
        }
        if (!Objects.equals(this.whenUnsatisfiable, that.whenUnsatisfiable)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.maxSkew, this.minDomains, this.nodeAffinityPolicy, this.nodeTaintsPolicy, this.topologyKey, this.whenUnsatisfiable, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty()) {
            sb.append("matchLabelKeys:");
            sb.append(this.matchLabelKeys + ",");
        }
        if (this.maxSkew != null) {
            sb.append("maxSkew:");
            sb.append(this.maxSkew + ",");
        }
        if (this.minDomains != null) {
            sb.append("minDomains:");
            sb.append(this.minDomains + ",");
        }
        if (this.nodeAffinityPolicy != null) {
            sb.append("nodeAffinityPolicy:");
            sb.append(this.nodeAffinityPolicy + ",");
        }
        if (this.nodeTaintsPolicy != null) {
            sb.append("nodeTaintsPolicy:");
            sb.append(this.nodeTaintsPolicy + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.whenUnsatisfiable != null) {
            sb.append("whenUnsatisfiable:");
            sb.append(this.whenUnsatisfiable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TopologySpreadConstraintFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

