/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.operator.v1.GCPCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.v6_9.operator.v1.GCPKMSKeyReference;
import io.fabric8.openshift.api.model.v6_9.operator.v1.GCPKMSKeyReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.GCPKMSKeyReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GCPCSIDriverConfigSpecFluent<A extends GCPCSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private GCPKMSKeyReferenceBuilder kmsKey;
    private Map<String, Object> additionalProperties;

    public GCPCSIDriverConfigSpecFluent() {
    }

    public GCPCSIDriverConfigSpecFluent(GCPCSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPCSIDriverConfigSpec instance) {
        GCPCSIDriverConfigSpec gCPCSIDriverConfigSpec = instance = instance != null ? instance : new GCPCSIDriverConfigSpec();
        if (instance != null) {
            this.withKmsKey(instance.getKmsKey());
            this.withKmsKey(instance.getKmsKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public GCPKMSKeyReference buildKmsKey() {
        return this.kmsKey != null ? this.kmsKey.build() : null;
    }

    public A withKmsKey(GCPKMSKeyReference kmsKey) {
        this._visitables.remove(this.kmsKey);
        if (kmsKey != null) {
            this.kmsKey = new GCPKMSKeyReferenceBuilder(kmsKey);
            this._visitables.get("kmsKey").add(this.kmsKey);
        } else {
            this.kmsKey = null;
            this._visitables.get("kmsKey").remove(this.kmsKey);
        }
        return (A)this;
    }

    public boolean hasKmsKey() {
        return this.kmsKey != null;
    }

    public A withNewKmsKey(String keyRing, String location, String name, String projectID) {
        return this.withKmsKey(new GCPKMSKeyReference(keyRing, location, name, projectID));
    }

    public KmsKeyNested<A> withNewKmsKey() {
        return new KmsKeyNested(null);
    }

    public KmsKeyNested<A> withNewKmsKeyLike(GCPKMSKeyReference item) {
        return new KmsKeyNested(item);
    }

    public KmsKeyNested<A> editKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(null));
    }

    public KmsKeyNested<A> editOrNewKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(new GCPKMSKeyReferenceBuilder().build()));
    }

    public KmsKeyNested<A> editOrNewKmsKeyLike(GCPKMSKeyReference item) {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPCSIDriverConfigSpecFluent that = (GCPCSIDriverConfigSpecFluent)o;
        if (!Objects.equals(this.kmsKey, that.kmsKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kmsKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kmsKey != null) {
            sb.append("kmsKey:");
            sb.append(this.kmsKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KmsKeyNested<N>
    extends GCPKMSKeyReferenceFluent<KmsKeyNested<N>>
    implements Nested<N> {
        GCPKMSKeyReferenceBuilder builder;

        KmsKeyNested(GCPKMSKeyReference item) {
            this.builder = new GCPKMSKeyReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GCPCSIDriverConfigSpecFluent.this.withKmsKey(this.builder.build());
        }

        public N endKmsKey() {
            return this.and();
        }
    }
}

