/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.installer.ibmcloud.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_9.installer.ibmcloud.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_9.installer.ibmcloud.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_9.installer.ibmcloud.v1.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private List<String> computeSubnets = new ArrayList<String>();
    private List<String> controlPlaneSubnets = new ArrayList<String>();
    private MachinePoolBuilder defaultMachinePlatform;
    private String networkResourceGroupName;
    private String region;
    private String resourceGroupName;
    private String vpcName;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withComputeSubnets(instance.getComputeSubnets());
            this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withRegion(instance.getRegion());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withVpcName(instance.getVpcName());
            this.withComputeSubnets(instance.getComputeSubnets());
            this.withControlPlaneSubnets(instance.getControlPlaneSubnets());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withRegion(instance.getRegion());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withVpcName(instance.getVpcName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToComputeSubnets(int index, String item) {
        if (this.computeSubnets == null) {
            this.computeSubnets = new ArrayList<String>();
        }
        this.computeSubnets.add(index, item);
        return (A)this;
    }

    public A setToComputeSubnets(int index, String item) {
        if (this.computeSubnets == null) {
            this.computeSubnets = new ArrayList<String>();
        }
        this.computeSubnets.set(index, item);
        return (A)this;
    }

    public A addToComputeSubnets(String ... items) {
        if (this.computeSubnets == null) {
            this.computeSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.computeSubnets.add(item);
        }
        return (A)this;
    }

    public A addAllToComputeSubnets(Collection<String> items) {
        if (this.computeSubnets == null) {
            this.computeSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.computeSubnets.add(item);
        }
        return (A)this;
    }

    public A removeFromComputeSubnets(String ... items) {
        if (this.computeSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.computeSubnets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromComputeSubnets(Collection<String> items) {
        if (this.computeSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.computeSubnets.remove(item);
        }
        return (A)this;
    }

    public List<String> getComputeSubnets() {
        return this.computeSubnets;
    }

    public String getComputeSubnet(int index) {
        return this.computeSubnets.get(index);
    }

    public String getFirstComputeSubnet() {
        return this.computeSubnets.get(0);
    }

    public String getLastComputeSubnet() {
        return this.computeSubnets.get(this.computeSubnets.size() - 1);
    }

    public String getMatchingComputeSubnet(Predicate<String> predicate) {
        for (String item : this.computeSubnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingComputeSubnet(Predicate<String> predicate) {
        for (String item : this.computeSubnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComputeSubnets(List<String> computeSubnets) {
        if (computeSubnets != null) {
            this.computeSubnets = new ArrayList<String>();
            for (String item : computeSubnets) {
                this.addToComputeSubnets(item);
            }
        } else {
            this.computeSubnets = null;
        }
        return (A)this;
    }

    public A withComputeSubnets(String ... computeSubnets) {
        if (this.computeSubnets != null) {
            this.computeSubnets.clear();
            this._visitables.remove("computeSubnets");
        }
        if (computeSubnets != null) {
            for (String item : computeSubnets) {
                this.addToComputeSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasComputeSubnets() {
        return this.computeSubnets != null && !this.computeSubnets.isEmpty();
    }

    public A addToControlPlaneSubnets(int index, String item) {
        if (this.controlPlaneSubnets == null) {
            this.controlPlaneSubnets = new ArrayList<String>();
        }
        this.controlPlaneSubnets.add(index, item);
        return (A)this;
    }

    public A setToControlPlaneSubnets(int index, String item) {
        if (this.controlPlaneSubnets == null) {
            this.controlPlaneSubnets = new ArrayList<String>();
        }
        this.controlPlaneSubnets.set(index, item);
        return (A)this;
    }

    public A addToControlPlaneSubnets(String ... items) {
        if (this.controlPlaneSubnets == null) {
            this.controlPlaneSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlPlaneSubnets.add(item);
        }
        return (A)this;
    }

    public A addAllToControlPlaneSubnets(Collection<String> items) {
        if (this.controlPlaneSubnets == null) {
            this.controlPlaneSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlPlaneSubnets.add(item);
        }
        return (A)this;
    }

    public A removeFromControlPlaneSubnets(String ... items) {
        if (this.controlPlaneSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.controlPlaneSubnets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromControlPlaneSubnets(Collection<String> items) {
        if (this.controlPlaneSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.controlPlaneSubnets.remove(item);
        }
        return (A)this;
    }

    public List<String> getControlPlaneSubnets() {
        return this.controlPlaneSubnets;
    }

    public String getControlPlaneSubnet(int index) {
        return this.controlPlaneSubnets.get(index);
    }

    public String getFirstControlPlaneSubnet() {
        return this.controlPlaneSubnets.get(0);
    }

    public String getLastControlPlaneSubnet() {
        return this.controlPlaneSubnets.get(this.controlPlaneSubnets.size() - 1);
    }

    public String getMatchingControlPlaneSubnet(Predicate<String> predicate) {
        for (String item : this.controlPlaneSubnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingControlPlaneSubnet(Predicate<String> predicate) {
        for (String item : this.controlPlaneSubnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withControlPlaneSubnets(List<String> controlPlaneSubnets) {
        if (controlPlaneSubnets != null) {
            this.controlPlaneSubnets = new ArrayList<String>();
            for (String item : controlPlaneSubnets) {
                this.addToControlPlaneSubnets(item);
            }
        } else {
            this.controlPlaneSubnets = null;
        }
        return (A)this;
    }

    public A withControlPlaneSubnets(String ... controlPlaneSubnets) {
        if (this.controlPlaneSubnets != null) {
            this.controlPlaneSubnets.clear();
            this._visitables.remove("controlPlaneSubnets");
        }
        if (controlPlaneSubnets != null) {
            for (String item : controlPlaneSubnets) {
                this.addToControlPlaneSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasControlPlaneSubnets() {
        return this.controlPlaneSubnets != null && !this.controlPlaneSubnets.isEmpty();
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName = networkResourceGroupName;
        return (A)this;
    }

    public boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    public boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    public A withVpcName(String vpcName) {
        this.vpcName = vpcName;
        return (A)this;
    }

    public boolean hasVpcName() {
        return this.vpcName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.computeSubnets, that.computeSubnets)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneSubnets, that.controlPlaneSubnets)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.networkResourceGroupName, that.networkResourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupName, that.resourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.vpcName, that.vpcName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeSubnets, this.controlPlaneSubnets, this.defaultMachinePlatform, this.networkResourceGroupName, this.region, this.resourceGroupName, this.vpcName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeSubnets != null && !this.computeSubnets.isEmpty()) {
            sb.append("computeSubnets:");
            sb.append(this.computeSubnets + ",");
        }
        if (this.controlPlaneSubnets != null && !this.controlPlaneSubnets.isEmpty()) {
            sb.append("controlPlaneSubnets:");
            sb.append(this.controlPlaneSubnets + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.networkResourceGroupName != null) {
            sb.append("networkResourceGroupName:");
            sb.append(this.networkResourceGroupName + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName + ",");
        }
        if (this.vpcName != null) {
            sb.append("vpcName:");
            sb.append(this.vpcName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

