/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.BMC;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.BMCBuilder;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.BMCFluent;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.Host;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.RootDeviceHints;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.RootDeviceHintsBuilder;
import io.fabric8.openshift.api.model.v6_9.installer.baremetal.v1.RootDeviceHintsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HostFluent<A extends HostFluent<A>>
extends BaseFluent<A> {
    private BMCBuilder bmc;
    private String bootMACAddress;
    private String bootMode;
    private String hardwareProfile;
    private String name;
    private JsonNode networkConfig;
    private String role;
    private RootDeviceHintsBuilder rootDeviceHints;
    private Map<String, Object> additionalProperties;

    public HostFluent() {
    }

    public HostFluent(Host instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Host instance) {
        Host host = instance = instance != null ? instance : new Host();
        if (instance != null) {
            this.withBmc(instance.getBmc());
            this.withBootMACAddress(instance.getBootMACAddress());
            this.withBootMode(instance.getBootMode());
            this.withHardwareProfile(instance.getHardwareProfile());
            this.withName(instance.getName());
            this.withNetworkConfig(instance.getNetworkConfig());
            this.withRole(instance.getRole());
            this.withRootDeviceHints(instance.getRootDeviceHints());
            this.withBmc(instance.getBmc());
            this.withBootMACAddress(instance.getBootMACAddress());
            this.withBootMode(instance.getBootMode());
            this.withHardwareProfile(instance.getHardwareProfile());
            this.withName(instance.getName());
            this.withNetworkConfig(instance.getNetworkConfig());
            this.withRole(instance.getRole());
            this.withRootDeviceHints(instance.getRootDeviceHints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BMC buildBmc() {
        return this.bmc != null ? this.bmc.build() : null;
    }

    public A withBmc(BMC bmc) {
        this._visitables.remove(this.bmc);
        if (bmc != null) {
            this.bmc = new BMCBuilder(bmc);
            this._visitables.get("bmc").add(this.bmc);
        } else {
            this.bmc = null;
            this._visitables.get("bmc").remove(this.bmc);
        }
        return (A)this;
    }

    public boolean hasBmc() {
        return this.bmc != null;
    }

    public A withNewBmc(String address, Boolean disableCertificateVerification, String password, String username) {
        return this.withBmc(new BMC(address, disableCertificateVerification, password, username));
    }

    public BmcNested<A> withNewBmc() {
        return new BmcNested(null);
    }

    public BmcNested<A> withNewBmcLike(BMC item) {
        return new BmcNested(item);
    }

    public BmcNested<A> editBmc() {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(null));
    }

    public BmcNested<A> editOrNewBmc() {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(new BMCBuilder().build()));
    }

    public BmcNested<A> editOrNewBmcLike(BMC item) {
        return this.withNewBmcLike(Optional.ofNullable(this.buildBmc()).orElse(item));
    }

    public String getBootMACAddress() {
        return this.bootMACAddress;
    }

    public A withBootMACAddress(String bootMACAddress) {
        this.bootMACAddress = bootMACAddress;
        return (A)this;
    }

    public boolean hasBootMACAddress() {
        return this.bootMACAddress != null;
    }

    public String getBootMode() {
        return this.bootMode;
    }

    public A withBootMode(String bootMode) {
        this.bootMode = bootMode;
        return (A)this;
    }

    public boolean hasBootMode() {
        return this.bootMode != null;
    }

    public String getHardwareProfile() {
        return this.hardwareProfile;
    }

    public A withHardwareProfile(String hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return (A)this;
    }

    public boolean hasHardwareProfile() {
        return this.hardwareProfile != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public JsonNode getNetworkConfig() {
        return this.networkConfig;
    }

    public A withNetworkConfig(JsonNode networkConfig) {
        this.networkConfig = networkConfig;
        return (A)this;
    }

    public boolean hasNetworkConfig() {
        return this.networkConfig != null;
    }

    public String getRole() {
        return this.role;
    }

    public A withRole(String role) {
        this.role = role;
        return (A)this;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public RootDeviceHints buildRootDeviceHints() {
        return this.rootDeviceHints != null ? this.rootDeviceHints.build() : null;
    }

    public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
        this._visitables.remove(this.rootDeviceHints);
        if (rootDeviceHints != null) {
            this.rootDeviceHints = new RootDeviceHintsBuilder(rootDeviceHints);
            this._visitables.get("rootDeviceHints").add(this.rootDeviceHints);
        } else {
            this.rootDeviceHints = null;
            this._visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
        }
        return (A)this;
    }

    public boolean hasRootDeviceHints() {
        return this.rootDeviceHints != null;
    }

    public RootDeviceHintsNested<A> withNewRootDeviceHints() {
        return new RootDeviceHintsNested(null);
    }

    public RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
        return new RootDeviceHintsNested(item);
    }

    public RootDeviceHintsNested<A> editRootDeviceHints() {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(null));
    }

    public RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(new RootDeviceHintsBuilder().build()));
    }

    public RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
        return this.withNewRootDeviceHintsLike(Optional.ofNullable(this.buildRootDeviceHints()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostFluent that = (HostFluent)o;
        if (!Objects.equals(this.bmc, that.bmc)) {
            return false;
        }
        if (!Objects.equals(this.bootMACAddress, that.bootMACAddress)) {
            return false;
        }
        if (!Objects.equals(this.bootMode, that.bootMode)) {
            return false;
        }
        if (!Objects.equals(this.hardwareProfile, that.hardwareProfile)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.networkConfig, that.networkConfig)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        if (!Objects.equals(this.rootDeviceHints, that.rootDeviceHints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bmc, this.bootMACAddress, this.bootMode, this.hardwareProfile, this.name, this.networkConfig, this.role, this.rootDeviceHints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bmc != null) {
            sb.append("bmc:");
            sb.append(this.bmc + ",");
        }
        if (this.bootMACAddress != null) {
            sb.append("bootMACAddress:");
            sb.append(this.bootMACAddress + ",");
        }
        if (this.bootMode != null) {
            sb.append("bootMode:");
            sb.append(this.bootMode + ",");
        }
        if (this.hardwareProfile != null) {
            sb.append("hardwareProfile:");
            sb.append(this.hardwareProfile + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.networkConfig != null) {
            sb.append("networkConfig:");
            sb.append(this.networkConfig + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.rootDeviceHints != null) {
            sb.append("rootDeviceHints:");
            sb.append(this.rootDeviceHints + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RootDeviceHintsNested<N>
    extends RootDeviceHintsFluent<RootDeviceHintsNested<N>>
    implements Nested<N> {
        RootDeviceHintsBuilder builder;

        RootDeviceHintsNested(RootDeviceHints item) {
            this.builder = new RootDeviceHintsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HostFluent.this.withRootDeviceHints(this.builder.build());
        }

        public N endRootDeviceHints() {
            return this.and();
        }
    }

    public class BmcNested<N>
    extends BMCFluent<BmcNested<N>>
    implements Nested<N> {
        BMCBuilder builder;

        BmcNested(BMC item) {
            this.builder = new BMCBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HostFluent.this.withBmc(this.builder.build());
        }

        public N endBmc() {
            return this.and();
        }
    }
}

