/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterIngress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterIngressFluent<A extends ClusterIngressFluent<A>>
extends BaseFluent<A> {
    private String domain;
    private ConfigMapNameReference httpErrorCodePages;
    private String name;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder routeSelector;
    private String servingCertificate;
    private Map<String, Object> additionalProperties;

    public ClusterIngressFluent() {
    }

    public ClusterIngressFluent(ClusterIngress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterIngress instance) {
        ClusterIngress clusterIngress = instance = instance != null ? instance : new ClusterIngress();
        if (instance != null) {
            this.withDomain(instance.getDomain());
            this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
            this.withName(instance.getName());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withRouteSelector(instance.getRouteSelector());
            this.withServingCertificate(instance.getServingCertificate());
            this.withDomain(instance.getDomain());
            this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
            this.withName(instance.getName());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withRouteSelector(instance.getRouteSelector());
            this.withServingCertificate(instance.getServingCertificate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public ConfigMapNameReference getHttpErrorCodePages() {
        return this.httpErrorCodePages;
    }

    public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
        this.httpErrorCodePages = httpErrorCodePages;
        return (A)this;
    }

    public boolean hasHttpErrorCodePages() {
        return this.httpErrorCodePages != null;
    }

    public A withNewHttpErrorCodePages(String name) {
        return this.withHttpErrorCodePages(new ConfigMapNameReference(name));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildRouteSelector() {
        return this.routeSelector != null ? this.routeSelector.build() : null;
    }

    public A withRouteSelector(LabelSelector routeSelector) {
        this._visitables.remove(this.routeSelector);
        if (routeSelector != null) {
            this.routeSelector = new LabelSelectorBuilder(routeSelector);
            this._visitables.get("routeSelector").add(this.routeSelector);
        } else {
            this.routeSelector = null;
            this._visitables.get("routeSelector").remove(this.routeSelector);
        }
        return (A)this;
    }

    public boolean hasRouteSelector() {
        return this.routeSelector != null;
    }

    public RouteSelectorNested<A> withNewRouteSelector() {
        return new RouteSelectorNested(null);
    }

    public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
        return new RouteSelectorNested(item);
    }

    public RouteSelectorNested<A> editRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(null));
    }

    public RouteSelectorNested<A> editOrNewRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(item));
    }

    public String getServingCertificate() {
        return this.servingCertificate;
    }

    public A withServingCertificate(String servingCertificate) {
        this.servingCertificate = servingCertificate;
        return (A)this;
    }

    public boolean hasServingCertificate() {
        return this.servingCertificate != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterIngressFluent that = (ClusterIngressFluent)o;
        if (!Objects.equals(this.domain, that.domain)) {
            return false;
        }
        if (!Objects.equals(this.httpErrorCodePages, that.httpErrorCodePages)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.routeSelector, that.routeSelector)) {
            return false;
        }
        if (!Objects.equals(this.servingCertificate, that.servingCertificate)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.domain, this.httpErrorCodePages, this.name, this.namespaceSelector, this.routeSelector, this.servingCertificate, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domain != null) {
            sb.append("domain:");
            sb.append(this.domain + ",");
        }
        if (this.httpErrorCodePages != null) {
            sb.append("httpErrorCodePages:");
            sb.append(this.httpErrorCodePages + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.routeSelector != null) {
            sb.append("routeSelector:");
            sb.append(this.routeSelector + ",");
        }
        if (this.servingCertificate != null) {
            sb.append("servingCertificate:");
            sb.append(this.servingCertificate + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RouteSelectorNested<N>
    extends LabelSelectorFluent<RouteSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        RouteSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterIngressFluent.this.withRouteSelector(this.builder.build());
        }

        public N endRouteSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterIngressFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }
}

