/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.config.v1.ComponentRouteSpec;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ComponentRouteSpecFluent<A extends ComponentRouteSpecFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private String name;
    private String namespace;
    private SecretNameReferenceBuilder servingCertKeyPairSecret;
    private Map<String, Object> additionalProperties;

    public ComponentRouteSpecFluent() {
    }

    public ComponentRouteSpecFluent(ComponentRouteSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ComponentRouteSpec instance) {
        ComponentRouteSpec componentRouteSpec = instance = instance != null ? instance : new ComponentRouteSpec();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
            this.withHostname(instance.getHostname());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public SecretNameReference buildServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null ? this.servingCertKeyPairSecret.build() : null;
    }

    public A withServingCertKeyPairSecret(SecretNameReference servingCertKeyPairSecret) {
        this._visitables.remove(this.servingCertKeyPairSecret);
        if (servingCertKeyPairSecret != null) {
            this.servingCertKeyPairSecret = new SecretNameReferenceBuilder(servingCertKeyPairSecret);
            this._visitables.get("servingCertKeyPairSecret").add(this.servingCertKeyPairSecret);
        } else {
            this.servingCertKeyPairSecret = null;
            this._visitables.get("servingCertKeyPairSecret").remove(this.servingCertKeyPairSecret);
        }
        return (A)this;
    }

    public boolean hasServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null;
    }

    public A withNewServingCertKeyPairSecret(String name) {
        return this.withServingCertKeyPairSecret(new SecretNameReference(name));
    }

    public ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecret() {
        return new ServingCertKeyPairSecretNested(null);
    }

    public ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return new ServingCertKeyPairSecretNested(item);
    }

    public ServingCertKeyPairSecretNested<A> editServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(Optional.ofNullable(this.buildServingCertKeyPairSecret()).orElse(null));
    }

    public ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(Optional.ofNullable(this.buildServingCertKeyPairSecret()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return this.withNewServingCertKeyPairSecretLike(Optional.ofNullable(this.buildServingCertKeyPairSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentRouteSpecFluent that = (ComponentRouteSpecFluent)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.servingCertKeyPairSecret, that.servingCertKeyPairSecret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.name, this.namespace, this.servingCertKeyPairSecret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.servingCertKeyPairSecret != null) {
            sb.append("servingCertKeyPairSecret:");
            sb.append(this.servingCertKeyPairSecret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServingCertKeyPairSecretNested<N>
    extends SecretNameReferenceFluent<ServingCertKeyPairSecretNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ServingCertKeyPairSecretNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ComponentRouteSpecFluent.this.withServingCertKeyPairSecret(this.builder.build());
        }

        public N endServingCertKeyPairSecret() {
            return this.and();
        }
    }
}

