/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.config.v1.APIServerNamedServingCert;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.SecretNameReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class APIServerNamedServingCertFluent<A extends APIServerNamedServingCertFluent<A>>
extends BaseFluent<A> {
    private List<String> names = new ArrayList<String>();
    private SecretNameReferenceBuilder servingCertificate;
    private Map<String, Object> additionalProperties;

    public APIServerNamedServingCertFluent() {
    }

    public APIServerNamedServingCertFluent(APIServerNamedServingCert instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIServerNamedServingCert instance) {
        APIServerNamedServingCert aPIServerNamedServingCert = instance = instance != null ? instance : new APIServerNamedServingCert();
        if (instance != null) {
            this.withNames(instance.getNames());
            this.withServingCertificate(instance.getServingCertificate());
            this.withNames(instance.getNames());
            this.withServingCertificate(instance.getServingCertificate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(index, item);
        return (A)this;
    }

    public A setToNames(int index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.set(index, item);
        return (A)this;
    }

    public A addToNames(String ... items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    public A removeFromNames(String ... items) {
        if (this.names == null) {
            return (A)this;
        }
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNames(Collection<String> items) {
        if (this.names == null) {
            return (A)this;
        }
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public String getFirstName() {
        return this.names.get(0);
    }

    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNames(List<String> names) {
        if (names != null) {
            this.names = new ArrayList<String>();
            for (String item : names) {
                this.addToNames(item);
            }
        } else {
            this.names = null;
        }
        return (A)this;
    }

    public A withNames(String ... names) {
        if (this.names != null) {
            this.names.clear();
            this._visitables.remove("names");
        }
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    public SecretNameReference buildServingCertificate() {
        return this.servingCertificate != null ? this.servingCertificate.build() : null;
    }

    public A withServingCertificate(SecretNameReference servingCertificate) {
        this._visitables.remove(this.servingCertificate);
        if (servingCertificate != null) {
            this.servingCertificate = new SecretNameReferenceBuilder(servingCertificate);
            this._visitables.get("servingCertificate").add(this.servingCertificate);
        } else {
            this.servingCertificate = null;
            this._visitables.get("servingCertificate").remove(this.servingCertificate);
        }
        return (A)this;
    }

    public boolean hasServingCertificate() {
        return this.servingCertificate != null;
    }

    public A withNewServingCertificate(String name) {
        return this.withServingCertificate(new SecretNameReference(name));
    }

    public ServingCertificateNested<A> withNewServingCertificate() {
        return new ServingCertificateNested(null);
    }

    public ServingCertificateNested<A> withNewServingCertificateLike(SecretNameReference item) {
        return new ServingCertificateNested(item);
    }

    public ServingCertificateNested<A> editServingCertificate() {
        return this.withNewServingCertificateLike(Optional.ofNullable(this.buildServingCertificate()).orElse(null));
    }

    public ServingCertificateNested<A> editOrNewServingCertificate() {
        return this.withNewServingCertificateLike(Optional.ofNullable(this.buildServingCertificate()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ServingCertificateNested<A> editOrNewServingCertificateLike(SecretNameReference item) {
        return this.withNewServingCertificateLike(Optional.ofNullable(this.buildServingCertificate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerNamedServingCertFluent that = (APIServerNamedServingCertFluent)o;
        if (!Objects.equals(this.names, that.names)) {
            return false;
        }
        if (!Objects.equals(this.servingCertificate, that.servingCertificate)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.names, this.servingCertificate, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.names != null && !this.names.isEmpty()) {
            sb.append("names:");
            sb.append(this.names + ",");
        }
        if (this.servingCertificate != null) {
            sb.append("servingCertificate:");
            sb.append(this.servingCertificate + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServingCertificateNested<N>
    extends SecretNameReferenceFluent<ServingCertificateNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ServingCertificateNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServerNamedServingCertFluent.this.withServingCertificate(this.builder.build());
        }

        public N endServingCertificate() {
            return this.and();
        }
    }
}

