/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.clusterautoscaling.v1beta1.CrossVersionObjectReference;
import io.fabric8.openshift.api.model.v6_9.clusterautoscaling.v1beta1.CrossVersionObjectReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.clusterautoscaling.v1beta1.CrossVersionObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_9.clusterautoscaling.v1beta1.MachineAutoscalerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineAutoscalerSpecFluent<A extends MachineAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Map<String, Object> additionalProperties;

    public MachineAutoscalerSpecFluent() {
    }

    public MachineAutoscalerSpecFluent(MachineAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineAutoscalerSpec instance) {
        MachineAutoscalerSpec machineAutoscalerSpec = instance = instance != null ? instance : new MachineAutoscalerSpec();
        if (instance != null) {
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineAutoscalerSpecFluent that = (MachineAutoscalerSpecFluent)o;
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals(this.scaleTargetRef, that.scaleTargetRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

