/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.storage;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_9.TopologySelectorTerm;
import io.fabric8.kubernetes.api.model.v6_9.storage.StorageClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StorageClassFluent<A extends StorageClassFluent<A>>
extends BaseFluent<A> {
    private Boolean allowVolumeExpansion;
    private List<TopologySelectorTerm> allowedTopologies = new ArrayList<TopologySelectorTerm>();
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> mountOptions = new ArrayList<String>();
    private Map<String, String> parameters;
    private String provisioner;
    private String reclaimPolicy;
    private String volumeBindingMode;
    private Map<String, Object> additionalProperties;

    public StorageClassFluent() {
    }

    public StorageClassFluent(StorageClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StorageClass instance) {
        StorageClass storageClass = instance = instance != null ? instance : new StorageClass();
        if (instance != null) {
            this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
            this.withAllowedTopologies(instance.getAllowedTopologies());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMountOptions(instance.getMountOptions());
            this.withParameters(instance.getParameters());
            this.withProvisioner(instance.getProvisioner());
            this.withReclaimPolicy(instance.getReclaimPolicy());
            this.withVolumeBindingMode(instance.getVolumeBindingMode());
            this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
            this.withAllowedTopologies(instance.getAllowedTopologies());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withMountOptions(instance.getMountOptions());
            this.withParameters(instance.getParameters());
            this.withProvisioner(instance.getProvisioner());
            this.withReclaimPolicy(instance.getReclaimPolicy());
            this.withVolumeBindingMode(instance.getVolumeBindingMode());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return (A)this;
    }

    public boolean hasAllowVolumeExpansion() {
        return this.allowVolumeExpansion != null;
    }

    public A addToAllowedTopologies(int index, TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        this.allowedTopologies.add(index, item);
        return (A)this;
    }

    public A setToAllowedTopologies(int index, TopologySelectorTerm item) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        this.allowedTopologies.set(index, item);
        return (A)this;
    }

    public A addToAllowedTopologies(TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedTopologies(Collection<TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedTopologies(TopologySelectorTerm ... items) {
        if (this.allowedTopologies == null) {
            return (A)this;
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedTopologies(Collection<TopologySelectorTerm> items) {
        if (this.allowedTopologies == null) {
            return (A)this;
        }
        for (TopologySelectorTerm item : items) {
            this.allowedTopologies.remove(item);
        }
        return (A)this;
    }

    public List<TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    public TopologySelectorTerm getAllowedTopology(int index) {
        return this.allowedTopologies.get(index);
    }

    public TopologySelectorTerm getFirstAllowedTopology() {
        return this.allowedTopologies.get(0);
    }

    public TopologySelectorTerm getLastAllowedTopology() {
        return this.allowedTopologies.get(this.allowedTopologies.size() - 1);
    }

    public TopologySelectorTerm getMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate) {
        for (TopologySelectorTerm item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate) {
        for (TopologySelectorTerm item : this.allowedTopologies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedTopologies(List<TopologySelectorTerm> allowedTopologies) {
        if (allowedTopologies != null) {
            this.allowedTopologies = new ArrayList<TopologySelectorTerm>();
            for (TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        } else {
            this.allowedTopologies = null;
        }
        return (A)this;
    }

    public A withAllowedTopologies(TopologySelectorTerm ... allowedTopologies) {
        if (this.allowedTopologies != null) {
            this.allowedTopologies.clear();
            this._visitables.remove("allowedTopologies");
        }
        if (allowedTopologies != null) {
            for (TopologySelectorTerm item : allowedTopologies) {
                this.addToAllowedTopologies(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedTopologies() {
        return this.allowedTopologies != null && !this.allowedTopologies.isEmpty();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(index, item);
        return (A)this;
    }

    public A setToMountOptions(int index, String item) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.set(index, item);
        return (A)this;
    }

    public A addToMountOptions(String ... items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    public A addAllToMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.mountOptions.add(item);
        }
        return (A)this;
    }

    public A removeFromMountOptions(String ... items) {
        if (this.mountOptions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMountOptions(Collection<String> items) {
        if (this.mountOptions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.mountOptions.remove(item);
        }
        return (A)this;
    }

    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public String getMountOption(int index) {
        return this.mountOptions.get(index);
    }

    public String getFirstMountOption() {
        return this.mountOptions.get(0);
    }

    public String getLastMountOption() {
        return this.mountOptions.get(this.mountOptions.size() - 1);
    }

    public String getMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMountOption(Predicate<String> predicate) {
        for (String item : this.mountOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMountOptions(List<String> mountOptions) {
        if (mountOptions != null) {
            this.mountOptions = new ArrayList<String>();
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        } else {
            this.mountOptions = null;
        }
        return (A)this;
    }

    public A withMountOptions(String ... mountOptions) {
        if (this.mountOptions != null) {
            this.mountOptions.clear();
            this._visitables.remove("mountOptions");
        }
        if (mountOptions != null) {
            for (String item : mountOptions) {
                this.addToMountOptions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMountOptions() {
        return this.mountOptions != null && !this.mountOptions.isEmpty();
    }

    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public <K, V> A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public String getProvisioner() {
        return this.provisioner;
    }

    public A withProvisioner(String provisioner) {
        this.provisioner = provisioner;
        return (A)this;
    }

    public boolean hasProvisioner() {
        return this.provisioner != null;
    }

    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public A withReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return (A)this;
    }

    public boolean hasReclaimPolicy() {
        return this.reclaimPolicy != null;
    }

    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public A withVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return (A)this;
    }

    public boolean hasVolumeBindingMode() {
        return this.volumeBindingMode != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageClassFluent that = (StorageClassFluent)o;
        if (!Objects.equals(this.allowVolumeExpansion, that.allowVolumeExpansion)) {
            return false;
        }
        if (!Objects.equals(this.allowedTopologies, that.allowedTopologies)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.mountOptions, that.mountOptions)) {
            return false;
        }
        if (!Objects.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.provisioner, that.provisioner)) {
            return false;
        }
        if (!Objects.equals(this.reclaimPolicy, that.reclaimPolicy)) {
            return false;
        }
        if (!Objects.equals(this.volumeBindingMode, that.volumeBindingMode)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowVolumeExpansion != null) {
            sb.append("allowVolumeExpansion:");
            sb.append(this.allowVolumeExpansion + ",");
        }
        if (this.allowedTopologies != null && !this.allowedTopologies.isEmpty()) {
            sb.append("allowedTopologies:");
            sb.append(this.allowedTopologies + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.mountOptions != null && !this.mountOptions.isEmpty()) {
            sb.append("mountOptions:");
            sb.append(this.mountOptions + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters + ",");
        }
        if (this.provisioner != null) {
            sb.append("provisioner:");
            sb.append(this.provisioner + ",");
        }
        if (this.reclaimPolicy != null) {
            sb.append("reclaimPolicy:");
            sb.append(this.reclaimPolicy + ",");
        }
        if (this.volumeBindingMode != null) {
            sb.append("volumeBindingMode:");
            sb.append(this.volumeBindingMode + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowVolumeExpansion() {
        return this.withAllowVolumeExpansion(true);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StorageClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

