/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IPBlock;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IPBlockBuilder;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IPBlockFluent;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.NetworkPolicyPeer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkPolicyPeerFluent<A extends NetworkPolicyPeerFluent<A>>
extends BaseFluent<A> {
    private IPBlockBuilder ipBlock;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder podSelector;
    private Map<String, Object> additionalProperties;

    public NetworkPolicyPeerFluent() {
    }

    public NetworkPolicyPeerFluent(NetworkPolicyPeer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkPolicyPeer instance) {
        NetworkPolicyPeer networkPolicyPeer = instance = instance != null ? instance : new NetworkPolicyPeer();
        if (instance != null) {
            this.withIpBlock(instance.getIpBlock());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPodSelector(instance.getPodSelector());
            this.withIpBlock(instance.getIpBlock());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPodSelector(instance.getPodSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IPBlock buildIpBlock() {
        return this.ipBlock != null ? this.ipBlock.build() : null;
    }

    public A withIpBlock(IPBlock ipBlock) {
        this._visitables.remove(this.ipBlock);
        if (ipBlock != null) {
            this.ipBlock = new IPBlockBuilder(ipBlock);
            this._visitables.get("ipBlock").add(this.ipBlock);
        } else {
            this.ipBlock = null;
            this._visitables.get("ipBlock").remove(this.ipBlock);
        }
        return (A)this;
    }

    public boolean hasIpBlock() {
        return this.ipBlock != null;
    }

    public IpBlockNested<A> withNewIpBlock() {
        return new IpBlockNested(null);
    }

    public IpBlockNested<A> withNewIpBlockLike(IPBlock item) {
        return new IpBlockNested(item);
    }

    public IpBlockNested<A> editIpBlock() {
        return this.withNewIpBlockLike(Optional.ofNullable(this.buildIpBlock()).orElse(null));
    }

    public IpBlockNested<A> editOrNewIpBlock() {
        return this.withNewIpBlockLike(Optional.ofNullable(this.buildIpBlock()).orElse(new IPBlockBuilder().build()));
    }

    public IpBlockNested<A> editOrNewIpBlockLike(IPBlock item) {
        return this.withNewIpBlockLike(Optional.ofNullable(this.buildIpBlock()).orElse(item));
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get("podSelector").remove(this.podSelector);
        }
        return (A)this;
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPeerFluent that = (NetworkPolicyPeerFluent)o;
        if (!Objects.equals(this.ipBlock, that.ipBlock)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ipBlock, this.namespaceSelector, this.podSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipBlock != null) {
            sb.append("ipBlock:");
            sb.append(this.ipBlock + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodSelectorNested<N>
    extends LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class IpBlockNested<N>
    extends IPBlockFluent<IpBlockNested<N>>
    implements Nested<N> {
        IPBlockBuilder builder;

        IpBlockNested(IPBlock item) {
            this.builder = new IPBlockBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluent.this.withIpBlock(this.builder.build());
        }

        public N endIpBlock() {
            return this.and();
        }
    }
}

