/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.GroupSubject;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.GroupSubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.GroupSubjectFluent;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.ServiceAccountSubject;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.ServiceAccountSubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.ServiceAccountSubjectFluent;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.Subject;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.UserSubject;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.UserSubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_9.flowcontrol.v1alpha1.UserSubjectFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SubjectFluent<A extends SubjectFluent<A>>
extends BaseFluent<A> {
    private GroupSubjectBuilder group;
    private String kind;
    private ServiceAccountSubjectBuilder serviceAccount;
    private UserSubjectBuilder user;
    private Map<String, Object> additionalProperties;

    public SubjectFluent() {
    }

    public SubjectFluent(Subject instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Subject instance) {
        Subject subject = instance = instance != null ? instance : new Subject();
        if (instance != null) {
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withServiceAccount(instance.getServiceAccount());
            this.withUser(instance.getUser());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withServiceAccount(instance.getServiceAccount());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public GroupSubject buildGroup() {
        return this.group != null ? this.group.build() : null;
    }

    public A withGroup(GroupSubject group) {
        this._visitables.remove(this.group);
        if (group != null) {
            this.group = new GroupSubjectBuilder(group);
            this._visitables.get("group").add(this.group);
        } else {
            this.group = null;
            this._visitables.get("group").remove(this.group);
        }
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String name) {
        return this.withGroup(new GroupSubject(name));
    }

    public GroupNested<A> withNewGroup() {
        return new GroupNested(null);
    }

    public GroupNested<A> withNewGroupLike(GroupSubject item) {
        return new GroupNested(item);
    }

    public GroupNested<A> editGroup() {
        return this.withNewGroupLike(Optional.ofNullable(this.buildGroup()).orElse(null));
    }

    public GroupNested<A> editOrNewGroup() {
        return this.withNewGroupLike(Optional.ofNullable(this.buildGroup()).orElse(new GroupSubjectBuilder().build()));
    }

    public GroupNested<A> editOrNewGroupLike(GroupSubject item) {
        return this.withNewGroupLike(Optional.ofNullable(this.buildGroup()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ServiceAccountSubject buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ServiceAccountSubject serviceAccount) {
        this._visitables.remove(this.serviceAccount);
        if (serviceAccount != null) {
            this.serviceAccount = new ServiceAccountSubjectBuilder(serviceAccount);
            this._visitables.get("serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get("serviceAccount").remove(this.serviceAccount);
        }
        return (A)this;
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String name, String namespace) {
        return this.withServiceAccount(new ServiceAccountSubject(name, namespace));
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccountSubject item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ServiceAccountSubjectBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccountSubject item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public UserSubject buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(UserSubject user) {
        this._visitables.remove(this.user);
        if (user != null) {
            this.user = new UserSubjectBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(String name) {
        return this.withUser(new UserSubject(name));
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(UserSubject item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new UserSubjectBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(UserSubject item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectFluent that = (SubjectFluent)o;
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.kind, this.serviceAccount, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserNested<N>
    extends UserSubjectFluent<UserNested<N>>
    implements Nested<N> {
        UserSubjectBuilder builder;

        UserNested(UserSubject item) {
            this.builder = new UserSubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ServiceAccountSubjectFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ServiceAccountSubjectBuilder builder;

        ServiceAccountNested(ServiceAccountSubject item) {
            this.builder = new ServiceAccountSubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }

    public class GroupNested<N>
    extends GroupSubjectFluent<GroupNested<N>>
    implements Nested<N> {
        GroupSubjectBuilder builder;

        GroupNested(GroupSubject item) {
            this.builder = new GroupSubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectFluent.this.withGroup(this.builder.build());
        }

        public N endGroup() {
            return this.and();
        }
    }
}

