/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2.MetricTarget;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2.MetricTargetBuilder;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2.MetricTargetFluent;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2.ResourceMetricSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceMetricSourceFluent<A extends ResourceMetricSourceFluent<A>>
extends BaseFluent<A> {
    private String name;
    private MetricTargetBuilder target;
    private Map<String, Object> additionalProperties;

    public ResourceMetricSourceFluent() {
    }

    public ResourceMetricSourceFluent(ResourceMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceMetricSource instance) {
        ResourceMetricSource resourceMetricSource = instance = instance != null ? instance : new ResourceMetricSource();
        if (instance != null) {
            this.withName(instance.getName());
            this.withTarget(instance.getTarget());
            this.withName(instance.getName());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(MetricTarget target) {
        this._visitables.remove(this.target);
        if (target != null) {
            this.target = new MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(MetricTarget item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new MetricTargetBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(MetricTarget item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceFluent that = (ResourceMetricSourceFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends MetricTargetFluent<TargetNested<N>>
    implements Nested<N> {
        MetricTargetBuilder builder;

        TargetNested(MetricTarget item) {
            this.builder = new MetricTargetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceMetricSourceFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }
}

