/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_9.PodExecOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodExecOptionsFluent<A extends PodExecOptionsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> command = new ArrayList<String>();
    private String container;
    private String kind;
    private Boolean stderr;
    private Boolean stdin;
    private Boolean stdout;
    private Boolean tty;
    private Map<String, Object> additionalProperties;

    public PodExecOptionsFluent() {
    }

    public PodExecOptionsFluent(PodExecOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodExecOptions instance) {
        PodExecOptions podExecOptions = instance = instance != null ? instance : new PodExecOptions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCommand(instance.getCommand());
            this.withContainer(instance.getContainer());
            this.withKind(instance.getKind());
            this.withStderr(instance.getStderr());
            this.withStdin(instance.getStdin());
            this.withStdout(instance.getStdout());
            this.withTty(instance.getTty());
            this.withApiVersion(instance.getApiVersion());
            this.withCommand(instance.getCommand());
            this.withContainer(instance.getContainer());
            this.withKind(instance.getKind());
            this.withStderr(instance.getStderr());
            this.withStdin(instance.getStdin());
            this.withStdout(instance.getStdout());
            this.withTty(instance.getTty());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove("command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Boolean getStderr() {
        return this.stderr;
    }

    public A withStderr(Boolean stderr) {
        this.stderr = stderr;
        return (A)this;
    }

    public boolean hasStderr() {
        return this.stderr != null;
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    public boolean hasStdin() {
        return this.stdin != null;
    }

    public Boolean getStdout() {
        return this.stdout;
    }

    public A withStdout(Boolean stdout) {
        this.stdout = stdout;
        return (A)this;
    }

    public boolean hasStdout() {
        return this.stdout != null;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    public boolean hasTty() {
        return this.tty != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodExecOptionsFluent that = (PodExecOptionsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.stderr, that.stderr)) {
            return false;
        }
        if (!Objects.equals(this.stdin, that.stdin)) {
            return false;
        }
        if (!Objects.equals(this.stdout, that.stdout)) {
            return false;
        }
        if (!Objects.equals(this.tty, that.tty)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.command, this.container, this.kind, this.stderr, this.stdin, this.stdout, this.tty, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.stderr != null) {
            sb.append("stderr:");
            sb.append(this.stderr + ",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin + ",");
        }
        if (this.stdout != null) {
            sb.append("stdout:");
            sb.append(this.stdout + ",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withStderr() {
        return this.withStderr(true);
    }

    public A withStdin() {
        return this.withStdin(true);
    }

    public A withStdout() {
        return this.withStdout(true);
    }

    public A withTty() {
        return this.withTty(true);
    }
}

