/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v6_9.PodAffinityTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodAffinityTermFluent<A extends PodAffinityTermFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private LabelSelectorBuilder namespaceSelector;
    private List<String> namespaces = new ArrayList<String>();
    private String topologyKey;
    private Map<String, Object> additionalProperties;

    public PodAffinityTermFluent() {
    }

    public PodAffinityTermFluent(PodAffinityTerm instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodAffinityTerm instance) {
        PodAffinityTerm podAffinityTerm = instance = instance != null ? instance : new PodAffinityTerm();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withNamespaces(instance.getNamespaces());
            this.withTopologyKey(instance.getTopologyKey());
            this.withLabelSelector(instance.getLabelSelector());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withNamespaces(instance.getNamespaces());
            this.withTopologyKey(instance.getTopologyKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A removeFromNamespaces(String ... items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    public boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodAffinityTermFluent that = (PodAffinityTermFluent)o;
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.topologyKey, that.topologyKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.namespaceSelector, this.namespaces, this.topologyKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodAffinityTermFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodAffinityTermFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

