/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSource;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSourceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSourceFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeSpec;
import io.fabric8.kubernetes.api.model.v6_9.Taint;
import io.fabric8.kubernetes.api.model.v6_9.TaintBuilder;
import io.fabric8.kubernetes.api.model.v6_9.TaintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NodeSpecFluent<A extends NodeSpecFluent<A>>
extends BaseFluent<A> {
    private NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private List<String> podCIDRs = new ArrayList<String>();
    private String providerID;
    private ArrayList<TaintBuilder> taints = new ArrayList();
    private Boolean unschedulable;
    private Map<String, Object> additionalProperties;

    public NodeSpecFluent() {
    }

    public NodeSpecFluent(NodeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeSpec instance) {
        NodeSpec nodeSpec = instance = instance != null ? instance : new NodeSpec();
        if (instance != null) {
            this.withConfigSource(instance.getConfigSource());
            this.withExternalID(instance.getExternalID());
            this.withPodCIDR(instance.getPodCIDR());
            this.withPodCIDRs(instance.getPodCIDRs());
            this.withProviderID(instance.getProviderID());
            this.withTaints(instance.getTaints());
            this.withUnschedulable(instance.getUnschedulable());
            this.withConfigSource(instance.getConfigSource());
            this.withExternalID(instance.getExternalID());
            this.withPodCIDR(instance.getPodCIDR());
            this.withPodCIDRs(instance.getPodCIDRs());
            this.withProviderID(instance.getProviderID());
            this.withTaints(instance.getTaints());
            this.withUnschedulable(instance.getUnschedulable());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NodeConfigSource buildConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    public A withConfigSource(NodeConfigSource configSource) {
        this._visitables.remove(this.configSource);
        if (configSource != null) {
            this.configSource = new NodeConfigSourceBuilder(configSource);
            this._visitables.get("configSource").add(this.configSource);
        } else {
            this.configSource = null;
            this._visitables.get("configSource").remove(this.configSource);
        }
        return (A)this;
    }

    public boolean hasConfigSource() {
        return this.configSource != null;
    }

    public ConfigSourceNested<A> withNewConfigSource() {
        return new ConfigSourceNested(null);
    }

    public ConfigSourceNested<A> withNewConfigSourceLike(NodeConfigSource item) {
        return new ConfigSourceNested(item);
    }

    public ConfigSourceNested<A> editConfigSource() {
        return this.withNewConfigSourceLike(Optional.ofNullable(this.buildConfigSource()).orElse(null));
    }

    public ConfigSourceNested<A> editOrNewConfigSource() {
        return this.withNewConfigSourceLike(Optional.ofNullable(this.buildConfigSource()).orElse(new NodeConfigSourceBuilder().build()));
    }

    public ConfigSourceNested<A> editOrNewConfigSourceLike(NodeConfigSource item) {
        return this.withNewConfigSourceLike(Optional.ofNullable(this.buildConfigSource()).orElse(item));
    }

    public String getExternalID() {
        return this.externalID;
    }

    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    public boolean hasExternalID() {
        return this.externalID != null;
    }

    public String getPodCIDR() {
        return this.podCIDR;
    }

    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    public boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    public A addToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.add(index, item);
        return (A)this;
    }

    public A setToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.set(index, item);
        return (A)this;
    }

    public A addToPodCIDRs(String ... items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    public A addAllToPodCIDRs(Collection<String> items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    public A removeFromPodCIDRs(String ... items) {
        if (this.podCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPodCIDRs(Collection<String> items) {
        if (this.podCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    public List<String> getPodCIDRs() {
        return this.podCIDRs;
    }

    public String getPodCIDR(int index) {
        return this.podCIDRs.get(index);
    }

    public String getFirstPodCIDR() {
        return this.podCIDRs.get(0);
    }

    public String getLastPodCIDR() {
        return this.podCIDRs.get(this.podCIDRs.size() - 1);
    }

    public String getMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodCIDRs(List<String> podCIDRs) {
        if (podCIDRs != null) {
            this.podCIDRs = new ArrayList<String>();
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        } else {
            this.podCIDRs = null;
        }
        return (A)this;
    }

    public A withPodCIDRs(String ... podCIDRs) {
        if (this.podCIDRs != null) {
            this.podCIDRs.clear();
            this._visitables.remove("podCIDRs");
        }
        if (podCIDRs != null) {
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        }
        return (A)this;
    }

    public boolean hasPodCIDRs() {
        return this.podCIDRs != null && !this.podCIDRs.isEmpty();
    }

    public String getProviderID() {
        return this.providerID;
    }

    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    public boolean hasProviderID() {
        return this.providerID != null;
    }

    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(index, builder);
            this.taints.add(index, builder);
        }
        return (A)this;
    }

    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").set(index, builder);
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A removeFromTaints(Taint ... items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTaints(Collection<Taint> items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTaints(Predicate<TaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)this;
        }
        Iterator<TaintBuilder> each = this.taints.iterator();
        Object visitables = this._visitables.get("taints");
        while (each.hasNext()) {
            TaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Taint> buildTaints() {
        return this.taints != null ? NodeSpecFluent.build(this.taints) : null;
    }

    public Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    public Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    public Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<Taint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove("taints");
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    public TaintsNested<A> addNewTaint() {
        return new TaintsNested(-1, null);
    }

    public TaintsNested<A> addNewTaintLike(Taint item) {
        return new TaintsNested(-1, item);
    }

    public TaintsNested<A> setNewTaintLike(int index, Taint item) {
        return new TaintsNested(index, item);
    }

    public TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    public TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public Boolean getUnschedulable() {
        return this.unschedulable;
    }

    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    public boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecFluent that = (NodeSpecFluent)o;
        if (!Objects.equals(this.configSource, that.configSource)) {
            return false;
        }
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals(this.podCIDR, that.podCIDR)) {
            return false;
        }
        if (!Objects.equals(this.podCIDRs, that.podCIDRs)) {
            return false;
        }
        if (!Objects.equals(this.providerID, that.providerID)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        if (!Objects.equals(this.unschedulable, that.unschedulable)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configSource, this.externalID, this.podCIDR, this.podCIDRs, this.providerID, this.taints, this.unschedulable, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configSource != null) {
            sb.append("configSource:");
            sb.append(this.configSource + ",");
        }
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.podCIDR != null) {
            sb.append("podCIDR:");
            sb.append(this.podCIDR + ",");
        }
        if (this.podCIDRs != null && !this.podCIDRs.isEmpty()) {
            sb.append("podCIDRs:");
            sb.append(this.podCIDRs + ",");
        }
        if (this.providerID != null) {
            sb.append("providerID:");
            sb.append(this.providerID + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(this.taints + ",");
        }
        if (this.unschedulable != null) {
            sb.append("unschedulable:");
            sb.append(this.unschedulable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withUnschedulable() {
        return this.withUnschedulable(true);
    }

    public class TaintsNested<N>
    extends TaintFluent<TaintsNested<N>>
    implements Nested<N> {
        TaintBuilder builder;
        int index;

        TaintsNested(int index, Taint item) {
            this.index = index;
            this.builder = new TaintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluent.this.setToTaints(this.index, this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }

    public class ConfigSourceNested<N>
    extends NodeConfigSourceFluent<ConfigSourceNested<N>>
    implements Nested<N> {
        NodeConfigSourceBuilder builder;

        ConfigSourceNested(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluent.this.withConfigSource(this.builder.build());
        }

        public N endConfigSource() {
            return this.and();
        }
    }
}

