/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAWSConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSAzureConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfig;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.ManageDNSGCPConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ManageDNSConfigFluent<A extends ManageDNSConfigFluent<A>>
extends BaseFluent<A> {
    private ManageDNSAWSConfigBuilder aws;
    private ManageDNSAzureConfigBuilder azure;
    private List<String> domains = new ArrayList<String>();
    private ManageDNSGCPConfigBuilder gcp;
    private Map<String, Object> additionalProperties;

    public ManageDNSConfigFluent() {
    }

    public ManageDNSConfigFluent(ManageDNSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ManageDNSConfig instance) {
        ManageDNSConfig manageDNSConfig = instance = instance != null ? instance : new ManageDNSConfig();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withDomains(instance.getDomains());
            this.withGcp(instance.getGcp());
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withDomains(instance.getDomains());
            this.withGcp(instance.getGcp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ManageDNSAWSConfig buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(ManageDNSAWSConfig aws) {
        this._visitables.get("aws").remove(this.aws);
        if (aws != null) {
            this.aws = new ManageDNSAWSConfigBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get("aws").remove(this.aws);
        }
        return (A)this;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(ManageDNSAWSConfig item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new ManageDNSAWSConfigBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(ManageDNSAWSConfig item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public ManageDNSAzureConfig buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    public A withAzure(ManageDNSAzureConfig azure) {
        this._visitables.get("azure").remove(this.azure);
        if (azure != null) {
            this.azure = new ManageDNSAzureConfigBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get("azure").remove(this.azure);
        }
        return (A)this;
    }

    public boolean hasAzure() {
        return this.azure != null;
    }

    public AzureNested<A> withNewAzure() {
        return new AzureNested(null);
    }

    public AzureNested<A> withNewAzureLike(ManageDNSAzureConfig item) {
        return new AzureNested(item);
    }

    public AzureNested<A> editAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(null));
    }

    public AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(new ManageDNSAzureConfigBuilder().build()));
    }

    public AzureNested<A> editOrNewAzureLike(ManageDNSAzureConfig item) {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(item));
    }

    public A addToDomains(int index, String item) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(index, item);
        return (A)this;
    }

    public A setToDomains(int index, String item) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.set(index, item);
        return (A)this;
    }

    public A addToDomains(String ... items) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        for (String item : items) {
            this.domains.add(item);
        }
        return (A)this;
    }

    public A addAllToDomains(Collection<String> items) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        for (String item : items) {
            this.domains.add(item);
        }
        return (A)this;
    }

    public A removeFromDomains(String ... items) {
        if (this.domains == null) {
            return (A)this;
        }
        for (String item : items) {
            this.domains.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDomains(Collection<String> items) {
        if (this.domains == null) {
            return (A)this;
        }
        for (String item : items) {
            this.domains.remove(item);
        }
        return (A)this;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public String getDomain(int index) {
        return this.domains.get(index);
    }

    public String getFirstDomain() {
        return this.domains.get(0);
    }

    public String getLastDomain() {
        return this.domains.get(this.domains.size() - 1);
    }

    public String getMatchingDomain(Predicate<String> predicate) {
        for (String item : this.domains) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDomain(Predicate<String> predicate) {
        for (String item : this.domains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDomains(List<String> domains) {
        if (domains != null) {
            this.domains = new ArrayList<String>();
            for (String item : domains) {
                this.addToDomains(item);
            }
        } else {
            this.domains = null;
        }
        return (A)this;
    }

    public A withDomains(String ... domains) {
        if (this.domains != null) {
            this.domains.clear();
            this._visitables.remove("domains");
        }
        if (domains != null) {
            for (String item : domains) {
                this.addToDomains(item);
            }
        }
        return (A)this;
    }

    public boolean hasDomains() {
        return this.domains != null && !this.domains.isEmpty();
    }

    public ManageDNSGCPConfig buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    public A withGcp(ManageDNSGCPConfig gcp) {
        this._visitables.get("gcp").remove(this.gcp);
        if (gcp != null) {
            this.gcp = new ManageDNSGCPConfigBuilder(gcp);
            this._visitables.get("gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get("gcp").remove(this.gcp);
        }
        return (A)this;
    }

    public boolean hasGcp() {
        return this.gcp != null;
    }

    public GcpNested<A> withNewGcp() {
        return new GcpNested(null);
    }

    public GcpNested<A> withNewGcpLike(ManageDNSGCPConfig item) {
        return new GcpNested(item);
    }

    public GcpNested<A> editGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(null));
    }

    public GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(new ManageDNSGCPConfigBuilder().build()));
    }

    public GcpNested<A> editOrNewGcpLike(ManageDNSGCPConfig item) {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManageDNSConfigFluent that = (ManageDNSConfigFluent)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        if (!Objects.equals(this.domains, that.domains)) {
            return false;
        }
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.domains, this.gcp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.domains != null && !this.domains.isEmpty()) {
            sb.append("domains:");
            sb.append(this.domains + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GcpNested<N>
    extends ManageDNSGCPConfigFluent<GcpNested<N>>
    implements Nested<N> {
        ManageDNSGCPConfigBuilder builder;

        GcpNested(ManageDNSGCPConfig item) {
            this.builder = new ManageDNSGCPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluent.this.withGcp(this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class AzureNested<N>
    extends ManageDNSAzureConfigFluent<AzureNested<N>>
    implements Nested<N> {
        ManageDNSAzureConfigBuilder builder;

        AzureNested(ManageDNSAzureConfig item) {
            this.builder = new ManageDNSAzureConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluent.this.withAzure(this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends ManageDNSAWSConfigFluent<AwsNested<N>>
    implements Nested<N> {
        ManageDNSAWSConfigBuilder builder;

        AwsNested(ManageDNSAWSConfig item) {
            this.builder = new ManageDNSAWSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ManageDNSConfigFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

