/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConfigMapFileReference;
import io.fabric8.openshift.api.model.v6_9.operator.v1.AddPage;
import io.fabric8.openshift.api.model.v6_9.operator.v1.AddPageBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.AddPageFluent;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ConsoleCustomization;
import io.fabric8.openshift.api.model.v6_9.operator.v1.DeveloperConsoleCatalogCustomization;
import io.fabric8.openshift.api.model.v6_9.operator.v1.DeveloperConsoleCatalogCustomizationBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.DeveloperConsoleCatalogCustomizationFluent;
import io.fabric8.openshift.api.model.v6_9.operator.v1.Perspective;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PerspectiveBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PerspectiveFluent;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProjectAccess;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProjectAccessBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProjectAccessFluent;
import io.fabric8.openshift.api.model.v6_9.operator.v1.QuickStarts;
import io.fabric8.openshift.api.model.v6_9.operator.v1.QuickStartsBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.QuickStartsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsoleCustomizationFluent<A extends ConsoleCustomizationFluent<A>>
extends BaseFluent<A> {
    private AddPageBuilder addPage;
    private String brand;
    private ConfigMapFileReference customLogoFile;
    private String customProductName;
    private DeveloperConsoleCatalogCustomizationBuilder developerCatalog;
    private String documentationBaseURL;
    private ArrayList<PerspectiveBuilder> perspectives = new ArrayList();
    private ProjectAccessBuilder projectAccess;
    private QuickStartsBuilder quickStarts;
    private Map<String, Object> additionalProperties;

    public ConsoleCustomizationFluent() {
    }

    public ConsoleCustomizationFluent(ConsoleCustomization instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsoleCustomization instance) {
        ConsoleCustomization consoleCustomization = instance = instance != null ? instance : new ConsoleCustomization();
        if (instance != null) {
            this.withAddPage(instance.getAddPage());
            this.withBrand(instance.getBrand());
            this.withCustomLogoFile(instance.getCustomLogoFile());
            this.withCustomProductName(instance.getCustomProductName());
            this.withDeveloperCatalog(instance.getDeveloperCatalog());
            this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
            this.withPerspectives(instance.getPerspectives());
            this.withProjectAccess(instance.getProjectAccess());
            this.withQuickStarts(instance.getQuickStarts());
            this.withAddPage(instance.getAddPage());
            this.withBrand(instance.getBrand());
            this.withCustomLogoFile(instance.getCustomLogoFile());
            this.withCustomProductName(instance.getCustomProductName());
            this.withDeveloperCatalog(instance.getDeveloperCatalog());
            this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
            this.withPerspectives(instance.getPerspectives());
            this.withProjectAccess(instance.getProjectAccess());
            this.withQuickStarts(instance.getQuickStarts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddPage buildAddPage() {
        return this.addPage != null ? this.addPage.build() : null;
    }

    public A withAddPage(AddPage addPage) {
        this._visitables.get("addPage").remove(this.addPage);
        if (addPage != null) {
            this.addPage = new AddPageBuilder(addPage);
            this._visitables.get("addPage").add(this.addPage);
        } else {
            this.addPage = null;
            this._visitables.get("addPage").remove(this.addPage);
        }
        return (A)this;
    }

    public boolean hasAddPage() {
        return this.addPage != null;
    }

    public AddPageNested<A> withNewAddPage() {
        return new AddPageNested(null);
    }

    public AddPageNested<A> withNewAddPageLike(AddPage item) {
        return new AddPageNested(item);
    }

    public AddPageNested<A> editAddPage() {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(null));
    }

    public AddPageNested<A> editOrNewAddPage() {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(new AddPageBuilder().build()));
    }

    public AddPageNested<A> editOrNewAddPageLike(AddPage item) {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(item));
    }

    public String getBrand() {
        return this.brand;
    }

    public A withBrand(String brand) {
        this.brand = brand;
        return (A)this;
    }

    public boolean hasBrand() {
        return this.brand != null;
    }

    public ConfigMapFileReference getCustomLogoFile() {
        return this.customLogoFile;
    }

    public A withCustomLogoFile(ConfigMapFileReference customLogoFile) {
        this.customLogoFile = customLogoFile;
        return (A)this;
    }

    public boolean hasCustomLogoFile() {
        return this.customLogoFile != null;
    }

    public A withNewCustomLogoFile(String key, String name) {
        return this.withCustomLogoFile(new ConfigMapFileReference(key, name));
    }

    public String getCustomProductName() {
        return this.customProductName;
    }

    public A withCustomProductName(String customProductName) {
        this.customProductName = customProductName;
        return (A)this;
    }

    public boolean hasCustomProductName() {
        return this.customProductName != null;
    }

    public DeveloperConsoleCatalogCustomization buildDeveloperCatalog() {
        return this.developerCatalog != null ? this.developerCatalog.build() : null;
    }

    public A withDeveloperCatalog(DeveloperConsoleCatalogCustomization developerCatalog) {
        this._visitables.get("developerCatalog").remove(this.developerCatalog);
        if (developerCatalog != null) {
            this.developerCatalog = new DeveloperConsoleCatalogCustomizationBuilder(developerCatalog);
            this._visitables.get("developerCatalog").add(this.developerCatalog);
        } else {
            this.developerCatalog = null;
            this._visitables.get("developerCatalog").remove(this.developerCatalog);
        }
        return (A)this;
    }

    public boolean hasDeveloperCatalog() {
        return this.developerCatalog != null;
    }

    public DeveloperCatalogNested<A> withNewDeveloperCatalog() {
        return new DeveloperCatalogNested(null);
    }

    public DeveloperCatalogNested<A> withNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
        return new DeveloperCatalogNested(item);
    }

    public DeveloperCatalogNested<A> editDeveloperCatalog() {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(null));
    }

    public DeveloperCatalogNested<A> editOrNewDeveloperCatalog() {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(new DeveloperConsoleCatalogCustomizationBuilder().build()));
    }

    public DeveloperCatalogNested<A> editOrNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(item));
    }

    public String getDocumentationBaseURL() {
        return this.documentationBaseURL;
    }

    public A withDocumentationBaseURL(String documentationBaseURL) {
        this.documentationBaseURL = documentationBaseURL;
        return (A)this;
    }

    public boolean hasDocumentationBaseURL() {
        return this.documentationBaseURL != null;
    }

    public A addToPerspectives(int index, Perspective item) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        PerspectiveBuilder builder = new PerspectiveBuilder(item);
        if (index < 0 || index >= this.perspectives.size()) {
            this._visitables.get("perspectives").add(builder);
            this.perspectives.add(builder);
        } else {
            this._visitables.get("perspectives").add(index, builder);
            this.perspectives.add(index, builder);
        }
        return (A)this;
    }

    public A setToPerspectives(int index, Perspective item) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        PerspectiveBuilder builder = new PerspectiveBuilder(item);
        if (index < 0 || index >= this.perspectives.size()) {
            this._visitables.get("perspectives").add(builder);
            this.perspectives.add(builder);
        } else {
            this._visitables.get("perspectives").set(index, builder);
            this.perspectives.set(index, builder);
        }
        return (A)this;
    }

    public A addToPerspectives(Perspective ... items) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get("perspectives").add(builder);
            this.perspectives.add(builder);
        }
        return (A)this;
    }

    public A addAllToPerspectives(Collection<Perspective> items) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get("perspectives").add(builder);
            this.perspectives.add(builder);
        }
        return (A)this;
    }

    public A removeFromPerspectives(Perspective ... items) {
        if (this.perspectives == null) {
            return (A)this;
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get("perspectives").remove(builder);
            this.perspectives.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPerspectives(Collection<Perspective> items) {
        if (this.perspectives == null) {
            return (A)this;
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get("perspectives").remove(builder);
            this.perspectives.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPerspectives(Predicate<PerspectiveBuilder> predicate) {
        if (this.perspectives == null) {
            return (A)this;
        }
        Iterator<PerspectiveBuilder> each = this.perspectives.iterator();
        Object visitables = this._visitables.get("perspectives");
        while (each.hasNext()) {
            PerspectiveBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Perspective> buildPerspectives() {
        return this.perspectives != null ? ConsoleCustomizationFluent.build(this.perspectives) : null;
    }

    public Perspective buildPerspective(int index) {
        return this.perspectives.get(index).build();
    }

    public Perspective buildFirstPerspective() {
        return this.perspectives.get(0).build();
    }

    public Perspective buildLastPerspective() {
        return this.perspectives.get(this.perspectives.size() - 1).build();
    }

    public Perspective buildMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        for (PerspectiveBuilder item : this.perspectives) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        for (PerspectiveBuilder item : this.perspectives) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPerspectives(List<Perspective> perspectives) {
        if (this.perspectives != null) {
            this._visitables.get("perspectives").clear();
        }
        if (perspectives != null) {
            this.perspectives = new ArrayList();
            for (Perspective item : perspectives) {
                this.addToPerspectives(item);
            }
        } else {
            this.perspectives = null;
        }
        return (A)this;
    }

    public A withPerspectives(Perspective ... perspectives) {
        if (this.perspectives != null) {
            this.perspectives.clear();
            this._visitables.remove("perspectives");
        }
        if (perspectives != null) {
            for (Perspective item : perspectives) {
                this.addToPerspectives(item);
            }
        }
        return (A)this;
    }

    public boolean hasPerspectives() {
        return this.perspectives != null && !this.perspectives.isEmpty();
    }

    public PerspectivesNested<A> addNewPerspective() {
        return new PerspectivesNested(-1, null);
    }

    public PerspectivesNested<A> addNewPerspectiveLike(Perspective item) {
        return new PerspectivesNested(-1, item);
    }

    public PerspectivesNested<A> setNewPerspectiveLike(int index, Perspective item) {
        return new PerspectivesNested(index, item);
    }

    public PerspectivesNested<A> editPerspective(int index) {
        if (this.perspectives.size() <= index) {
            throw new RuntimeException("Can't edit perspectives. Index exceeds size.");
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public PerspectivesNested<A> editFirstPerspective() {
        if (this.perspectives.size() == 0) {
            throw new RuntimeException("Can't edit first perspectives. The list is empty.");
        }
        return this.setNewPerspectiveLike(0, this.buildPerspective(0));
    }

    public PerspectivesNested<A> editLastPerspective() {
        int index = this.perspectives.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last perspectives. The list is empty.");
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public PerspectivesNested<A> editMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.perspectives.size(); ++i) {
            if (!predicate.test(this.perspectives.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching perspectives. No match found.");
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public ProjectAccess buildProjectAccess() {
        return this.projectAccess != null ? this.projectAccess.build() : null;
    }

    public A withProjectAccess(ProjectAccess projectAccess) {
        this._visitables.get("projectAccess").remove(this.projectAccess);
        if (projectAccess != null) {
            this.projectAccess = new ProjectAccessBuilder(projectAccess);
            this._visitables.get("projectAccess").add(this.projectAccess);
        } else {
            this.projectAccess = null;
            this._visitables.get("projectAccess").remove(this.projectAccess);
        }
        return (A)this;
    }

    public boolean hasProjectAccess() {
        return this.projectAccess != null;
    }

    public ProjectAccessNested<A> withNewProjectAccess() {
        return new ProjectAccessNested(null);
    }

    public ProjectAccessNested<A> withNewProjectAccessLike(ProjectAccess item) {
        return new ProjectAccessNested(item);
    }

    public ProjectAccessNested<A> editProjectAccess() {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(null));
    }

    public ProjectAccessNested<A> editOrNewProjectAccess() {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(new ProjectAccessBuilder().build()));
    }

    public ProjectAccessNested<A> editOrNewProjectAccessLike(ProjectAccess item) {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(item));
    }

    public QuickStarts buildQuickStarts() {
        return this.quickStarts != null ? this.quickStarts.build() : null;
    }

    public A withQuickStarts(QuickStarts quickStarts) {
        this._visitables.get("quickStarts").remove(this.quickStarts);
        if (quickStarts != null) {
            this.quickStarts = new QuickStartsBuilder(quickStarts);
            this._visitables.get("quickStarts").add(this.quickStarts);
        } else {
            this.quickStarts = null;
            this._visitables.get("quickStarts").remove(this.quickStarts);
        }
        return (A)this;
    }

    public boolean hasQuickStarts() {
        return this.quickStarts != null;
    }

    public QuickStartsNested<A> withNewQuickStarts() {
        return new QuickStartsNested(null);
    }

    public QuickStartsNested<A> withNewQuickStartsLike(QuickStarts item) {
        return new QuickStartsNested(item);
    }

    public QuickStartsNested<A> editQuickStarts() {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(null));
    }

    public QuickStartsNested<A> editOrNewQuickStarts() {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(new QuickStartsBuilder().build()));
    }

    public QuickStartsNested<A> editOrNewQuickStartsLike(QuickStarts item) {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleCustomizationFluent that = (ConsoleCustomizationFluent)o;
        if (!Objects.equals(this.addPage, that.addPage)) {
            return false;
        }
        if (!Objects.equals(this.brand, that.brand)) {
            return false;
        }
        if (!Objects.equals(this.customLogoFile, that.customLogoFile)) {
            return false;
        }
        if (!Objects.equals(this.customProductName, that.customProductName)) {
            return false;
        }
        if (!Objects.equals(this.developerCatalog, that.developerCatalog)) {
            return false;
        }
        if (!Objects.equals(this.documentationBaseURL, that.documentationBaseURL)) {
            return false;
        }
        if (!Objects.equals(this.perspectives, that.perspectives)) {
            return false;
        }
        if (!Objects.equals(this.projectAccess, that.projectAccess)) {
            return false;
        }
        if (!Objects.equals(this.quickStarts, that.quickStarts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addPage, this.brand, this.customLogoFile, this.customProductName, this.developerCatalog, this.documentationBaseURL, this.perspectives, this.projectAccess, this.quickStarts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addPage != null) {
            sb.append("addPage:");
            sb.append(this.addPage + ",");
        }
        if (this.brand != null) {
            sb.append("brand:");
            sb.append(this.brand + ",");
        }
        if (this.customLogoFile != null) {
            sb.append("customLogoFile:");
            sb.append(this.customLogoFile + ",");
        }
        if (this.customProductName != null) {
            sb.append("customProductName:");
            sb.append(this.customProductName + ",");
        }
        if (this.developerCatalog != null) {
            sb.append("developerCatalog:");
            sb.append(this.developerCatalog + ",");
        }
        if (this.documentationBaseURL != null) {
            sb.append("documentationBaseURL:");
            sb.append(this.documentationBaseURL + ",");
        }
        if (this.perspectives != null && !this.perspectives.isEmpty()) {
            sb.append("perspectives:");
            sb.append(this.perspectives + ",");
        }
        if (this.projectAccess != null) {
            sb.append("projectAccess:");
            sb.append(this.projectAccess + ",");
        }
        if (this.quickStarts != null) {
            sb.append("quickStarts:");
            sb.append(this.quickStarts + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class QuickStartsNested<N>
    extends QuickStartsFluent<QuickStartsNested<N>>
    implements Nested<N> {
        QuickStartsBuilder builder;

        QuickStartsNested(QuickStarts item) {
            this.builder = new QuickStartsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluent.this.withQuickStarts(this.builder.build());
        }

        public N endQuickStarts() {
            return this.and();
        }
    }

    public class ProjectAccessNested<N>
    extends ProjectAccessFluent<ProjectAccessNested<N>>
    implements Nested<N> {
        ProjectAccessBuilder builder;

        ProjectAccessNested(ProjectAccess item) {
            this.builder = new ProjectAccessBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluent.this.withProjectAccess(this.builder.build());
        }

        public N endProjectAccess() {
            return this.and();
        }
    }

    public class PerspectivesNested<N>
    extends PerspectiveFluent<PerspectivesNested<N>>
    implements Nested<N> {
        PerspectiveBuilder builder;
        int index;

        PerspectivesNested(int index, Perspective item) {
            this.index = index;
            this.builder = new PerspectiveBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluent.this.setToPerspectives(this.index, this.builder.build());
        }

        public N endPerspective() {
            return this.and();
        }
    }

    public class DeveloperCatalogNested<N>
    extends DeveloperConsoleCatalogCustomizationFluent<DeveloperCatalogNested<N>>
    implements Nested<N> {
        DeveloperConsoleCatalogCustomizationBuilder builder;

        DeveloperCatalogNested(DeveloperConsoleCatalogCustomization item) {
            this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluent.this.withDeveloperCatalog(this.builder.build());
        }

        public N endDeveloperCatalog() {
            return this.and();
        }
    }

    public class AddPageNested<N>
    extends AddPageFluent<AddPageNested<N>>
    implements Nested<N> {
        AddPageBuilder builder;

        AddPageNested(AddPage item) {
            this.builder = new AddPageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluent.this.withAddPage(this.builder.build());
        }

        public N endAddPage() {
            return this.and();
        }
    }
}

