/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.NamespaceSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceSelectorFluent<A extends NamespaceSelectorFluent<A>>
extends BaseFluent<A> {
    private Boolean any;
    private List<String> matchNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NamespaceSelectorFluent() {
    }

    public NamespaceSelectorFluent(NamespaceSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamespaceSelector instance) {
        NamespaceSelector namespaceSelector = instance = instance != null ? instance : new NamespaceSelector();
        if (instance != null) {
            this.withAny(instance.getAny());
            this.withMatchNames(instance.getMatchNames());
            this.withAny(instance.getAny());
            this.withMatchNames(instance.getMatchNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAny() {
        return this.any;
    }

    public A withAny(Boolean any) {
        this.any = any;
        return (A)this;
    }

    public boolean hasAny() {
        return this.any != null;
    }

    public A addToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.add(index, item);
        return (A)this;
    }

    public A setToMatchNames(int index, String item) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        this.matchNames.set(index, item);
        return (A)this;
    }

    public A addToMatchNames(String ... items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)this;
    }

    public A addAllToMatchNames(Collection<String> items) {
        if (this.matchNames == null) {
            this.matchNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchNames.add(item);
        }
        return (A)this;
    }

    public A removeFromMatchNames(String ... items) {
        if (this.matchNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMatchNames(Collection<String> items) {
        if (this.matchNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getMatchNames() {
        return this.matchNames;
    }

    public String getMatchName(int index) {
        return this.matchNames.get(index);
    }

    public String getFirstMatchName() {
        return this.matchNames.get(0);
    }

    public String getLastMatchName() {
        return this.matchNames.get(this.matchNames.size() - 1);
    }

    public String getMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMatchName(Predicate<String> predicate) {
        for (String item : this.matchNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchNames(List<String> matchNames) {
        if (matchNames != null) {
            this.matchNames = new ArrayList<String>();
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        } else {
            this.matchNames = null;
        }
        return (A)this;
    }

    public A withMatchNames(String ... matchNames) {
        if (this.matchNames != null) {
            this.matchNames.clear();
            this._visitables.remove("matchNames");
        }
        if (matchNames != null) {
            for (String item : matchNames) {
                this.addToMatchNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchNames() {
        return this.matchNames != null && !this.matchNames.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSelectorFluent that = (NamespaceSelectorFluent)o;
        if (!Objects.equals(this.any, that.any)) {
            return false;
        }
        if (!Objects.equals(this.matchNames, that.matchNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.any, this.matchNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.any != null) {
            sb.append("any:");
            sb.append(this.any + ",");
        }
        if (this.matchNames != null && !this.matchNames.isEmpty()) {
            sb.append("matchNames:");
            sb.append(this.matchNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAny() {
        return this.withAny(true);
    }
}

