/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.AlertmanagerConfiguration;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.AlertmanagerGlobalConfig;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.AlertmanagerGlobalConfigBuilder;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.AlertmanagerGlobalConfigFluent;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.SecretOrConfigMapFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AlertmanagerConfigurationFluent<A extends AlertmanagerConfigurationFluent<A>>
extends BaseFluent<A> {
    private AlertmanagerGlobalConfigBuilder global;
    private String name;
    private ArrayList<SecretOrConfigMapBuilder> templates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AlertmanagerConfigurationFluent() {
    }

    public AlertmanagerConfigurationFluent(AlertmanagerConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertmanagerConfiguration instance) {
        AlertmanagerConfiguration alertmanagerConfiguration = instance = instance != null ? instance : new AlertmanagerConfiguration();
        if (instance != null) {
            this.withGlobal(instance.getGlobal());
            this.withName(instance.getName());
            this.withTemplates(instance.getTemplates());
            this.withGlobal(instance.getGlobal());
            this.withName(instance.getName());
            this.withTemplates(instance.getTemplates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AlertmanagerGlobalConfig buildGlobal() {
        return this.global != null ? this.global.build() : null;
    }

    public A withGlobal(AlertmanagerGlobalConfig global) {
        this._visitables.get("global").remove(this.global);
        if (global != null) {
            this.global = new AlertmanagerGlobalConfigBuilder(global);
            this._visitables.get("global").add(this.global);
        } else {
            this.global = null;
            this._visitables.get("global").remove(this.global);
        }
        return (A)this;
    }

    public boolean hasGlobal() {
        return this.global != null;
    }

    public GlobalNested<A> withNewGlobal() {
        return new GlobalNested(null);
    }

    public GlobalNested<A> withNewGlobalLike(AlertmanagerGlobalConfig item) {
        return new GlobalNested(item);
    }

    public GlobalNested<A> editGlobal() {
        return this.withNewGlobalLike(Optional.ofNullable(this.buildGlobal()).orElse(null));
    }

    public GlobalNested<A> editOrNewGlobal() {
        return this.withNewGlobalLike(Optional.ofNullable(this.buildGlobal()).orElse(new AlertmanagerGlobalConfigBuilder().build()));
    }

    public GlobalNested<A> editOrNewGlobalLike(AlertmanagerGlobalConfig item) {
        return this.withNewGlobalLike(Optional.ofNullable(this.buildGlobal()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToTemplates(int index, SecretOrConfigMap item) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
        if (index < 0 || index >= this.templates.size()) {
            this._visitables.get("templates").add(builder);
            this.templates.add(builder);
        } else {
            this._visitables.get("templates").add(index, builder);
            this.templates.add(index, builder);
        }
        return (A)this;
    }

    public A setToTemplates(int index, SecretOrConfigMap item) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
        if (index < 0 || index >= this.templates.size()) {
            this._visitables.get("templates").add(builder);
            this.templates.add(builder);
        } else {
            this._visitables.get("templates").set(index, builder);
            this.templates.set(index, builder);
        }
        return (A)this;
    }

    public A addToTemplates(SecretOrConfigMap ... items) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        for (SecretOrConfigMap item : items) {
            SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
            this._visitables.get("templates").add(builder);
            this.templates.add(builder);
        }
        return (A)this;
    }

    public A addAllToTemplates(Collection<SecretOrConfigMap> items) {
        if (this.templates == null) {
            this.templates = new ArrayList();
        }
        for (SecretOrConfigMap item : items) {
            SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
            this._visitables.get("templates").add(builder);
            this.templates.add(builder);
        }
        return (A)this;
    }

    public A removeFromTemplates(SecretOrConfigMap ... items) {
        if (this.templates == null) {
            return (A)this;
        }
        for (SecretOrConfigMap item : items) {
            SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
            this._visitables.get("templates").remove(builder);
            this.templates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTemplates(Collection<SecretOrConfigMap> items) {
        if (this.templates == null) {
            return (A)this;
        }
        for (SecretOrConfigMap item : items) {
            SecretOrConfigMapBuilder builder = new SecretOrConfigMapBuilder(item);
            this._visitables.get("templates").remove(builder);
            this.templates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTemplates(Predicate<SecretOrConfigMapBuilder> predicate) {
        if (this.templates == null) {
            return (A)this;
        }
        Iterator<SecretOrConfigMapBuilder> each = this.templates.iterator();
        Object visitables = this._visitables.get("templates");
        while (each.hasNext()) {
            SecretOrConfigMapBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SecretOrConfigMap> buildTemplates() {
        return this.templates != null ? AlertmanagerConfigurationFluent.build(this.templates) : null;
    }

    public SecretOrConfigMap buildTemplate(int index) {
        return this.templates.get(index).build();
    }

    public SecretOrConfigMap buildFirstTemplate() {
        return this.templates.get(0).build();
    }

    public SecretOrConfigMap buildLastTemplate() {
        return this.templates.get(this.templates.size() - 1).build();
    }

    public SecretOrConfigMap buildMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
        for (SecretOrConfigMapBuilder item : this.templates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
        for (SecretOrConfigMapBuilder item : this.templates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTemplates(List<SecretOrConfigMap> templates) {
        if (this.templates != null) {
            this._visitables.get("templates").clear();
        }
        if (templates != null) {
            this.templates = new ArrayList();
            for (SecretOrConfigMap item : templates) {
                this.addToTemplates(item);
            }
        } else {
            this.templates = null;
        }
        return (A)this;
    }

    public A withTemplates(SecretOrConfigMap ... templates) {
        if (this.templates != null) {
            this.templates.clear();
            this._visitables.remove("templates");
        }
        if (templates != null) {
            for (SecretOrConfigMap item : templates) {
                this.addToTemplates(item);
            }
        }
        return (A)this;
    }

    public boolean hasTemplates() {
        return this.templates != null && !this.templates.isEmpty();
    }

    public TemplatesNested<A> addNewTemplate() {
        return new TemplatesNested(-1, null);
    }

    public TemplatesNested<A> addNewTemplateLike(SecretOrConfigMap item) {
        return new TemplatesNested(-1, item);
    }

    public TemplatesNested<A> setNewTemplateLike(int index, SecretOrConfigMap item) {
        return new TemplatesNested(index, item);
    }

    public TemplatesNested<A> editTemplate(int index) {
        if (this.templates.size() <= index) {
            throw new RuntimeException("Can't edit templates. Index exceeds size.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public TemplatesNested<A> editFirstTemplate() {
        if (this.templates.size() == 0) {
            throw new RuntimeException("Can't edit first templates. The list is empty.");
        }
        return this.setNewTemplateLike(0, this.buildTemplate(0));
    }

    public TemplatesNested<A> editLastTemplate() {
        int index = this.templates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last templates. The list is empty.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public TemplatesNested<A> editMatchingTemplate(Predicate<SecretOrConfigMapBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.templates.size(); ++i) {
            if (!predicate.test(this.templates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching templates. No match found.");
        }
        return this.setNewTemplateLike(index, this.buildTemplate(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerConfigurationFluent that = (AlertmanagerConfigurationFluent)o;
        if (!Objects.equals(this.global, that.global)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.templates, that.templates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.global, this.name, this.templates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.global != null) {
            sb.append("global:");
            sb.append(this.global + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.templates != null && !this.templates.isEmpty()) {
            sb.append("templates:");
            sb.append(this.templates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplatesNested<N>
    extends SecretOrConfigMapFluent<TemplatesNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;
        int index;

        TemplatesNested(int index, SecretOrConfigMap item) {
            this.index = index;
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerConfigurationFluent.this.setToTemplates(this.index, this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class GlobalNested<N>
    extends AlertmanagerGlobalConfigFluent<GlobalNested<N>>
    implements Nested<N> {
        AlertmanagerGlobalConfigBuilder builder;

        GlobalNested(AlertmanagerGlobalConfig item) {
            this.builder = new AlertmanagerGlobalConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerConfigurationFluent.this.withGlobal(this.builder.build());
        }

        public N endGlobal() {
            return this.and();
        }
    }
}

