/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.machine.v1alpha1.SubnetFilter;
import io.fabric8.openshift.api.model.v6_9.machine.v1alpha1.SubnetFilterBuilder;
import io.fabric8.openshift.api.model.v6_9.machine.v1alpha1.SubnetFilterFluent;
import io.fabric8.openshift.api.model.v6_9.machine.v1alpha1.SubnetParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SubnetParamFluent<A extends SubnetParamFluent<A>>
extends BaseFluent<A> {
    private SubnetFilterBuilder filter;
    private Boolean portSecurity;
    private List<String> portTags = new ArrayList<String>();
    private String uuid;
    private Map<String, Object> additionalProperties;

    public SubnetParamFluent() {
    }

    public SubnetParamFluent(SubnetParam instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SubnetParam instance) {
        SubnetParam subnetParam = instance = instance != null ? instance : new SubnetParam();
        if (instance != null) {
            this.withFilter(instance.getFilter());
            this.withPortSecurity(instance.getPortSecurity());
            this.withPortTags(instance.getPortTags());
            this.withUuid(instance.getUuid());
            this.withFilter(instance.getFilter());
            this.withPortSecurity(instance.getPortSecurity());
            this.withPortTags(instance.getPortTags());
            this.withUuid(instance.getUuid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SubnetFilter buildFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    public A withFilter(SubnetFilter filter) {
        this._visitables.get("filter").remove(this.filter);
        if (filter != null) {
            this.filter = new SubnetFilterBuilder(filter);
            this._visitables.get("filter").add(this.filter);
        } else {
            this.filter = null;
            this._visitables.get("filter").remove(this.filter);
        }
        return (A)this;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public FilterNested<A> withNewFilter() {
        return new FilterNested(null);
    }

    public FilterNested<A> withNewFilterLike(SubnetFilter item) {
        return new FilterNested(item);
    }

    public FilterNested<A> editFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(null));
    }

    public FilterNested<A> editOrNewFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(new SubnetFilterBuilder().build()));
    }

    public FilterNested<A> editOrNewFilterLike(SubnetFilter item) {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(item));
    }

    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    public A withPortSecurity(Boolean portSecurity) {
        this.portSecurity = portSecurity;
        return (A)this;
    }

    public boolean hasPortSecurity() {
        return this.portSecurity != null;
    }

    public A addToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.add(index, item);
        return (A)this;
    }

    public A setToPortTags(int index, String item) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        this.portTags.set(index, item);
        return (A)this;
    }

    public A addToPortTags(String ... items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)this;
    }

    public A addAllToPortTags(Collection<String> items) {
        if (this.portTags == null) {
            this.portTags = new ArrayList<String>();
        }
        for (String item : items) {
            this.portTags.add(item);
        }
        return (A)this;
    }

    public A removeFromPortTags(String ... items) {
        if (this.portTags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPortTags(Collection<String> items) {
        if (this.portTags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.portTags.remove(item);
        }
        return (A)this;
    }

    public List<String> getPortTags() {
        return this.portTags;
    }

    public String getPortTag(int index) {
        return this.portTags.get(index);
    }

    public String getFirstPortTag() {
        return this.portTags.get(0);
    }

    public String getLastPortTag() {
        return this.portTags.get(this.portTags.size() - 1);
    }

    public String getMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPortTag(Predicate<String> predicate) {
        for (String item : this.portTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortTags(List<String> portTags) {
        if (portTags != null) {
            this.portTags = new ArrayList<String>();
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        } else {
            this.portTags = null;
        }
        return (A)this;
    }

    public A withPortTags(String ... portTags) {
        if (this.portTags != null) {
            this.portTags.clear();
            this._visitables.remove("portTags");
        }
        if (portTags != null) {
            for (String item : portTags) {
                this.addToPortTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasPortTags() {
        return this.portTags != null && !this.portTags.isEmpty();
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid = uuid;
        return (A)this;
    }

    public boolean hasUuid() {
        return this.uuid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubnetParamFluent that = (SubnetParamFluent)o;
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.portSecurity, that.portSecurity)) {
            return false;
        }
        if (!Objects.equals(this.portTags, that.portTags)) {
            return false;
        }
        if (!Objects.equals(this.uuid, that.uuid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filter, this.portSecurity, this.portTags, this.uuid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter != null) {
            sb.append("filter:");
            sb.append(this.filter + ",");
        }
        if (this.portSecurity != null) {
            sb.append("portSecurity:");
            sb.append(this.portSecurity + ",");
        }
        if (this.portTags != null && !this.portTags.isEmpty()) {
            sb.append("portTags:");
            sb.append(this.portTags + ",");
        }
        if (this.uuid != null) {
            sb.append("uuid:");
            sb.append(this.uuid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPortSecurity() {
        return this.withPortSecurity(true);
    }

    public class FilterNested<N>
    extends SubnetFilterFluent<FilterNested<N>>
    implements Nested<N> {
        SubnetFilterBuilder builder;

        FilterNested(SubnetFilter item) {
            this.builder = new SubnetFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubnetParamFluent.this.withFilter(this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

