/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.hive.v1.SecretMapping;
import io.fabric8.openshift.api.model.v6_9.hive.v1.SecretReference;
import io.fabric8.openshift.api.model.v6_9.hive.v1.SecretReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.SecretReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SecretMappingFluent<A extends SecretMappingFluent<A>>
extends BaseFluent<A> {
    private SecretReferenceBuilder sourceRef;
    private SecretReferenceBuilder targetRef;
    private Map<String, Object> additionalProperties;

    public SecretMappingFluent() {
    }

    public SecretMappingFluent(SecretMapping instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecretMapping instance) {
        SecretMapping secretMapping = instance = instance != null ? instance : new SecretMapping();
        if (instance != null) {
            this.withSourceRef(instance.getSourceRef());
            this.withTargetRef(instance.getTargetRef());
            this.withSourceRef(instance.getSourceRef());
            this.withTargetRef(instance.getTargetRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretReference buildSourceRef() {
        return this.sourceRef != null ? this.sourceRef.build() : null;
    }

    public A withSourceRef(SecretReference sourceRef) {
        this._visitables.get("sourceRef").remove(this.sourceRef);
        if (sourceRef != null) {
            this.sourceRef = new SecretReferenceBuilder(sourceRef);
            this._visitables.get("sourceRef").add(this.sourceRef);
        } else {
            this.sourceRef = null;
            this._visitables.get("sourceRef").remove(this.sourceRef);
        }
        return (A)this;
    }

    public boolean hasSourceRef() {
        return this.sourceRef != null;
    }

    public A withNewSourceRef(String name, String namespace) {
        return this.withSourceRef(new SecretReference(name, namespace));
    }

    public SourceRefNested<A> withNewSourceRef() {
        return new SourceRefNested(null);
    }

    public SourceRefNested<A> withNewSourceRefLike(SecretReference item) {
        return new SourceRefNested(item);
    }

    public SourceRefNested<A> editSourceRef() {
        return this.withNewSourceRefLike(Optional.ofNullable(this.buildSourceRef()).orElse(null));
    }

    public SourceRefNested<A> editOrNewSourceRef() {
        return this.withNewSourceRefLike(Optional.ofNullable(this.buildSourceRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public SourceRefNested<A> editOrNewSourceRefLike(SecretReference item) {
        return this.withNewSourceRefLike(Optional.ofNullable(this.buildSourceRef()).orElse(item));
    }

    public SecretReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    public A withTargetRef(SecretReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new SecretReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get("targetRef").remove(this.targetRef);
        }
        return (A)this;
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public A withNewTargetRef(String name, String namespace) {
        return this.withTargetRef(new SecretReference(name, namespace));
    }

    public TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNested(null);
    }

    public TargetRefNested<A> withNewTargetRefLike(SecretReference item) {
        return new TargetRefNested(item);
    }

    public TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(null));
    }

    public TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public TargetRefNested<A> editOrNewTargetRefLike(SecretReference item) {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretMappingFluent that = (SecretMappingFluent)o;
        if (!Objects.equals(this.sourceRef, that.sourceRef)) {
            return false;
        }
        if (!Objects.equals(this.targetRef, that.targetRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourceRef, this.targetRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceRef != null) {
            sb.append("sourceRef:");
            sb.append(this.sourceRef + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefNested<N>
    extends SecretReferenceFluent<TargetRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        TargetRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecretMappingFluent.this.withTargetRef(this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }

    public class SourceRefNested<N>
    extends SecretReferenceFluent<SourceRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        SourceRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecretMappingFluent.this.withSourceRef(this.builder.build());
        }

        public N endSourceRef() {
            return this.and();
        }
    }
}

