/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.Duration;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterImageSetReference;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterImageSetReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterImageSetReferenceFluent;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterPoolClaimLifetime;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterPoolClaimLifetimeBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterPoolClaimLifetimeFluent;
import io.fabric8.openshift.api.model.v6_9.hive.v1.ClusterPoolSpec;
import io.fabric8.openshift.api.model.v6_9.hive.v1.HibernationConfig;
import io.fabric8.openshift.api.model.v6_9.hive.v1.HibernationConfigBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.HibernationConfigFluent;
import io.fabric8.openshift.api.model.v6_9.hive.v1.InventoryEntry;
import io.fabric8.openshift.api.model.v6_9.hive.v1.InventoryEntryBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.InventoryEntryFluent;
import io.fabric8.openshift.api.model.v6_9.hive.v1.Platform;
import io.fabric8.openshift.api.model.v6_9.hive.v1.PlatformBuilder;
import io.fabric8.openshift.api.model.v6_9.hive.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterPoolSpecFluent<A extends ClusterPoolSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private String baseDomain;
    private ClusterPoolClaimLifetimeBuilder claimLifetime;
    private Duration hibernateAfter;
    private HibernationConfigBuilder hibernationConfig;
    private ClusterImageSetReferenceBuilder imageSetRef;
    private Integer installAttemptsLimit;
    private LocalObjectReferenceBuilder installConfigSecretTemplateRef;
    private ArrayList<InventoryEntryBuilder> inventory = new ArrayList();
    private Map<String, String> labels;
    private Integer maxConcurrent;
    private Integer maxSize;
    private PlatformBuilder platform;
    private LocalObjectReferenceBuilder pullSecretRef;
    private Integer runningCount;
    private Integer size;
    private Boolean skipMachinePools;
    private Map<String, Object> additionalProperties;

    public ClusterPoolSpecFluent() {
    }

    public ClusterPoolSpecFluent(ClusterPoolSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterPoolSpec instance) {
        ClusterPoolSpec clusterPoolSpec = instance = instance != null ? instance : new ClusterPoolSpec();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withBaseDomain(instance.getBaseDomain());
            this.withClaimLifetime(instance.getClaimLifetime());
            this.withHibernateAfter(instance.getHibernateAfter());
            this.withHibernationConfig(instance.getHibernationConfig());
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
            this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
            this.withInventory(instance.getInventory());
            this.withLabels(instance.getLabels());
            this.withMaxConcurrent(instance.getMaxConcurrent());
            this.withMaxSize(instance.getMaxSize());
            this.withPlatform(instance.getPlatform());
            this.withPullSecretRef(instance.getPullSecretRef());
            this.withRunningCount(instance.getRunningCount());
            this.withSize(instance.getSize());
            this.withSkipMachinePools(instance.getSkipMachinePools());
            this.withAnnotations(instance.getAnnotations());
            this.withBaseDomain(instance.getBaseDomain());
            this.withClaimLifetime(instance.getClaimLifetime());
            this.withHibernateAfter(instance.getHibernateAfter());
            this.withHibernationConfig(instance.getHibernationConfig());
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
            this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
            this.withInventory(instance.getInventory());
            this.withLabels(instance.getLabels());
            this.withMaxConcurrent(instance.getMaxConcurrent());
            this.withMaxSize(instance.getMaxSize());
            this.withPlatform(instance.getPlatform());
            this.withPullSecretRef(instance.getPullSecretRef());
            this.withRunningCount(instance.getRunningCount());
            this.withSize(instance.getSize());
            this.withSkipMachinePools(instance.getSkipMachinePools());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public ClusterPoolClaimLifetime buildClaimLifetime() {
        return this.claimLifetime != null ? this.claimLifetime.build() : null;
    }

    public A withClaimLifetime(ClusterPoolClaimLifetime claimLifetime) {
        this._visitables.get("claimLifetime").remove(this.claimLifetime);
        if (claimLifetime != null) {
            this.claimLifetime = new ClusterPoolClaimLifetimeBuilder(claimLifetime);
            this._visitables.get("claimLifetime").add(this.claimLifetime);
        } else {
            this.claimLifetime = null;
            this._visitables.get("claimLifetime").remove(this.claimLifetime);
        }
        return (A)this;
    }

    public boolean hasClaimLifetime() {
        return this.claimLifetime != null;
    }

    public ClaimLifetimeNested<A> withNewClaimLifetime() {
        return new ClaimLifetimeNested(null);
    }

    public ClaimLifetimeNested<A> withNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
        return new ClaimLifetimeNested(item);
    }

    public ClaimLifetimeNested<A> editClaimLifetime() {
        return this.withNewClaimLifetimeLike(Optional.ofNullable(this.buildClaimLifetime()).orElse(null));
    }

    public ClaimLifetimeNested<A> editOrNewClaimLifetime() {
        return this.withNewClaimLifetimeLike(Optional.ofNullable(this.buildClaimLifetime()).orElse(new ClusterPoolClaimLifetimeBuilder().build()));
    }

    public ClaimLifetimeNested<A> editOrNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
        return this.withNewClaimLifetimeLike(Optional.ofNullable(this.buildClaimLifetime()).orElse(item));
    }

    public Duration getHibernateAfter() {
        return this.hibernateAfter;
    }

    public A withHibernateAfter(Duration hibernateAfter) {
        this.hibernateAfter = hibernateAfter;
        return (A)this;
    }

    public boolean hasHibernateAfter() {
        return this.hibernateAfter != null;
    }

    public HibernationConfig buildHibernationConfig() {
        return this.hibernationConfig != null ? this.hibernationConfig.build() : null;
    }

    public A withHibernationConfig(HibernationConfig hibernationConfig) {
        this._visitables.get("hibernationConfig").remove(this.hibernationConfig);
        if (hibernationConfig != null) {
            this.hibernationConfig = new HibernationConfigBuilder(hibernationConfig);
            this._visitables.get("hibernationConfig").add(this.hibernationConfig);
        } else {
            this.hibernationConfig = null;
            this._visitables.get("hibernationConfig").remove(this.hibernationConfig);
        }
        return (A)this;
    }

    public boolean hasHibernationConfig() {
        return this.hibernationConfig != null;
    }

    public HibernationConfigNested<A> withNewHibernationConfig() {
        return new HibernationConfigNested(null);
    }

    public HibernationConfigNested<A> withNewHibernationConfigLike(HibernationConfig item) {
        return new HibernationConfigNested(item);
    }

    public HibernationConfigNested<A> editHibernationConfig() {
        return this.withNewHibernationConfigLike(Optional.ofNullable(this.buildHibernationConfig()).orElse(null));
    }

    public HibernationConfigNested<A> editOrNewHibernationConfig() {
        return this.withNewHibernationConfigLike(Optional.ofNullable(this.buildHibernationConfig()).orElse(new HibernationConfigBuilder().build()));
    }

    public HibernationConfigNested<A> editOrNewHibernationConfigLike(HibernationConfig item) {
        return this.withNewHibernationConfigLike(Optional.ofNullable(this.buildHibernationConfig()).orElse(item));
    }

    public ClusterImageSetReference buildImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    public A withImageSetRef(ClusterImageSetReference imageSetRef) {
        this._visitables.get("imageSetRef").remove(this.imageSetRef);
        if (imageSetRef != null) {
            this.imageSetRef = new ClusterImageSetReferenceBuilder(imageSetRef);
            this._visitables.get("imageSetRef").add(this.imageSetRef);
        } else {
            this.imageSetRef = null;
            this._visitables.get("imageSetRef").remove(this.imageSetRef);
        }
        return (A)this;
    }

    public boolean hasImageSetRef() {
        return this.imageSetRef != null;
    }

    public A withNewImageSetRef(String name) {
        return this.withImageSetRef(new ClusterImageSetReference(name));
    }

    public ImageSetRefNested<A> withNewImageSetRef() {
        return new ImageSetRefNested(null);
    }

    public ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
        return new ImageSetRefNested(item);
    }

    public ImageSetRefNested<A> editImageSetRef() {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(null));
    }

    public ImageSetRefNested<A> editOrNewImageSetRef() {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(new ClusterImageSetReferenceBuilder().build()));
    }

    public ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
        return this.withNewImageSetRefLike(Optional.ofNullable(this.buildImageSetRef()).orElse(item));
    }

    public Integer getInstallAttemptsLimit() {
        return this.installAttemptsLimit;
    }

    public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
        this.installAttemptsLimit = installAttemptsLimit;
        return (A)this;
    }

    public boolean hasInstallAttemptsLimit() {
        return this.installAttemptsLimit != null;
    }

    public LocalObjectReference buildInstallConfigSecretTemplateRef() {
        return this.installConfigSecretTemplateRef != null ? this.installConfigSecretTemplateRef.build() : null;
    }

    public A withInstallConfigSecretTemplateRef(LocalObjectReference installConfigSecretTemplateRef) {
        this._visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
        if (installConfigSecretTemplateRef != null) {
            this.installConfigSecretTemplateRef = new LocalObjectReferenceBuilder(installConfigSecretTemplateRef);
            this._visitables.get("installConfigSecretTemplateRef").add(this.installConfigSecretTemplateRef);
        } else {
            this.installConfigSecretTemplateRef = null;
            this._visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
        }
        return (A)this;
    }

    public boolean hasInstallConfigSecretTemplateRef() {
        return this.installConfigSecretTemplateRef != null;
    }

    public A withNewInstallConfigSecretTemplateRef(String name) {
        return this.withInstallConfigSecretTemplateRef(new LocalObjectReference(name));
    }

    public InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRef() {
        return new InstallConfigSecretTemplateRefNested(null);
    }

    public InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
        return new InstallConfigSecretTemplateRefNested(item);
    }

    public InstallConfigSecretTemplateRefNested<A> editInstallConfigSecretTemplateRef() {
        return this.withNewInstallConfigSecretTemplateRefLike(Optional.ofNullable(this.buildInstallConfigSecretTemplateRef()).orElse(null));
    }

    public InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRef() {
        return this.withNewInstallConfigSecretTemplateRefLike(Optional.ofNullable(this.buildInstallConfigSecretTemplateRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
        return this.withNewInstallConfigSecretTemplateRefLike(Optional.ofNullable(this.buildInstallConfigSecretTemplateRef()).orElse(item));
    }

    public A addToInventory(int index, InventoryEntry item) {
        if (this.inventory == null) {
            this.inventory = new ArrayList();
        }
        InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
        if (index < 0 || index >= this.inventory.size()) {
            this._visitables.get("inventory").add(builder);
            this.inventory.add(builder);
        } else {
            this._visitables.get("inventory").add(index, builder);
            this.inventory.add(index, builder);
        }
        return (A)this;
    }

    public A setToInventory(int index, InventoryEntry item) {
        if (this.inventory == null) {
            this.inventory = new ArrayList();
        }
        InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
        if (index < 0 || index >= this.inventory.size()) {
            this._visitables.get("inventory").add(builder);
            this.inventory.add(builder);
        } else {
            this._visitables.get("inventory").set(index, builder);
            this.inventory.set(index, builder);
        }
        return (A)this;
    }

    public A addToInventory(InventoryEntry ... items) {
        if (this.inventory == null) {
            this.inventory = new ArrayList();
        }
        for (InventoryEntry item : items) {
            InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
            this._visitables.get("inventory").add(builder);
            this.inventory.add(builder);
        }
        return (A)this;
    }

    public A addAllToInventory(Collection<InventoryEntry> items) {
        if (this.inventory == null) {
            this.inventory = new ArrayList();
        }
        for (InventoryEntry item : items) {
            InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
            this._visitables.get("inventory").add(builder);
            this.inventory.add(builder);
        }
        return (A)this;
    }

    public A removeFromInventory(InventoryEntry ... items) {
        if (this.inventory == null) {
            return (A)this;
        }
        for (InventoryEntry item : items) {
            InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
            this._visitables.get("inventory").remove(builder);
            this.inventory.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInventory(Collection<InventoryEntry> items) {
        if (this.inventory == null) {
            return (A)this;
        }
        for (InventoryEntry item : items) {
            InventoryEntryBuilder builder = new InventoryEntryBuilder(item);
            this._visitables.get("inventory").remove(builder);
            this.inventory.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInventory(Predicate<InventoryEntryBuilder> predicate) {
        if (this.inventory == null) {
            return (A)this;
        }
        Iterator<InventoryEntryBuilder> each = this.inventory.iterator();
        Object visitables = this._visitables.get("inventory");
        while (each.hasNext()) {
            InventoryEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<InventoryEntry> buildInventory() {
        return this.inventory != null ? ClusterPoolSpecFluent.build(this.inventory) : null;
    }

    public InventoryEntry buildInventory(int index) {
        return this.inventory.get(index).build();
    }

    public InventoryEntry buildFirstInventory() {
        return this.inventory.get(0).build();
    }

    public InventoryEntry buildLastInventory() {
        return this.inventory.get(this.inventory.size() - 1).build();
    }

    public InventoryEntry buildMatchingInventory(Predicate<InventoryEntryBuilder> predicate) {
        for (InventoryEntryBuilder item : this.inventory) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInventory(Predicate<InventoryEntryBuilder> predicate) {
        for (InventoryEntryBuilder item : this.inventory) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInventory(List<InventoryEntry> inventory) {
        if (this.inventory != null) {
            this._visitables.get("inventory").clear();
        }
        if (inventory != null) {
            this.inventory = new ArrayList();
            for (InventoryEntry item : inventory) {
                this.addToInventory(item);
            }
        } else {
            this.inventory = null;
        }
        return (A)this;
    }

    public A withInventory(InventoryEntry ... inventory) {
        if (this.inventory != null) {
            this.inventory.clear();
            this._visitables.remove("inventory");
        }
        if (inventory != null) {
            for (InventoryEntry item : inventory) {
                this.addToInventory(item);
            }
        }
        return (A)this;
    }

    public boolean hasInventory() {
        return this.inventory != null && !this.inventory.isEmpty();
    }

    public A addNewInventory(String kind, String name) {
        return this.addToInventory(new InventoryEntry(kind, name));
    }

    public InventoryNested<A> addNewInventory() {
        return new InventoryNested(-1, null);
    }

    public InventoryNested<A> addNewInventoryLike(InventoryEntry item) {
        return new InventoryNested(-1, item);
    }

    public InventoryNested<A> setNewInventoryLike(int index, InventoryEntry item) {
        return new InventoryNested(index, item);
    }

    public InventoryNested<A> editInventory(int index) {
        if (this.inventory.size() <= index) {
            throw new RuntimeException("Can't edit inventory. Index exceeds size.");
        }
        return this.setNewInventoryLike(index, this.buildInventory(index));
    }

    public InventoryNested<A> editFirstInventory() {
        if (this.inventory.size() == 0) {
            throw new RuntimeException("Can't edit first inventory. The list is empty.");
        }
        return this.setNewInventoryLike(0, this.buildInventory(0));
    }

    public InventoryNested<A> editLastInventory() {
        int index = this.inventory.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last inventory. The list is empty.");
        }
        return this.setNewInventoryLike(index, this.buildInventory(index));
    }

    public InventoryNested<A> editMatchingInventory(Predicate<InventoryEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!predicate.test(this.inventory.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching inventory. No match found.");
        }
        return this.setNewInventoryLike(index, this.buildInventory(index));
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public Integer getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public A withMaxConcurrent(Integer maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
        return (A)this;
    }

    public boolean hasMaxConcurrent() {
        return this.maxConcurrent != null;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public A withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return (A)this;
    }

    public boolean hasMaxSize() {
        return this.maxSize != null;
    }

    public Platform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public A withPlatform(Platform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new PlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(Platform item) {
        return new PlatformNested(item);
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new PlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(Platform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public LocalObjectReference buildPullSecretRef() {
        return this.pullSecretRef != null ? this.pullSecretRef.build() : null;
    }

    public A withPullSecretRef(LocalObjectReference pullSecretRef) {
        this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        if (pullSecretRef != null) {
            this.pullSecretRef = new LocalObjectReferenceBuilder(pullSecretRef);
            this._visitables.get("pullSecretRef").add(this.pullSecretRef);
        } else {
            this.pullSecretRef = null;
            this._visitables.get("pullSecretRef").remove(this.pullSecretRef);
        }
        return (A)this;
    }

    public boolean hasPullSecretRef() {
        return this.pullSecretRef != null;
    }

    public A withNewPullSecretRef(String name) {
        return this.withPullSecretRef(new LocalObjectReference(name));
    }

    public PullSecretRefNested<A> withNewPullSecretRef() {
        return new PullSecretRefNested(null);
    }

    public PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
        return new PullSecretRefNested(item);
    }

    public PullSecretRefNested<A> editPullSecretRef() {
        return this.withNewPullSecretRefLike(Optional.ofNullable(this.buildPullSecretRef()).orElse(null));
    }

    public PullSecretRefNested<A> editOrNewPullSecretRef() {
        return this.withNewPullSecretRefLike(Optional.ofNullable(this.buildPullSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
        return this.withNewPullSecretRefLike(Optional.ofNullable(this.buildPullSecretRef()).orElse(item));
    }

    public Integer getRunningCount() {
        return this.runningCount;
    }

    public A withRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
        return (A)this;
    }

    public boolean hasRunningCount() {
        return this.runningCount != null;
    }

    public Integer getSize() {
        return this.size;
    }

    public A withSize(Integer size) {
        this.size = size;
        return (A)this;
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public Boolean getSkipMachinePools() {
        return this.skipMachinePools;
    }

    public A withSkipMachinePools(Boolean skipMachinePools) {
        this.skipMachinePools = skipMachinePools;
        return (A)this;
    }

    public boolean hasSkipMachinePools() {
        return this.skipMachinePools != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPoolSpecFluent that = (ClusterPoolSpecFluent)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals(this.claimLifetime, that.claimLifetime)) {
            return false;
        }
        if (!Objects.equals(this.hibernateAfter, that.hibernateAfter)) {
            return false;
        }
        if (!Objects.equals(this.hibernationConfig, that.hibernationConfig)) {
            return false;
        }
        if (!Objects.equals(this.imageSetRef, that.imageSetRef)) {
            return false;
        }
        if (!Objects.equals(this.installAttemptsLimit, that.installAttemptsLimit)) {
            return false;
        }
        if (!Objects.equals(this.installConfigSecretTemplateRef, that.installConfigSecretTemplateRef)) {
            return false;
        }
        if (!Objects.equals(this.inventory, that.inventory)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.maxConcurrent, that.maxConcurrent)) {
            return false;
        }
        if (!Objects.equals(this.maxSize, that.maxSize)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.pullSecretRef, that.pullSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.runningCount, that.runningCount)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.skipMachinePools, that.skipMachinePools)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.baseDomain, this.claimLifetime, this.hibernateAfter, this.hibernationConfig, this.imageSetRef, this.installAttemptsLimit, this.installConfigSecretTemplateRef, this.inventory, this.labels, this.maxConcurrent, this.maxSize, this.platform, this.pullSecretRef, this.runningCount, this.size, this.skipMachinePools, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.claimLifetime != null) {
            sb.append("claimLifetime:");
            sb.append(this.claimLifetime + ",");
        }
        if (this.hibernateAfter != null) {
            sb.append("hibernateAfter:");
            sb.append(this.hibernateAfter + ",");
        }
        if (this.hibernationConfig != null) {
            sb.append("hibernationConfig:");
            sb.append(this.hibernationConfig + ",");
        }
        if (this.imageSetRef != null) {
            sb.append("imageSetRef:");
            sb.append(this.imageSetRef + ",");
        }
        if (this.installAttemptsLimit != null) {
            sb.append("installAttemptsLimit:");
            sb.append(this.installAttemptsLimit + ",");
        }
        if (this.installConfigSecretTemplateRef != null) {
            sb.append("installConfigSecretTemplateRef:");
            sb.append(this.installConfigSecretTemplateRef + ",");
        }
        if (this.inventory != null && !this.inventory.isEmpty()) {
            sb.append("inventory:");
            sb.append(this.inventory + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.maxConcurrent != null) {
            sb.append("maxConcurrent:");
            sb.append(this.maxConcurrent + ",");
        }
        if (this.maxSize != null) {
            sb.append("maxSize:");
            sb.append(this.maxSize + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.pullSecretRef != null) {
            sb.append("pullSecretRef:");
            sb.append(this.pullSecretRef + ",");
        }
        if (this.runningCount != null) {
            sb.append("runningCount:");
            sb.append(this.runningCount + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.skipMachinePools != null) {
            sb.append("skipMachinePools:");
            sb.append(this.skipMachinePools + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSkipMachinePools() {
        return this.withSkipMachinePools(true);
    }

    public class PullSecretRefNested<N>
    extends LocalObjectReferenceFluent<PullSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withPullSecretRef(this.builder.build());
        }

        public N endPullSecretRef() {
            return this.and();
        }
    }

    public class PlatformNested<N>
    extends PlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        PlatformBuilder builder;

        PlatformNested(Platform item) {
            this.builder = new PlatformBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }

    public class InventoryNested<N>
    extends InventoryEntryFluent<InventoryNested<N>>
    implements Nested<N> {
        InventoryEntryBuilder builder;
        int index;

        InventoryNested(int index, InventoryEntry item) {
            this.index = index;
            this.builder = new InventoryEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.setToInventory(this.index, this.builder.build());
        }

        public N endInventory() {
            return this.and();
        }
    }

    public class InstallConfigSecretTemplateRefNested<N>
    extends LocalObjectReferenceFluent<InstallConfigSecretTemplateRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstallConfigSecretTemplateRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withInstallConfigSecretTemplateRef(this.builder.build());
        }

        public N endInstallConfigSecretTemplateRef() {
            return this.and();
        }
    }

    public class ImageSetRefNested<N>
    extends ClusterImageSetReferenceFluent<ImageSetRefNested<N>>
    implements Nested<N> {
        ClusterImageSetReferenceBuilder builder;

        ImageSetRefNested(ClusterImageSetReference item) {
            this.builder = new ClusterImageSetReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withImageSetRef(this.builder.build());
        }

        public N endImageSetRef() {
            return this.and();
        }
    }

    public class HibernationConfigNested<N>
    extends HibernationConfigFluent<HibernationConfigNested<N>>
    implements Nested<N> {
        HibernationConfigBuilder builder;

        HibernationConfigNested(HibernationConfig item) {
            this.builder = new HibernationConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withHibernationConfig(this.builder.build());
        }

        public N endHibernationConfig() {
            return this.and();
        }
    }

    public class ClaimLifetimeNested<N>
    extends ClusterPoolClaimLifetimeFluent<ClaimLifetimeNested<N>>
    implements Nested<N> {
        ClusterPoolClaimLifetimeBuilder builder;

        ClaimLifetimeNested(ClusterPoolClaimLifetime item) {
            this.builder = new ClusterPoolClaimLifetimeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPoolSpecFluent.this.withClaimLifetime(this.builder.build());
        }

        public N endClaimLifetime() {
            return this.and();
        }
    }
}

