/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.CustomTLSProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomTLSProfileFluent<A extends CustomTLSProfileFluent<A>>
extends BaseFluent<A> {
    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;
    private Map<String, Object> additionalProperties;

    public CustomTLSProfileFluent() {
    }

    public CustomTLSProfileFluent(CustomTLSProfile instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomTLSProfile instance) {
        CustomTLSProfile customTLSProfile = instance = instance != null ? instance : new CustomTLSProfile();
        if (instance != null) {
            this.withCiphers(instance.getCiphers());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withCiphers(instance.getCiphers());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.add(index, item);
        return (A)this;
    }

    public A setToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.set(index, item);
        return (A)this;
    }

    public A addToCiphers(String ... items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    public A removeFromCiphers(String ... items) {
        if (this.ciphers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public String getCipher(int index) {
        return this.ciphers.get(index);
    }

    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    public String getLastCipher() {
        return this.ciphers.get(this.ciphers.size() - 1);
    }

    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCiphers(List<String> ciphers) {
        if (ciphers != null) {
            this.ciphers = new ArrayList<String>();
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        } else {
            this.ciphers = null;
        }
        return (A)this;
    }

    public A withCiphers(String ... ciphers) {
        if (this.ciphers != null) {
            this.ciphers.clear();
            this._visitables.remove("ciphers");
        }
        if (ciphers != null) {
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        }
        return (A)this;
    }

    public boolean hasCiphers() {
        return this.ciphers != null && !this.ciphers.isEmpty();
    }

    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)this;
    }

    public boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomTLSProfileFluent that = (CustomTLSProfileFluent)o;
        if (!Objects.equals(this.ciphers, that.ciphers)) {
            return false;
        }
        if (!Objects.equals(this.minTLSVersion, that.minTLSVersion)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ciphers, this.minTLSVersion, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ciphers != null && !this.ciphers.isEmpty()) {
            sb.append("ciphers:");
            sb.append(this.ciphers + ",");
        }
        if (this.minTLSVersion != null) {
            sb.append("minTLSVersion:");
            sb.append(this.minTLSVersion + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

