/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.Condition;
import io.fabric8.openshift.api.model.v6_9.config.v1.ComponentRouteStatus;
import io.fabric8.openshift.api.model.v6_9.config.v1.ObjectReference;
import io.fabric8.openshift.api.model.v6_9.config.v1.ObjectReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ObjectReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ComponentRouteStatusFluent<A extends ComponentRouteStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private List<String> consumingUsers = new ArrayList<String>();
    private List<String> currentHostnames = new ArrayList<String>();
    private String defaultHostname;
    private String name;
    private String namespace;
    private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ComponentRouteStatusFluent() {
    }

    public ComponentRouteStatusFluent(ComponentRouteStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ComponentRouteStatus instance) {
        ComponentRouteStatus componentRouteStatus = instance = instance != null ? instance : new ComponentRouteStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withConsumingUsers(instance.getConsumingUsers());
            this.withCurrentHostnames(instance.getCurrentHostnames());
            this.withDefaultHostname(instance.getDefaultHostname());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withRelatedObjects(instance.getRelatedObjects());
            this.withConditions(instance.getConditions());
            this.withConsumingUsers(instance.getConsumingUsers());
            this.withCurrentHostnames(instance.getCurrentHostnames());
            this.withDefaultHostname(instance.getDefaultHostname());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withRelatedObjects(instance.getRelatedObjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToConsumingUsers(int index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.add(index, item);
        return (A)this;
    }

    public A setToConsumingUsers(int index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.set(index, item);
        return (A)this;
    }

    public A addToConsumingUsers(String ... items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    public A addAllToConsumingUsers(Collection<String> items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    public A removeFromConsumingUsers(String ... items) {
        if (this.consumingUsers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConsumingUsers(Collection<String> items) {
        if (this.consumingUsers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    public List<String> getConsumingUsers() {
        return this.consumingUsers;
    }

    public String getConsumingUser(int index) {
        return this.consumingUsers.get(index);
    }

    public String getFirstConsumingUser() {
        return this.consumingUsers.get(0);
    }

    public String getLastConsumingUser() {
        return this.consumingUsers.get(this.consumingUsers.size() - 1);
    }

    public String getMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConsumingUsers(List<String> consumingUsers) {
        if (consumingUsers != null) {
            this.consumingUsers = new ArrayList<String>();
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        } else {
            this.consumingUsers = null;
        }
        return (A)this;
    }

    public A withConsumingUsers(String ... consumingUsers) {
        if (this.consumingUsers != null) {
            this.consumingUsers.clear();
            this._visitables.remove("consumingUsers");
        }
        if (consumingUsers != null) {
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        }
        return (A)this;
    }

    public boolean hasConsumingUsers() {
        return this.consumingUsers != null && !this.consumingUsers.isEmpty();
    }

    public A addToCurrentHostnames(int index, String item) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        this.currentHostnames.add(index, item);
        return (A)this;
    }

    public A setToCurrentHostnames(int index, String item) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        this.currentHostnames.set(index, item);
        return (A)this;
    }

    public A addToCurrentHostnames(String ... items) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.currentHostnames.add(item);
        }
        return (A)this;
    }

    public A addAllToCurrentHostnames(Collection<String> items) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.currentHostnames.add(item);
        }
        return (A)this;
    }

    public A removeFromCurrentHostnames(String ... items) {
        if (this.currentHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.currentHostnames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCurrentHostnames(Collection<String> items) {
        if (this.currentHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.currentHostnames.remove(item);
        }
        return (A)this;
    }

    public List<String> getCurrentHostnames() {
        return this.currentHostnames;
    }

    public String getCurrentHostname(int index) {
        return this.currentHostnames.get(index);
    }

    public String getFirstCurrentHostname() {
        return this.currentHostnames.get(0);
    }

    public String getLastCurrentHostname() {
        return this.currentHostnames.get(this.currentHostnames.size() - 1);
    }

    public String getMatchingCurrentHostname(Predicate<String> predicate) {
        for (String item : this.currentHostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCurrentHostname(Predicate<String> predicate) {
        for (String item : this.currentHostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCurrentHostnames(List<String> currentHostnames) {
        if (currentHostnames != null) {
            this.currentHostnames = new ArrayList<String>();
            for (String item : currentHostnames) {
                this.addToCurrentHostnames(item);
            }
        } else {
            this.currentHostnames = null;
        }
        return (A)this;
    }

    public A withCurrentHostnames(String ... currentHostnames) {
        if (this.currentHostnames != null) {
            this.currentHostnames.clear();
            this._visitables.remove("currentHostnames");
        }
        if (currentHostnames != null) {
            for (String item : currentHostnames) {
                this.addToCurrentHostnames(item);
            }
        }
        return (A)this;
    }

    public boolean hasCurrentHostnames() {
        return this.currentHostnames != null && !this.currentHostnames.isEmpty();
    }

    public String getDefaultHostname() {
        return this.defaultHostname;
    }

    public A withDefaultHostname(String defaultHostname) {
        this.defaultHostname = defaultHostname;
        return (A)this;
    }

    public boolean hasDefaultHostname() {
        return this.defaultHostname != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public A addToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get("relatedObjects").add(index, builder);
            this.relatedObjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get("relatedObjects").set(index, builder);
            this.relatedObjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.relatedObjects.iterator();
        Object visitables = this._visitables.get("relatedObjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ObjectReference> buildRelatedObjects() {
        return this.relatedObjects != null ? ComponentRouteStatusFluent.build(this.relatedObjects) : null;
    }

    public ObjectReference buildRelatedObject(int index) {
        return this.relatedObjects.get(index).build();
    }

    public ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    public ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(this.relatedObjects.size() - 1).build();
    }

    public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelatedObjects(List<ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) {
            this._visitables.get("relatedObjects").clear();
        }
        if (relatedObjects != null) {
            this.relatedObjects = new ArrayList();
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        } else {
            this.relatedObjects = null;
        }
        return (A)this;
    }

    public A withRelatedObjects(ObjectReference ... relatedObjects) {
        if (this.relatedObjects != null) {
            this.relatedObjects.clear();
            this._visitables.remove("relatedObjects");
        }
        if (relatedObjects != null) {
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasRelatedObjects() {
        return this.relatedObjects != null && !this.relatedObjects.isEmpty();
    }

    public A addNewRelatedObject(String group, String name, String namespace, String resource) {
        return this.addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
    }

    public RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNested(-1, null);
    }

    public RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
        return new RelatedObjectsNested(-1, item);
    }

    public RelatedObjectsNested<A> setNewRelatedObjectLike(int index, ObjectReference item) {
        return new RelatedObjectsNested(index, item);
    }

    public RelatedObjectsNested<A> editRelatedObject(int index) {
        if (this.relatedObjects.size() <= index) {
            throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public RelatedObjectsNested<A> editFirstRelatedObject() {
        if (this.relatedObjects.size() == 0) {
            throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(0, this.buildRelatedObject(0));
    }

    public RelatedObjectsNested<A> editLastRelatedObject() {
        int index = this.relatedObjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedObjects.size(); ++i) {
            if (!predicate.test(this.relatedObjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentRouteStatusFluent that = (ComponentRouteStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.consumingUsers, that.consumingUsers)) {
            return false;
        }
        if (!Objects.equals(this.currentHostnames, that.currentHostnames)) {
            return false;
        }
        if (!Objects.equals(this.defaultHostname, that.defaultHostname)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.relatedObjects, that.relatedObjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.consumingUsers, this.currentHostnames, this.defaultHostname, this.name, this.namespace, this.relatedObjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.consumingUsers != null && !this.consumingUsers.isEmpty()) {
            sb.append("consumingUsers:");
            sb.append(this.consumingUsers + ",");
        }
        if (this.currentHostnames != null && !this.currentHostnames.isEmpty()) {
            sb.append("currentHostnames:");
            sb.append(this.currentHostnames + ",");
        }
        if (this.defaultHostname != null) {
            sb.append("defaultHostname:");
            sb.append(this.defaultHostname + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.relatedObjects != null && !this.relatedObjects.isEmpty()) {
            sb.append("relatedObjects:");
            sb.append(this.relatedObjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RelatedObjectsNested<N>
    extends ObjectReferenceFluent<RelatedObjectsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        RelatedObjectsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ComponentRouteStatusFluent.this.setToRelatedObjects(this.index, this.builder.build());
        }

        public N endRelatedObject() {
            return this.and();
        }
    }
}

