/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterOperatorStatusCondition;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterOperatorStatusConditionBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterOperatorStatusConditionFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterVersionCapabilitiesStatus;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterVersionCapabilitiesStatusBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterVersionCapabilitiesStatusFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.ClusterVersionStatus;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConditionalUpdate;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConditionalUpdateBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConditionalUpdateFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.Release;
import io.fabric8.openshift.api.model.v6_9.config.v1.ReleaseBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ReleaseFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.UpdateHistory;
import io.fabric8.openshift.api.model.v6_9.config.v1.UpdateHistoryBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.UpdateHistoryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterVersionStatusFluent<A extends ClusterVersionStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ReleaseBuilder> availableUpdates = new ArrayList();
    private ClusterVersionCapabilitiesStatusBuilder capabilities;
    private ArrayList<ConditionalUpdateBuilder> conditionalUpdates = new ArrayList();
    private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList();
    private ReleaseBuilder desired;
    private ArrayList<UpdateHistoryBuilder> history = new ArrayList();
    private Long observedGeneration;
    private String versionHash;
    private Map<String, Object> additionalProperties;

    public ClusterVersionStatusFluent() {
    }

    public ClusterVersionStatusFluent(ClusterVersionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterVersionStatus instance) {
        ClusterVersionStatus clusterVersionStatus = instance = instance != null ? instance : new ClusterVersionStatus();
        if (instance != null) {
            this.withAvailableUpdates(instance.getAvailableUpdates());
            this.withCapabilities(instance.getCapabilities());
            this.withConditionalUpdates(instance.getConditionalUpdates());
            this.withConditions(instance.getConditions());
            this.withDesired(instance.getDesired());
            this.withHistory(instance.getHistory());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withVersionHash(instance.getVersionHash());
            this.withAvailableUpdates(instance.getAvailableUpdates());
            this.withCapabilities(instance.getCapabilities());
            this.withConditionalUpdates(instance.getConditionalUpdates());
            this.withConditions(instance.getConditions());
            this.withDesired(instance.getDesired());
            this.withHistory(instance.getHistory());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withVersionHash(instance.getVersionHash());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAvailableUpdates(int index, Release item) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        ReleaseBuilder builder = new ReleaseBuilder(item);
        if (index < 0 || index >= this.availableUpdates.size()) {
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        } else {
            this._visitables.get("availableUpdates").add(index, builder);
            this.availableUpdates.add(index, builder);
        }
        return (A)this;
    }

    public A setToAvailableUpdates(int index, Release item) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        ReleaseBuilder builder = new ReleaseBuilder(item);
        if (index < 0 || index >= this.availableUpdates.size()) {
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        } else {
            this._visitables.get("availableUpdates").set(index, builder);
            this.availableUpdates.set(index, builder);
        }
        return (A)this;
    }

    public A addToAvailableUpdates(Release ... items) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        }
        return (A)this;
    }

    public A addAllToAvailableUpdates(Collection<Release> items) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        }
        return (A)this;
    }

    public A removeFromAvailableUpdates(Release ... items) {
        if (this.availableUpdates == null) {
            return (A)this;
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").remove(builder);
            this.availableUpdates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAvailableUpdates(Collection<Release> items) {
        if (this.availableUpdates == null) {
            return (A)this;
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").remove(builder);
            this.availableUpdates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate) {
        if (this.availableUpdates == null) {
            return (A)this;
        }
        Iterator<ReleaseBuilder> each = this.availableUpdates.iterator();
        Object visitables = this._visitables.get("availableUpdates");
        while (each.hasNext()) {
            ReleaseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Release> buildAvailableUpdates() {
        return this.availableUpdates != null ? ClusterVersionStatusFluent.build(this.availableUpdates) : null;
    }

    public Release buildAvailableUpdate(int index) {
        return this.availableUpdates.get(index).build();
    }

    public Release buildFirstAvailableUpdate() {
        return this.availableUpdates.get(0).build();
    }

    public Release buildLastAvailableUpdate() {
        return this.availableUpdates.get(this.availableUpdates.size() - 1).build();
    }

    public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item : this.availableUpdates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item : this.availableUpdates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAvailableUpdates(List<Release> availableUpdates) {
        if (this.availableUpdates != null) {
            this._visitables.get("availableUpdates").clear();
        }
        if (availableUpdates != null) {
            this.availableUpdates = new ArrayList();
            for (Release item : availableUpdates) {
                this.addToAvailableUpdates(item);
            }
        } else {
            this.availableUpdates = null;
        }
        return (A)this;
    }

    public A withAvailableUpdates(Release ... availableUpdates) {
        if (this.availableUpdates != null) {
            this.availableUpdates.clear();
            this._visitables.remove("availableUpdates");
        }
        if (availableUpdates != null) {
            for (Release item : availableUpdates) {
                this.addToAvailableUpdates(item);
            }
        }
        return (A)this;
    }

    public boolean hasAvailableUpdates() {
        return this.availableUpdates != null && !this.availableUpdates.isEmpty();
    }

    public AvailableUpdatesNested<A> addNewAvailableUpdate() {
        return new AvailableUpdatesNested(-1, null);
    }

    public AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item) {
        return new AvailableUpdatesNested(-1, item);
    }

    public AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index, Release item) {
        return new AvailableUpdatesNested(index, item);
    }

    public AvailableUpdatesNested<A> editAvailableUpdate(int index) {
        if (this.availableUpdates.size() <= index) {
            throw new RuntimeException("Can't edit availableUpdates. Index exceeds size.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    public AvailableUpdatesNested<A> editFirstAvailableUpdate() {
        if (this.availableUpdates.size() == 0) {
            throw new RuntimeException("Can't edit first availableUpdates. The list is empty.");
        }
        return this.setNewAvailableUpdateLike(0, this.buildAvailableUpdate(0));
    }

    public AvailableUpdatesNested<A> editLastAvailableUpdate() {
        int index = this.availableUpdates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last availableUpdates. The list is empty.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    public AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.availableUpdates.size(); ++i) {
            if (!predicate.test(this.availableUpdates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching availableUpdates. No match found.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    public ClusterVersionCapabilitiesStatus buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public A withCapabilities(ClusterVersionCapabilitiesStatus capabilities) {
        this._visitables.get("capabilities").remove(this.capabilities);
        if (capabilities != null) {
            this.capabilities = new ClusterVersionCapabilitiesStatusBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get("capabilities").remove(this.capabilities);
        }
        return (A)this;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(ClusterVersionCapabilitiesStatus item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new ClusterVersionCapabilitiesStatusBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(ClusterVersionCapabilitiesStatus item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public A addToConditionalUpdates(int index, ConditionalUpdate item) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
        if (index < 0 || index >= this.conditionalUpdates.size()) {
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        } else {
            this._visitables.get("conditionalUpdates").add(index, builder);
            this.conditionalUpdates.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditionalUpdates(int index, ConditionalUpdate item) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
        if (index < 0 || index >= this.conditionalUpdates.size()) {
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        } else {
            this._visitables.get("conditionalUpdates").set(index, builder);
            this.conditionalUpdates.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditionalUpdates(ConditionalUpdate ... items) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditionalUpdates(Collection<ConditionalUpdate> items) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditionalUpdates(ConditionalUpdate ... items) {
        if (this.conditionalUpdates == null) {
            return (A)this;
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").remove(builder);
            this.conditionalUpdates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditionalUpdates(Collection<ConditionalUpdate> items) {
        if (this.conditionalUpdates == null) {
            return (A)this;
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").remove(builder);
            this.conditionalUpdates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditionalUpdates(Predicate<ConditionalUpdateBuilder> predicate) {
        if (this.conditionalUpdates == null) {
            return (A)this;
        }
        Iterator<ConditionalUpdateBuilder> each = this.conditionalUpdates.iterator();
        Object visitables = this._visitables.get("conditionalUpdates");
        while (each.hasNext()) {
            ConditionalUpdateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ConditionalUpdate> buildConditionalUpdates() {
        return this.conditionalUpdates != null ? ClusterVersionStatusFluent.build(this.conditionalUpdates) : null;
    }

    public ConditionalUpdate buildConditionalUpdate(int index) {
        return this.conditionalUpdates.get(index).build();
    }

    public ConditionalUpdate buildFirstConditionalUpdate() {
        return this.conditionalUpdates.get(0).build();
    }

    public ConditionalUpdate buildLastConditionalUpdate() {
        return this.conditionalUpdates.get(this.conditionalUpdates.size() - 1).build();
    }

    public ConditionalUpdate buildMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        for (ConditionalUpdateBuilder item : this.conditionalUpdates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        for (ConditionalUpdateBuilder item : this.conditionalUpdates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditionalUpdates(List<ConditionalUpdate> conditionalUpdates) {
        if (this.conditionalUpdates != null) {
            this._visitables.get("conditionalUpdates").clear();
        }
        if (conditionalUpdates != null) {
            this.conditionalUpdates = new ArrayList();
            for (ConditionalUpdate item : conditionalUpdates) {
                this.addToConditionalUpdates(item);
            }
        } else {
            this.conditionalUpdates = null;
        }
        return (A)this;
    }

    public A withConditionalUpdates(ConditionalUpdate ... conditionalUpdates) {
        if (this.conditionalUpdates != null) {
            this.conditionalUpdates.clear();
            this._visitables.remove("conditionalUpdates");
        }
        if (conditionalUpdates != null) {
            for (ConditionalUpdate item : conditionalUpdates) {
                this.addToConditionalUpdates(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditionalUpdates() {
        return this.conditionalUpdates != null && !this.conditionalUpdates.isEmpty();
    }

    public ConditionalUpdatesNested<A> addNewConditionalUpdate() {
        return new ConditionalUpdatesNested(-1, null);
    }

    public ConditionalUpdatesNested<A> addNewConditionalUpdateLike(ConditionalUpdate item) {
        return new ConditionalUpdatesNested(-1, item);
    }

    public ConditionalUpdatesNested<A> setNewConditionalUpdateLike(int index, ConditionalUpdate item) {
        return new ConditionalUpdatesNested(index, item);
    }

    public ConditionalUpdatesNested<A> editConditionalUpdate(int index) {
        if (this.conditionalUpdates.size() <= index) {
            throw new RuntimeException("Can't edit conditionalUpdates. Index exceeds size.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    public ConditionalUpdatesNested<A> editFirstConditionalUpdate() {
        if (this.conditionalUpdates.size() == 0) {
            throw new RuntimeException("Can't edit first conditionalUpdates. The list is empty.");
        }
        return this.setNewConditionalUpdateLike(0, this.buildConditionalUpdate(0));
    }

    public ConditionalUpdatesNested<A> editLastConditionalUpdate() {
        int index = this.conditionalUpdates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditionalUpdates. The list is empty.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    public ConditionalUpdatesNested<A> editMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditionalUpdates.size(); ++i) {
            if (!predicate.test(this.conditionalUpdates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditionalUpdates. No match found.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    public A addToConditions(int index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(ClusterOperatorStatusCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(ClusterOperatorStatusCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ClusterOperatorStatusConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ClusterOperatorStatusConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterOperatorStatusCondition> buildConditions() {
        return this.conditions != null ? ClusterVersionStatusFluent.build(this.conditions) : null;
    }

    public ClusterOperatorStatusCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ClusterOperatorStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ClusterOperatorStatusCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(ClusterOperatorStatusCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ClusterOperatorStatusCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Release buildDesired() {
        return this.desired != null ? this.desired.build() : null;
    }

    public A withDesired(Release desired) {
        this._visitables.get("desired").remove(this.desired);
        if (desired != null) {
            this.desired = new ReleaseBuilder(desired);
            this._visitables.get("desired").add(this.desired);
        } else {
            this.desired = null;
            this._visitables.get("desired").remove(this.desired);
        }
        return (A)this;
    }

    public boolean hasDesired() {
        return this.desired != null;
    }

    public DesiredNested<A> withNewDesired() {
        return new DesiredNested(null);
    }

    public DesiredNested<A> withNewDesiredLike(Release item) {
        return new DesiredNested(item);
    }

    public DesiredNested<A> editDesired() {
        return this.withNewDesiredLike(Optional.ofNullable(this.buildDesired()).orElse(null));
    }

    public DesiredNested<A> editOrNewDesired() {
        return this.withNewDesiredLike(Optional.ofNullable(this.buildDesired()).orElse(new ReleaseBuilder().build()));
    }

    public DesiredNested<A> editOrNewDesiredLike(Release item) {
        return this.withNewDesiredLike(Optional.ofNullable(this.buildDesired()).orElse(item));
    }

    public A addToHistory(int index, UpdateHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get("history").add(index, builder);
            this.history.add(index, builder);
        }
        return (A)this;
    }

    public A setToHistory(int index, UpdateHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
        if (index < 0 || index >= this.history.size()) {
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        } else {
            this._visitables.get("history").set(index, builder);
            this.history.set(index, builder);
        }
        return (A)this;
    }

    public A addToHistory(UpdateHistory ... items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    public A addAllToHistory(Collection<UpdateHistory> items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    public A removeFromHistory(UpdateHistory ... items) {
        if (this.history == null) {
            return (A)this;
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").remove(builder);
            this.history.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHistory(Collection<UpdateHistory> items) {
        if (this.history == null) {
            return (A)this;
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").remove(builder);
            this.history.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate) {
        if (this.history == null) {
            return (A)this;
        }
        Iterator<UpdateHistoryBuilder> each = this.history.iterator();
        Object visitables = this._visitables.get("history");
        while (each.hasNext()) {
            UpdateHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<UpdateHistory> buildHistory() {
        return this.history != null ? ClusterVersionStatusFluent.build(this.history) : null;
    }

    public UpdateHistory buildHistory(int index) {
        return this.history.get(index).build();
    }

    public UpdateHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    public UpdateHistory buildLastHistory() {
        return this.history.get(this.history.size() - 1).build();
    }

    public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHistory(List<UpdateHistory> history) {
        if (this.history != null) {
            this._visitables.get("history").clear();
        }
        if (history != null) {
            this.history = new ArrayList();
            for (UpdateHistory item : history) {
                this.addToHistory(item);
            }
        } else {
            this.history = null;
        }
        return (A)this;
    }

    public A withHistory(UpdateHistory ... history) {
        if (this.history != null) {
            this.history.clear();
            this._visitables.remove("history");
        }
        if (history != null) {
            for (UpdateHistory item : history) {
                this.addToHistory(item);
            }
        }
        return (A)this;
    }

    public boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    public HistoryNested<A> addNewHistory() {
        return new HistoryNested(-1, null);
    }

    public HistoryNested<A> addNewHistoryLike(UpdateHistory item) {
        return new HistoryNested(-1, item);
    }

    public HistoryNested<A> setNewHistoryLike(int index, UpdateHistory item) {
        return new HistoryNested(index, item);
    }

    public HistoryNested<A> editHistory(int index) {
        if (this.history.size() <= index) {
            throw new RuntimeException("Can't edit history. Index exceeds size.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editFirstHistory() {
        if (this.history.size() == 0) {
            throw new RuntimeException("Can't edit first history. The list is empty.");
        }
        return this.setNewHistoryLike(0, this.buildHistory(0));
    }

    public HistoryNested<A> editLastHistory() {
        int index = this.history.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last history. The list is empty.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.history.size(); ++i) {
            if (!predicate.test(this.history.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching history. No match found.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getVersionHash() {
        return this.versionHash;
    }

    public A withVersionHash(String versionHash) {
        this.versionHash = versionHash;
        return (A)this;
    }

    public boolean hasVersionHash() {
        return this.versionHash != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterVersionStatusFluent that = (ClusterVersionStatusFluent)o;
        if (!Objects.equals(this.availableUpdates, that.availableUpdates)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.conditionalUpdates, that.conditionalUpdates)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.desired, that.desired)) {
            return false;
        }
        if (!Objects.equals(this.history, that.history)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.versionHash, that.versionHash)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableUpdates, this.capabilities, this.conditionalUpdates, this.conditions, this.desired, this.history, this.observedGeneration, this.versionHash, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableUpdates != null && !this.availableUpdates.isEmpty()) {
            sb.append("availableUpdates:");
            sb.append(this.availableUpdates + ",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.conditionalUpdates != null && !this.conditionalUpdates.isEmpty()) {
            sb.append("conditionalUpdates:");
            sb.append(this.conditionalUpdates + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.desired != null) {
            sb.append("desired:");
            sb.append(this.desired + ",");
        }
        if (this.history != null && !this.history.isEmpty()) {
            sb.append("history:");
            sb.append(this.history + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.versionHash != null) {
            sb.append("versionHash:");
            sb.append(this.versionHash + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HistoryNested<N>
    extends UpdateHistoryFluent<HistoryNested<N>>
    implements Nested<N> {
        UpdateHistoryBuilder builder;
        int index;

        HistoryNested(int index, UpdateHistory item) {
            this.index = index;
            this.builder = new UpdateHistoryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.setToHistory(this.index, this.builder.build());
        }

        public N endHistory() {
            return this.and();
        }
    }

    public class DesiredNested<N>
    extends ReleaseFluent<DesiredNested<N>>
    implements Nested<N> {
        ReleaseBuilder builder;

        DesiredNested(Release item) {
            this.builder = new ReleaseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.withDesired(this.builder.build());
        }

        public N endDesired() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ClusterOperatorStatusConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ClusterOperatorStatusConditionBuilder builder;
        int index;

        ConditionsNested(int index, ClusterOperatorStatusCondition item) {
            this.index = index;
            this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class ConditionalUpdatesNested<N>
    extends ConditionalUpdateFluent<ConditionalUpdatesNested<N>>
    implements Nested<N> {
        ConditionalUpdateBuilder builder;
        int index;

        ConditionalUpdatesNested(int index, ConditionalUpdate item) {
            this.index = index;
            this.builder = new ConditionalUpdateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.setToConditionalUpdates(this.index, this.builder.build());
        }

        public N endConditionalUpdate() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends ClusterVersionCapabilitiesStatusFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        ClusterVersionCapabilitiesStatusBuilder builder;

        CapabilitiesNested(ClusterVersionCapabilitiesStatus item) {
            this.builder = new ClusterVersionCapabilitiesStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }

    public class AvailableUpdatesNested<N>
    extends ReleaseFluent<AvailableUpdatesNested<N>>
    implements Nested<N> {
        ReleaseBuilder builder;
        int index;

        AvailableUpdatesNested(int index, Release item) {
            this.index = index;
            this.builder = new ReleaseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluent.this.setToAvailableUpdates(this.index, this.builder.build());
        }

        public N endAvailableUpdate() {
            return this.and();
        }
    }
}

