/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.EnvVar;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_9.CustomBuildStrategy;
import io.fabric8.openshift.api.model.v6_9.SecretSpec;
import io.fabric8.openshift.api.model.v6_9.SecretSpecBuilder;
import io.fabric8.openshift.api.model.v6_9.SecretSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>>
extends BaseFluent<A> {
    private String buildAPIVersion;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean exposeDockerSocket;
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private LocalObjectReferenceBuilder pullSecret;
    private ArrayList<SecretSpecBuilder> secrets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public CustomBuildStrategyFluent() {
    }

    public CustomBuildStrategyFluent(CustomBuildStrategy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomBuildStrategy instance) {
        CustomBuildStrategy customBuildStrategy = instance = instance != null ? instance : new CustomBuildStrategy();
        if (instance != null) {
            this.withBuildAPIVersion(instance.getBuildAPIVersion());
            this.withEnv(instance.getEnv());
            this.withExposeDockerSocket(instance.getExposeDockerSocket());
            this.withForcePull(instance.getForcePull());
            this.withFrom(instance.getFrom());
            this.withPullSecret(instance.getPullSecret());
            this.withSecrets(instance.getSecrets());
            this.withBuildAPIVersion(instance.getBuildAPIVersion());
            this.withEnv(instance.getEnv());
            this.withExposeDockerSocket(instance.getExposeDockerSocket());
            this.withForcePull(instance.getForcePull());
            this.withFrom(instance.getFrom());
            this.withPullSecret(instance.getPullSecret());
            this.withSecrets(instance.getSecrets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBuildAPIVersion() {
        return this.buildAPIVersion;
    }

    public A withBuildAPIVersion(String buildAPIVersion) {
        this.buildAPIVersion = buildAPIVersion;
        return (A)this;
    }

    public boolean hasBuildAPIVersion() {
        return this.buildAPIVersion != null;
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.env.remove(item);
        }
        return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public Boolean getExposeDockerSocket() {
        return this.exposeDockerSocket;
    }

    public A withExposeDockerSocket(Boolean exposeDockerSocket) {
        this.exposeDockerSocket = exposeDockerSocket;
        return (A)this;
    }

    public boolean hasExposeDockerSocket() {
        return this.exposeDockerSocket != null;
    }

    public Boolean getForcePull() {
        return this.forcePull;
    }

    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    public boolean hasForcePull() {
        return this.forcePull != null;
    }

    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get("from").remove(this.from);
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNested(item);
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ObjectReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get("pullSecret").remove(this.pullSecret);
        }
        return (A)this;
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNested(null);
    }

    public PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNested(item);
    }

    public PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(null));
    }

    public PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(item));
    }

    public A addToSecrets(int index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(index, builder);
            this.secrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecrets(int index, SecretSpec item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretSpecBuilder builder = new SecretSpecBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecrets(SecretSpec ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<SecretSpec> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecrets(SecretSpec ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<SecretSpec> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SecretSpec item : items) {
            SecretSpecBuilder builder = new SecretSpecBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecrets(Predicate<SecretSpecBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<SecretSpecBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            SecretSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SecretSpec> buildSecrets() {
        return this.secrets != null ? CustomBuildStrategyFluent.build(this.secrets) : null;
    }

    public SecretSpec buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public SecretSpec buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public SecretSpec buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public SecretSpec buildMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        for (SecretSpecBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<SecretSpec> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(SecretSpec ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (SecretSpec item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(SecretSpec item) {
        return new SecretsNested(-1, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, SecretSpec item) {
        return new SecretsNested(index, item);
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<SecretSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomBuildStrategyFluent that = (CustomBuildStrategyFluent)o;
        if (!Objects.equals(this.buildAPIVersion, that.buildAPIVersion)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.exposeDockerSocket, that.exposeDockerSocket)) {
            return false;
        }
        if (!Objects.equals(this.forcePull, that.forcePull)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.buildAPIVersion, this.env, this.exposeDockerSocket, this.forcePull, this.from, this.pullSecret, this.secrets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildAPIVersion != null) {
            sb.append("buildAPIVersion:");
            sb.append(this.buildAPIVersion + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.exposeDockerSocket != null) {
            sb.append("exposeDockerSocket:");
            sb.append(this.exposeDockerSocket + ",");
        }
        if (this.forcePull != null) {
            sb.append("forcePull:");
            sb.append(this.forcePull + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(this.pullSecret + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withExposeDockerSocket() {
        return this.withExposeDockerSocket(true);
    }

    public A withForcePull() {
        return this.withForcePull(true);
    }

    public class SecretsNested<N>
    extends SecretSpecFluent<SecretsNested<N>>
    implements Nested<N> {
        SecretSpecBuilder builder;
        int index;

        SecretsNested(int index, SecretSpec item) {
            this.index = index;
            this.builder = new SecretSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class PullSecretNested<N>
    extends LocalObjectReferenceFluent<PullSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        PullSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluent.this.withPullSecret(this.builder.build());
        }

        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNested<N>
    extends ObjectReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        FromNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomBuildStrategyFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

