/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_9.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.v6_9.BuildConfigSpec;
import io.fabric8.openshift.api.model.v6_9.BuildOutput;
import io.fabric8.openshift.api.model.v6_9.BuildOutputBuilder;
import io.fabric8.openshift.api.model.v6_9.BuildOutputFluent;
import io.fabric8.openshift.api.model.v6_9.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.v6_9.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.v6_9.BuildPostCommitSpecFluent;
import io.fabric8.openshift.api.model.v6_9.BuildSource;
import io.fabric8.openshift.api.model.v6_9.BuildSourceBuilder;
import io.fabric8.openshift.api.model.v6_9.BuildSourceFluent;
import io.fabric8.openshift.api.model.v6_9.BuildStrategy;
import io.fabric8.openshift.api.model.v6_9.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.v6_9.BuildStrategyFluent;
import io.fabric8.openshift.api.model.v6_9.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.v6_9.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.v6_9.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.v6_9.SourceRevision;
import io.fabric8.openshift.api.model.v6_9.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.v6_9.SourceRevisionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Long completionDeadlineSeconds;
    private Integer failedBuildsHistoryLimit;
    private Boolean mountTrustedCA;
    private Map<String, String> nodeSelector;
    private BuildOutputBuilder output;
    private BuildPostCommitSpecBuilder postCommit;
    private ResourceRequirementsBuilder resources;
    private SourceRevisionBuilder revision;
    private String runPolicy;
    private String serviceAccount;
    private BuildSourceBuilder source;
    private BuildStrategyBuilder strategy;
    private Integer successfulBuildsHistoryLimit;
    private ArrayList<BuildTriggerPolicyBuilder> triggers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public BuildConfigSpecFluent() {
    }

    public BuildConfigSpecFluent(BuildConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildConfigSpec instance) {
        BuildConfigSpec buildConfigSpec = instance = instance != null ? instance : new BuildConfigSpec();
        if (instance != null) {
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
            this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
            this.withMountTrustedCA(instance.getMountTrustedCA());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOutput(instance.getOutput());
            this.withPostCommit(instance.getPostCommit());
            this.withResources(instance.getResources());
            this.withRevision(instance.getRevision());
            this.withRunPolicy(instance.getRunPolicy());
            this.withServiceAccount(instance.getServiceAccount());
            this.withSource(instance.getSource());
            this.withStrategy(instance.getStrategy());
            this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
            this.withTriggers(instance.getTriggers());
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
            this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
            this.withMountTrustedCA(instance.getMountTrustedCA());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOutput(instance.getOutput());
            this.withPostCommit(instance.getPostCommit());
            this.withResources(instance.getResources());
            this.withRevision(instance.getRevision());
            this.withRunPolicy(instance.getRunPolicy());
            this.withServiceAccount(instance.getServiceAccount());
            this.withSource(instance.getSource());
            this.withStrategy(instance.getStrategy());
            this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
            this.withTriggers(instance.getTriggers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)this;
    }

    public boolean hasCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds != null;
    }

    public Integer getFailedBuildsHistoryLimit() {
        return this.failedBuildsHistoryLimit;
    }

    public A withFailedBuildsHistoryLimit(Integer failedBuildsHistoryLimit) {
        this.failedBuildsHistoryLimit = failedBuildsHistoryLimit;
        return (A)this;
    }

    public boolean hasFailedBuildsHistoryLimit() {
        return this.failedBuildsHistoryLimit != null;
    }

    public Boolean getMountTrustedCA() {
        return this.mountTrustedCA;
    }

    public A withMountTrustedCA(Boolean mountTrustedCA) {
        this.mountTrustedCA = mountTrustedCA;
        return (A)this;
    }

    public boolean hasMountTrustedCA() {
        return this.mountTrustedCA != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public BuildOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    public A withOutput(BuildOutput output) {
        this._visitables.get("output").remove(this.output);
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.get("output").add(this.output);
        } else {
            this.output = null;
            this._visitables.get("output").remove(this.output);
        }
        return (A)this;
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public OutputNested<A> withNewOutput() {
        return new OutputNested(null);
    }

    public OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNested(item);
    }

    public OutputNested<A> editOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(null));
    }

    public OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(new BuildOutputBuilder().build()));
    }

    public OutputNested<A> editOrNewOutputLike(BuildOutput item) {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(item));
    }

    public BuildPostCommitSpec buildPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    public A withPostCommit(BuildPostCommitSpec postCommit) {
        this._visitables.get("postCommit").remove(this.postCommit);
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.get("postCommit").add(this.postCommit);
        } else {
            this.postCommit = null;
            this._visitables.get("postCommit").remove(this.postCommit);
        }
        return (A)this;
    }

    public boolean hasPostCommit() {
        return this.postCommit != null;
    }

    public PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNested(null);
    }

    public PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNested(item);
    }

    public PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(null));
    }

    public PostCommitNested<A> editOrNewPostCommit() {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(new BuildPostCommitSpecBuilder().build()));
    }

    public PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(item));
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    public A withRevision(SourceRevision revision) {
        this._visitables.get("revision").remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.get("revision").add(this.revision);
        } else {
            this.revision = null;
            this._visitables.get("revision").remove(this.revision);
        }
        return (A)this;
    }

    public boolean hasRevision() {
        return this.revision != null;
    }

    public RevisionNested<A> withNewRevision() {
        return new RevisionNested(null);
    }

    public RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(null));
    }

    public RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(new SourceRevisionBuilder().build()));
    }

    public RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(item));
    }

    public String getRunPolicy() {
        return this.runPolicy;
    }

    public A withRunPolicy(String runPolicy) {
        this.runPolicy = runPolicy;
        return (A)this;
    }

    public boolean hasRunPolicy() {
        return this.runPolicy != null;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public BuildSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(BuildSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new BuildSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(BuildSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public BuildStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    public A withStrategy(BuildStrategy strategy) {
        this._visitables.get("strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get("strategy").remove(this.strategy);
        }
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public StrategyNested<A> withNewStrategy() {
        return new StrategyNested(null);
    }

    public StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(null));
    }

    public StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(new BuildStrategyBuilder().build()));
    }

    public StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(item));
    }

    public Integer getSuccessfulBuildsHistoryLimit() {
        return this.successfulBuildsHistoryLimit;
    }

    public A withSuccessfulBuildsHistoryLimit(Integer successfulBuildsHistoryLimit) {
        this.successfulBuildsHistoryLimit = successfulBuildsHistoryLimit;
        return (A)this;
    }

    public boolean hasSuccessfulBuildsHistoryLimit() {
        return this.successfulBuildsHistoryLimit != null;
    }

    public A addToTriggers(int index, BuildTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get("triggers").add(index, builder);
            this.triggers.add(index, builder);
        }
        return (A)this;
    }

    public A setToTriggers(int index, BuildTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get("triggers").set(index, builder);
            this.triggers.set(index, builder);
        }
        return (A)this;
    }

    public A addToTriggers(BuildTriggerPolicy ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    public A addAllToTriggers(Collection<BuildTriggerPolicy> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    public A removeFromTriggers(BuildTriggerPolicy ... items) {
        if (this.triggers == null) {
            return (A)this;
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTriggers(Collection<BuildTriggerPolicy> items) {
        if (this.triggers == null) {
            return (A)this;
        }
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTriggers(Predicate<BuildTriggerPolicyBuilder> predicate) {
        if (this.triggers == null) {
            return (A)this;
        }
        Iterator<BuildTriggerPolicyBuilder> each = this.triggers.iterator();
        Object visitables = this._visitables.get("triggers");
        while (each.hasNext()) {
            BuildTriggerPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BuildTriggerPolicy> buildTriggers() {
        return this.triggers != null ? BuildConfigSpecFluent.build(this.triggers) : null;
    }

    public BuildTriggerPolicy buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    public BuildTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    public BuildTriggerPolicy buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    public BuildTriggerPolicy buildMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        for (BuildTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        for (BuildTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTriggers(List<BuildTriggerPolicy> triggers) {
        if (this.triggers != null) {
            this._visitables.get("triggers").clear();
        }
        if (triggers != null) {
            this.triggers = new ArrayList();
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = null;
        }
        return (A)this;
    }

    public A withTriggers(BuildTriggerPolicy ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
            this._visitables.remove("triggers");
        }
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    public boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    public TriggersNested<A> addNewTrigger() {
        return new TriggersNested(-1, null);
    }

    public TriggersNested<A> addNewTriggerLike(BuildTriggerPolicy item) {
        return new TriggersNested(-1, item);
    }

    public TriggersNested<A> setNewTriggerLike(int index, BuildTriggerPolicy item) {
        return new TriggersNested(index, item);
    }

    public TriggersNested<A> editTrigger(int index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException("Can't edit first triggers. The list is empty.");
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    public TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggers. The list is empty.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public TriggersNested<A> editMatchingTrigger(Predicate<BuildTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.test(this.triggers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggers. No match found.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecFluent that = (BuildConfigSpecFluent)o;
        if (!Objects.equals(this.completionDeadlineSeconds, that.completionDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.failedBuildsHistoryLimit, that.failedBuildsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.mountTrustedCA, that.mountTrustedCA)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.output, that.output)) {
            return false;
        }
        if (!Objects.equals(this.postCommit, that.postCommit)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.revision, that.revision)) {
            return false;
        }
        if (!Objects.equals(this.runPolicy, that.runPolicy)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.successfulBuildsHistoryLimit, that.successfulBuildsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.triggers, that.triggers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.completionDeadlineSeconds, this.failedBuildsHistoryLimit, this.mountTrustedCA, this.nodeSelector, this.output, this.postCommit, this.resources, this.revision, this.runPolicy, this.serviceAccount, this.source, this.strategy, this.successfulBuildsHistoryLimit, this.triggers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.completionDeadlineSeconds != null) {
            sb.append("completionDeadlineSeconds:");
            sb.append(this.completionDeadlineSeconds + ",");
        }
        if (this.failedBuildsHistoryLimit != null) {
            sb.append("failedBuildsHistoryLimit:");
            sb.append(this.failedBuildsHistoryLimit + ",");
        }
        if (this.mountTrustedCA != null) {
            sb.append("mountTrustedCA:");
            sb.append(this.mountTrustedCA + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.output != null) {
            sb.append("output:");
            sb.append(this.output + ",");
        }
        if (this.postCommit != null) {
            sb.append("postCommit:");
            sb.append(this.postCommit + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.revision != null) {
            sb.append("revision:");
            sb.append(this.revision + ",");
        }
        if (this.runPolicy != null) {
            sb.append("runPolicy:");
            sb.append(this.runPolicy + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.successfulBuildsHistoryLimit != null) {
            sb.append("successfulBuildsHistoryLimit:");
            sb.append(this.successfulBuildsHistoryLimit + ",");
        }
        if (this.triggers != null && !this.triggers.isEmpty()) {
            sb.append("triggers:");
            sb.append(this.triggers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withMountTrustedCA() {
        return this.withMountTrustedCA(true);
    }

    public class TriggersNested<N>
    extends BuildTriggerPolicyFluent<TriggersNested<N>>
    implements Nested<N> {
        BuildTriggerPolicyBuilder builder;
        int index;

        TriggersNested(int index, BuildTriggerPolicy item) {
            this.index = index;
            this.builder = new BuildTriggerPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.setToTriggers(this.index, this.builder.build());
        }

        public N endTrigger() {
            return this.and();
        }
    }

    public class StrategyNested<N>
    extends BuildStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        BuildStrategyBuilder builder;

        StrategyNested(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withStrategy(this.builder.build());
        }

        public N endStrategy() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends BuildSourceFluent<SourceNested<N>>
    implements Nested<N> {
        BuildSourceBuilder builder;

        SourceNested(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        SourceRevisionBuilder builder;

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withRevision(this.builder.build());
        }

        public N endRevision() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNested<N>
    extends BuildPostCommitSpecFluent<PostCommitNested<N>>
    implements Nested<N> {
        BuildPostCommitSpecBuilder builder;

        PostCommitNested(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withPostCommit(this.builder.build());
        }

        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNested<N>
    extends BuildOutputFluent<OutputNested<N>>
    implements Nested<N> {
        BuildOutputBuilder builder;

        OutputNested(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withOutput(this.builder.build());
        }

        public N endOutput() {
            return this.and();
        }
    }
}

