/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_9.impl;

import io.fabric8.kubernetes.api.model.v6_9.APIGroup;
import io.fabric8.kubernetes.api.model.v6_9.APIGroupBuilder;
import io.fabric8.kubernetes.api.model.v6_9.APIGroupList;
import io.fabric8.kubernetes.api.model.v6_9.APIResource;
import io.fabric8.kubernetes.api.model.v6_9.APIResourceList;
import io.fabric8.kubernetes.api.model.v6_9.APIService;
import io.fabric8.kubernetes.api.model.v6_9.APIServiceList;
import io.fabric8.kubernetes.api.model.v6_9.Binding;
import io.fabric8.kubernetes.api.model.v6_9.ComponentStatus;
import io.fabric8.kubernetes.api.model.v6_9.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMap;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMapList;
import io.fabric8.kubernetes.api.model.v6_9.Endpoints;
import io.fabric8.kubernetes.api.model.v6_9.EndpointsList;
import io.fabric8.kubernetes.api.model.v6_9.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v6_9.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_9.GroupVersionForDiscovery;
import io.fabric8.kubernetes.api.model.v6_9.GroupVersionForDiscoveryBuilder;
import io.fabric8.kubernetes.api.model.v6_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_9.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v6_9.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_9.LimitRange;
import io.fabric8.kubernetes.api.model.v6_9.LimitRangeList;
import io.fabric8.kubernetes.api.model.v6_9.Namespace;
import io.fabric8.kubernetes.api.model.v6_9.NamespaceList;
import io.fabric8.kubernetes.api.model.v6_9.Node;
import io.fabric8.kubernetes.api.model.v6_9.NodeList;
import io.fabric8.kubernetes.api.model.v6_9.PersistentVolume;
import io.fabric8.kubernetes.api.model.v6_9.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v6_9.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v6_9.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v6_9.Pod;
import io.fabric8.kubernetes.api.model.v6_9.PodList;
import io.fabric8.kubernetes.api.model.v6_9.ReplicationController;
import io.fabric8.kubernetes.api.model.v6_9.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v6_9.ResourceQuota;
import io.fabric8.kubernetes.api.model.v6_9.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v6_9.Secret;
import io.fabric8.kubernetes.api.model.v6_9.SecretList;
import io.fabric8.kubernetes.api.model.v6_9.Service;
import io.fabric8.kubernetes.api.model.v6_9.ServiceAccount;
import io.fabric8.kubernetes.api.model.v6_9.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v6_9.ServiceList;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v6_9.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v6_9.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v6_9.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v6_9.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v6_9.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v6_9.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v6_9.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v6_9.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v6_9.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v6_9.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v6_9.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.ApiVisitor;
import io.fabric8.kubernetes.clnt.v6_9.Client;
import io.fabric8.kubernetes.clnt.v6_9.Config;
import io.fabric8.kubernetes.clnt.v6_9.KubernetesClient;
import io.fabric8.kubernetes.clnt.v6_9.KubernetesClientBuilder;
import io.fabric8.kubernetes.clnt.v6_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_9.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v6_9.RequestConfig;
import io.fabric8.kubernetes.clnt.v6_9.V1AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1Alpha1AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1Alpha1NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1Alpha2DynamicResourceAllocationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1ApiextensionAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1AuthenticationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1beta1AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1beta1ApiextensionAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1beta1AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V1beta1NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V2AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V2beta1AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.V2beta2AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.VersionInfo;
import io.fabric8.kubernetes.clnt.v6_9.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.AuthenticationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.DynamicResourceAllocationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.NamespaceableResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.Resource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1Alpha1AuthenticationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1Alpha1CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1Beta1AuthenticationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta1SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta2FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.V1beta3FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v6_9.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.batch.v1.JobOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.certificates.v1beta1.CertificateSigningRequestOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.core.v1.ServiceAccountOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.core.v1.ServiceOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v6_9.extended.run.RunConfig;
import io.fabric8.kubernetes.clnt.v6_9.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v6_9.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v6_9.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.Adapters;
import io.fabric8.kubernetes.clnt.v6_9.impl.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.AuthenticationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.BaseClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.DynamicResourceAllocationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.EventingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.Handlers;
import io.fabric8.kubernetes.clnt.v6_9.impl.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.NamespaceableResourceAdapter;
import io.fabric8.kubernetes.clnt.v6_9.impl.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.ResourceHandler;
import io.fabric8.kubernetes.clnt.v6_9.impl.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Alpha1AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Alpha1AuthenticationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Alpha1CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Alpha1NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Alpha2DynamicResourceAllocationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1AuthenticationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1Beta1AuthenticationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1EventingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1EventingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta1StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta2FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V1beta3FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V2AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V2beta1AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.impl.V2beta2AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v6_9.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v6_9.informers.impl.SharedInformerFactoryImpl;
import io.fabric8.kubernetes.clnt.v6_9.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v6_9.utils.KubernetesSerialization;
import io.fabric8.kubernetes.clnt.v6_9.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientImpl
extends BaseClient
implements NamespacedKubernetesClient {
    public static final Logger logger = LoggerFactory.getLogger(KubernetesClientImpl.class);
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";

    public KubernetesClientImpl(HttpClient httpClient, Config config) {
        this(httpClient, config, () -> Runnable::run, new KubernetesSerialization());
    }

    public KubernetesClientImpl(HttpClient httpClient, Config config, KubernetesClientBuilder.ExecutorSupplier executorSupplier, KubernetesSerialization kubernetesSerialization) {
        super(httpClient, config, executorSupplier, kubernetesSerialization);
        this.registerDefaultAdapters();
        this.registerDefaultHandlers();
    }

    protected KubernetesClientImpl(BaseClient client) {
        super(client);
    }

    protected void registerDefaultAdapters() {
        Adapters adapters = this.getAdapters();
        adapters.registerClient(AppsAPIGroupDSL.class, new AppsAPIGroupClient());
        adapters.registerClient(AdmissionRegistrationAPIGroupDSL.class, new AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1AdmissionRegistrationAPIGroupDSL.class, new V1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1beta1AdmissionRegistrationAPIGroupDSL.class, new V1beta1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(V1Alpha1AdmissionRegistrationAPIGroupDSL.class, new V1Alpha1AdmissionRegistrationAPIGroupClient());
        adapters.registerClient(AutoscalingAPIGroupDSL.class, new AutoscalingAPIGroupClient());
        adapters.registerClient(ApiextensionsAPIGroupDSL.class, new ApiextensionsAPIGroupClient());
        adapters.registerClient(AuthorizationAPIGroupDSL.class, new AuthorizationAPIGroupClient());
        adapters.registerClient(AuthenticationAPIGroupDSL.class, new AuthenticationAPIGroupClient());
        adapters.registerClient(V1AutoscalingAPIGroupDSL.class, new V1AutoscalingAPIGroupClient());
        adapters.registerClient(V2AutoscalingAPIGroupDSL.class, new V2AutoscalingAPIGroupClient());
        adapters.registerClient(V2beta1AutoscalingAPIGroupDSL.class, new V2beta1AutoscalingAPIGroupClient());
        adapters.registerClient(V2beta2AutoscalingAPIGroupDSL.class, new V2beta2AutoscalingAPIGroupClient());
        adapters.registerClient(BatchAPIGroupDSL.class, new BatchAPIGroupClient());
        adapters.registerClient(V1BatchAPIGroupDSL.class, new V1BatchAPIGroupClient());
        adapters.registerClient(V1beta1BatchAPIGroupDSL.class, new V1beta1BatchAPIGroupClient());
        adapters.registerClient(ExtensionsAPIGroupDSL.class, new ExtensionsAPIGroupClient());
        adapters.registerClient(EventingAPIGroupDSL.class, new EventingAPIGroupClient());
        adapters.registerClient(V1EventingAPIGroupDSL.class, new V1EventingAPIGroupClient());
        adapters.registerClient(V1beta1EventingAPIGroupDSL.class, new V1beta1EventingAPIGroupClient());
        adapters.registerClient(FlowControlAPIGroupDSL.class, new FlowControlAPIGroupClient());
        adapters.registerClient(V1beta1FlowControlAPIGroupDSL.class, new V1beta1FlowControlAPIGroupClient());
        adapters.registerClient(V1beta2FlowControlAPIGroupDSL.class, new V1beta2FlowControlAPIGroupClient());
        adapters.registerClient(V1beta3FlowControlAPIGroupDSL.class, new V1beta3FlowControlAPIGroupClient());
        adapters.registerClient(MetricAPIGroupDSL.class, new MetricAPIGroupClient());
        adapters.registerClient(NetworkAPIGroupDSL.class, new NetworkAPIGroupClient());
        adapters.registerClient(PolicyAPIGroupDSL.class, new PolicyAPIGroupClient());
        adapters.registerClient(V1PolicyAPIGroupDSL.class, new V1PolicyAPIGroupClient());
        adapters.registerClient(V1beta1PolicyAPIGroupDSL.class, new V1beta1PolicyAPIGroupClient());
        adapters.registerClient(RbacAPIGroupDSL.class, new RbacAPIGroupClient());
        adapters.registerClient(SchedulingAPIGroupDSL.class, new SchedulingAPIGroupClient());
        adapters.registerClient(V1SchedulingAPIGroupDSL.class, new V1SchedulingAPIGroupClient());
        adapters.registerClient(V1beta1SchedulingAPIGroupDSL.class, new V1beta1SchedulingAPIGroupClient());
        adapters.registerClient(StorageAPIGroupDSL.class, new StorageAPIGroupClient());
        adapters.registerClient(V1StorageAPIGroupClient.class, new V1StorageAPIGroupClient());
        adapters.registerClient(V1beta1StorageAPIGroupClient.class, new V1beta1StorageAPIGroupClient());
        adapters.registerClient(V1APIGroupDSL.class, new V1APIGroupClient());
        adapters.registerClient(V1ApiextensionAPIGroupDSL.class, new V1ApiextensionsAPIGroupClient());
        adapters.registerClient(V1beta1ApiextensionAPIGroupDSL.class, new V1beta1ApiextensionsAPIGroupClient());
        adapters.registerClient(V1AuthorizationAPIGroupDSL.class, new V1AuthorizationAPIGroupClient());
        adapters.registerClient(V1beta1AuthorizationAPIGroupDSL.class, new V1beta1AuthorizationAPIGroupClient());
        adapters.registerClient(V1AuthenticationAPIGroupDSL.class, new V1AuthenticationAPIGroupClient());
        adapters.registerClient(V1Alpha1AuthenticationAPIGroupDSL.class, new V1Alpha1AuthenticationAPIGroupClient());
        adapters.registerClient(V1Beta1AuthenticationAPIGroupDSL.class, new V1Beta1AuthenticationAPIGroupClient());
        adapters.registerClient(V1NetworkAPIGroupDSL.class, new V1NetworkAPIGroupClient());
        adapters.registerClient(V1beta1NetworkAPIGroupDSL.class, new V1beta1NetworkAPIGroupClient());
        adapters.registerClient(V1Alpha1NetworkAPIGroupDSL.class, new V1Alpha1NetworkAPIGroupClient());
        adapters.registerClient(DiscoveryAPIGroupDSL.class, new DiscoveryAPIGroupClient());
        adapters.registerClient(V1beta1DiscoveryAPIGroupDSL.class, new V1beta1DiscoveryAPIGroupClient());
        adapters.registerClient(V1DiscoveryAPIGroupDSL.class, new V1DiscoveryAPIGroupClient());
        adapters.registerClient(DynamicResourceAllocationAPIGroupDSL.class, new DynamicResourceAllocationAPIGroupClient());
        adapters.registerClient(V1Alpha2DynamicResourceAllocationAPIGroupDSL.class, new V1Alpha2DynamicResourceAllocationAPIGroupClient());
        adapters.registerClient(CertificatesAPIGroupDSL.class, new CertificatesAPIGroupClient());
        adapters.registerClient(V1CertificatesAPIGroupDSL.class, new V1CertificatesAPIGroupClient());
        adapters.registerClient(V1beta1CertificatesAPIGroupDSL.class, new V1beta1CertificatesAPIGroupClient());
        adapters.registerClient(V1Alpha1CertificatesAPIGroupDSL.class, new V1Alpha1CertificatesAPIGroupClient());
    }

    protected void registerDefaultHandlers() {
        Handlers handlers = this.getHandlers();
        handlers.register(Pod.class, PodOperationsImpl::new);
        handlers.register(ServiceAccount.class, ServiceAccountOperationsImpl::new);
        handlers.register(Job.class, JobOperationsImpl::new);
        handlers.register(Service.class, ServiceOperationsImpl::new);
        handlers.register(io.fabric8.kubernetes.api.model.v6_9.apps.Deployment.class, io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1.DeploymentOperationsImpl::new);
        handlers.register(Deployment.class, DeploymentOperationsImpl::new);
        handlers.register(ReplicaSet.class, ReplicaSetOperationsImpl::new);
        handlers.register(io.fabric8.kubernetes.api.model.v6_9.extensions.ReplicaSet.class, io.fabric8.kubernetes.clnt.v6_9.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl::new);
        handlers.register(ReplicationController.class, ReplicationControllerOperationsImpl::new);
        handlers.register(StatefulSet.class, StatefulSetOperationsImpl::new);
        handlers.register(io.fabric8.kubernetes.api.model.v6_9.certificates.v1.CertificateSigningRequest.class, io.fabric8.kubernetes.clnt.v6_9.dsl.internal.certificates.v1.CertificateSigningRequestOperationsImpl::new);
        handlers.register(CertificateSigningRequest.class, CertificateSigningRequestOperationsImpl::new);
    }

    public NamespacedKubernetesClient inNamespace(String name) {
        return this.newClient(this.createInNamespaceContext(name, false), NamespacedKubernetesClient.class);
    }

    protected OperationContext createInNamespaceContext(String name, boolean any) {
        if (!any && name == null) {
            throw new KubernetesClientException("namespace cannot be null");
        }
        return HasMetadataOperationsImpl.defaultContext(this).withNamespace(name);
    }

    public LeaderElectorBuilder leaderElector() {
        return new LeaderElectorBuilder((KubernetesClient)this, this.getExecutor());
    }

    public FunctionCallable<? extends NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable((Client)this, requestConfig);
    }

    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.resources(ComponentStatus.class, ComponentStatusList.class);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.resourceListFor(this.kubernetesSerialization.unmarshal(is));
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return this.resourceListFor(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl resourceListFor(Object item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<? extends HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.resourceListFor(this.kubernetesSerialization.unmarshal(s));
    }

    public <T extends HasMetadata> NamespaceableResource<T> resource(T item) {
        ResourceHandler resourceHandler = this.getHandlers().get(item, this);
        HasMetadataOperation op = resourceHandler.operation(this, null);
        return new NamespaceableResourceAdapter<T>(item, op);
    }

    private NamespaceableResource<HasMetadata> resource(Object resource) {
        if (resource instanceof HasMetadata) {
            return this.resource((HasMetadata)resource);
        }
        throw new KubernetesClientException("Unable to create a valid resource from the provided object (" + resource.getClass().getName() + ")");
    }

    public NamespaceableResource<HasMetadata> resource(String s) {
        return this.resource(this.kubernetesSerialization.unmarshal(s));
    }

    public NamespaceableResource<HasMetadata> resource(InputStream is) {
        return this.resource(this.kubernetesSerialization.unmarshal(is));
    }

    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return this.resources(Binding.class);
    }

    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.resources(Endpoints.class, EndpointsList.class);
    }

    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.resources(Namespace.class, NamespaceList.class);
    }

    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.resources(Node.class, NodeList.class);
    }

    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.resources(PersistentVolume.class, PersistentVolumeList.class);
    }

    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.resources(PersistentVolumeClaim.class, PersistentVolumeClaimList.class);
    }

    public MixedOperation<Pod, PodList, PodResource> pods() {
        return new PodOperationsImpl(this);
    }

    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this);
    }

    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.resources(ResourceQuota.class, ResourceQuotaList.class);
    }

    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.resources(Secret.class, SecretList.class);
    }

    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this);
    }

    public MixedOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this);
    }

    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return this.resources(APIService.class, APIServiceList.class);
    }

    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.resources(ConfigMap.class, ConfigMapList.class);
    }

    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.resources(LimitRange.class, LimitRangeList.class);
    }

    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return this.resources(CertificateSigningRequest.class, CertificateSigningRequestList.class);
    }

    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    public AuthenticationAPIGroupDSL authentication() {
        return this.adapt(AuthenticationAPIGroupClient.class);
    }

    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return this.getHandlers().getNonListingOperation(TokenReview.class, this);
    }

    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(String apiVersion, String kind) {
        ResourceDefinitionContext context = this.getHandlers().getResourceDefinitionContext(apiVersion, kind, this);
        if (context == null) {
            throw new KubernetesClientException("Could not find the metadata for the given apiVersion and kind, please pass a ResourceDefinitionContext instead");
        }
        return this.genericKubernetesResources(context);
    }

    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(ResourceDefinitionContext context) {
        return this.newHasMetadataOperation(context, GenericKubernetesResource.class, GenericKubernetesResourceList.class);
    }

    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    public DynamicResourceAllocationAPIGroupDSL dynamicResourceAllocation() {
        return this.adapt(DynamicResourceAllocationAPIGroupClient.class);
    }

    public EventingAPIGroupDSL events() {
        return this.adapt(EventingAPIGroupClient.class);
    }

    public NamespacedKubernetesClient inAnyNamespace() {
        return this.newClient(this.createInNamespaceContext(null, true), NamespacedKubernetesClient.class);
    }

    @Override
    protected KubernetesClientImpl copy() {
        return new KubernetesClientImpl(this);
    }

    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    public FlowControlAPIGroupDSL flowControl() {
        return this.adapt(FlowControlAPIGroupClient.class);
    }

    public VersionInfo getVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    public VersionInfo getKubernetesVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    public SharedInformerFactory informers() {
        return new SharedInformerFactoryImpl((KubernetesClient)this);
    }

    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return this.resources(Lease.class, LeaseList.class);
    }

    public RunOperations run() {
        return new RunOperations((KubernetesClient)this, (RunConfig)new RunConfigBuilder().build());
    }

    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return this.resources(RuntimeClass.class, RuntimeClassList.class);
    }

    public Client newClient(RequestConfig requestConfig) {
        return this.newClient(HasMetadataOperationsImpl.defaultContext(this).withRequestConfig(requestConfig), Client.class);
    }

    public void visitResources(ApiVisitor visitor) {
        if (this.visitGroups(visitor, Arrays.asList(((APIGroupBuilder)((APIGroupBuilder)new APIGroupBuilder().withName("")).withVersions(((GroupVersionForDiscoveryBuilder)new GroupVersionForDiscoveryBuilder().withGroupVersion("v1")).build())).build()))) {
            return;
        }
        APIGroupList apiGroups = this.getApiGroups();
        if (apiGroups != null) {
            this.visitGroups(visitor, apiGroups.getGroups());
        }
    }

    private boolean visitGroups(ApiVisitor visitor, List<APIGroup> groups) {
        for (APIGroup group : groups) {
            switch (visitor.visitApiGroup(group.getName())) {
                case TERMINATE: {
                    return true;
                }
                case SKIP: {
                    break;
                }
                case CONTINUE: {
                    for (GroupVersionForDiscovery groupForDiscovery : group.getVersions()) {
                        String groupVersion = groupForDiscovery.getGroupVersion();
                        String groupName = (String)Utils.getNonNullOrElse((Object)ApiVersionUtil.trimGroupOrNull((String)groupVersion), (Object)"");
                        String version = ApiVersionUtil.trimVersion((String)groupVersion);
                        ApiVisitor.ApiVisitResult versionResult = visitor.visitApiGroupVersion(groupName, version);
                        switch (versionResult) {
                            case TERMINATE: {
                                return true;
                            }
                            case SKIP: {
                                break;
                            }
                            case CONTINUE: {
                                APIResourceList apiResources = this.getApiResources(groupVersion);
                                if (apiResources == null) {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug("{} is discoverable, but is not yet populating an APIResource list", (Object)groupVersion);
                                    break;
                                }
                                for (APIResource resource : apiResources.getResources()) {
                                    ApiVisitor.ApiVisitResult resourceResult;
                                    if (resource.getName().contains("/") || (resourceResult = visitor.visitResource(groupName, version, resource, this.genericKubernetesResources(ResourceDefinitionContext.fromApiResource((String)groupVersion, (APIResource)resource)))) != ApiVisitor.ApiVisitResult.TERMINATE) continue;
                                    return true;
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }
}

