/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.rbac;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_9.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.v6_9.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.v6_9.rbac.RoleRefBuilder;
import io.fabric8.kubernetes.api.model.v6_9.rbac.RoleRefFluent;
import io.fabric8.kubernetes.api.model.v6_9.rbac.Subject;
import io.fabric8.kubernetes.api.model.v6_9.rbac.SubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_9.rbac.SubjectFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterRoleBindingFluent<A extends ClusterRoleBindingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private RoleRefBuilder roleRef;
    private ArrayList<SubjectBuilder> subjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ClusterRoleBindingFluent() {
    }

    public ClusterRoleBindingFluent(ClusterRoleBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterRoleBinding instance) {
        ClusterRoleBinding clusterRoleBinding = instance = instance != null ? instance : new ClusterRoleBinding();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    public A withRoleRef(RoleRef roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        } else {
            this.roleRef = null;
            this._visitables.get("roleRef").remove(this.roleRef);
        }
        return (A)this;
    }

    public boolean hasRoleRef() {
        return this.roleRef != null;
    }

    public A withNewRoleRef(String apiGroup, String kind, String name) {
        return this.withRoleRef(new RoleRef(apiGroup, kind, name));
    }

    public RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNested(null);
    }

    public RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
        return new RoleRefNested(item);
    }

    public RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(null));
    }

    public RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(new RoleRefBuilder().build()));
    }

    public RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(item));
    }

    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(Subject ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Subject> buildSubjects() {
        return this.subjects != null ? ClusterRoleBindingFluent.build(this.subjects) : null;
    }

    public Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingFluent that = (ClusterRoleBindingFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.roleRef, that.roleRef)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.roleRef != null) {
            sb.append("roleRef:");
            sb.append(this.roleRef + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectsNested<N>
    extends SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        SubjectBuilder builder;
        int index;

        SubjectsNested(int index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNested<N>
    extends RoleRefFluent<RoleRefNested<N>>
    implements Nested<N> {
        RoleRefBuilder builder;

        RoleRefNested(RoleRef item) {
            this.builder = new RoleRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withRoleRef(this.builder.build());
        }

        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

