/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.v6_9.networking.v1.IngressServiceBackendFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressBackendFluent<A extends IngressBackendFluent<A>>
extends BaseFluent<A> {
    private TypedLocalObjectReference resource;
    private IngressServiceBackendBuilder service;
    private Map<String, Object> additionalProperties;

    public IngressBackendFluent() {
    }

    public IngressBackendFluent(IngressBackend instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressBackend instance) {
        IngressBackend ingressBackend = instance = instance != null ? instance : new IngressBackend();
        if (instance != null) {
            this.withResource(instance.getResource());
            this.withService(instance.getService());
            this.withResource(instance.getResource());
            this.withService(instance.getService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public IngressServiceBackend buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(IngressServiceBackend service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new IngressServiceBackendBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new IngressServiceBackendBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendFluent that = (IngressBackendFluent)o;
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resource, this.service, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceNested<N>
    extends IngressServiceBackendFluent<ServiceNested<N>>
    implements Nested<N> {
        IngressServiceBackendBuilder builder;

        ServiceNested(IngressServiceBackend item) {
            this.builder = new IngressServiceBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

