/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.extensions;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_9.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v6_9.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v6_9.extensions.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.v6_9.extensions.DeploymentStrategyBuilder;
import io.fabric8.kubernetes.api.model.v6_9.extensions.DeploymentStrategyFluent;
import io.fabric8.kubernetes.api.model.v6_9.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.v6_9.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.v6_9.extensions.RollbackConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeploymentSpecFluent<A extends DeploymentSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private RollbackConfigBuilder rollbackTo;
    private LabelSelectorBuilder selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;
    private Map<String, Object> additionalProperties;

    public DeploymentSpecFluent() {
    }

    public DeploymentSpecFluent(DeploymentSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentSpec instance) {
        DeploymentSpec deploymentSpec = instance = instance != null ? instance : new DeploymentSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withPaused(instance.getPaused());
            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withRollbackTo(instance.getRollbackTo());
            this.withSelector(instance.getSelector());
            this.withStrategy(instance.getStrategy());
            this.withTemplate(instance.getTemplate());
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withPaused(instance.getPaused());
            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withRollbackTo(instance.getRollbackTo());
            this.withSelector(instance.getSelector());
            this.withStrategy(instance.getStrategy());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    public boolean hasPaused() {
        return this.paused != null;
    }

    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return (A)this;
    }

    public boolean hasProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    public A withRollbackTo(RollbackConfig rollbackTo) {
        this._visitables.get("rollbackTo").remove(this.rollbackTo);
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.get("rollbackTo").add(this.rollbackTo);
        } else {
            this.rollbackTo = null;
            this._visitables.get("rollbackTo").remove(this.rollbackTo);
        }
        return (A)this;
    }

    public boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    public RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNested(null);
    }

    public RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNested(item);
    }

    public RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(null));
    }

    public RollbackToNested<A> editOrNewRollbackTo() {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(new RollbackConfigBuilder().build()));
    }

    public RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(item));
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.get("strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get("strategy").remove(this.strategy);
        }
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public StrategyNested<A> withNewStrategy() {
        return new StrategyNested(null);
    }

    public StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(null));
    }

    public StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(new DeploymentStrategyBuilder().build()));
    }

    public StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(item));
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecFluent that = (DeploymentSpecFluent)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.progressDeadlineSeconds, that.progressDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.rollbackTo, that.rollbackTo)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.rollbackTo, this.selector, this.strategy, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.progressDeadlineSeconds != null) {
            sb.append("progressDeadlineSeconds:");
            sb.append(this.progressDeadlineSeconds + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.rollbackTo != null) {
            sb.append("rollbackTo:");
            sb.append(this.rollbackTo + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPaused() {
        return this.withPaused(true);
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class StrategyNested<N>
    extends DeploymentStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        DeploymentStrategyBuilder builder;

        StrategyNested(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluent.this.withStrategy(this.builder.build());
        }

        public N endStrategy() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class RollbackToNested<N>
    extends RollbackConfigFluent<RollbackToNested<N>>
    implements Nested<N> {
        RollbackConfigBuilder builder;

        RollbackToNested(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluent.this.withRollbackTo(this.builder.build());
        }

        public N endRollbackTo() {
            return this.and();
        }
    }
}

