/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.NonResourceRule;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.NonResourceRuleBuilder;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.NonResourceRuleFluent;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.ResourceRule;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.ResourceRuleBuilder;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.ResourceRuleFluent;
import io.fabric8.kubernetes.api.model.v6_9.authorization.v1beta1.SubjectRulesReviewStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubjectRulesReviewStatusFluent<A extends SubjectRulesReviewStatusFluent<A>>
extends BaseFluent<A> {
    private String evaluationError;
    private Boolean incomplete;
    private ArrayList<NonResourceRuleBuilder> nonResourceRules = new ArrayList();
    private ArrayList<ResourceRuleBuilder> resourceRules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SubjectRulesReviewStatusFluent() {
    }

    public SubjectRulesReviewStatusFluent(SubjectRulesReviewStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SubjectRulesReviewStatus instance) {
        SubjectRulesReviewStatus subjectRulesReviewStatus = instance = instance != null ? instance : new SubjectRulesReviewStatus();
        if (instance != null) {
            this.withEvaluationError(instance.getEvaluationError());
            this.withIncomplete(instance.getIncomplete());
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withEvaluationError(instance.getEvaluationError());
            this.withIncomplete(instance.getIncomplete());
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getEvaluationError() {
        return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return (A)this;
    }

    public boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public A withIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return (A)this;
    }

    public boolean hasIncomplete() {
        return this.incomplete != null;
    }

    public A addToNonResourceRules(int index, NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(index, builder);
            this.nonResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToNonResourceRules(int index, NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").set(index, builder);
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToNonResourceRules(NonResourceRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToNonResourceRules(Collection<NonResourceRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromNonResourceRules(NonResourceRule ... items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<NonResourceRule> items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<NonResourceRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<NonResourceRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            NonResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NonResourceRule> buildNonResourceRules() {
        return this.nonResourceRules != null ? SubjectRulesReviewStatusFluent.build(this.nonResourceRules) : null;
    }

    public NonResourceRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public NonResourceRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public NonResourceRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    public NonResourceRule buildMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceRules(List<NonResourceRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").clear();
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList();
            for (NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    public A withNonResourceRules(NonResourceRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
            this._visitables.remove("nonResourceRules");
        }
        if (nonResourceRules != null) {
            for (NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    public NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNested(-1, null);
    }

    public NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourceRule item) {
        return new NonResourceRulesNested(-1, item);
    }

    public NonResourceRulesNested<A> setNewNonResourceRuleLike(int index, NonResourceRule item) {
        return new NonResourceRulesNested(index, item);
    }

    public NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (this.nonResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    public NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public A addToResourceRules(int index, ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(index, builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(ResourceRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<ResourceRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(ResourceRule ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<ResourceRule> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<ResourceRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<ResourceRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            ResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourceRule> buildResourceRules() {
        return this.resourceRules != null ? SubjectRulesReviewStatusFluent.build(this.resourceRules) : null;
    }

    public ResourceRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public ResourceRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public ResourceRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public ResourceRule buildMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<ResourceRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(ResourceRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(ResourceRule item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, ResourceRule item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectRulesReviewStatusFluent that = (SubjectRulesReviewStatusFluent)o;
        if (!Objects.equals(this.evaluationError, that.evaluationError)) {
            return false;
        }
        if (!Objects.equals(this.incomplete, that.incomplete)) {
            return false;
        }
        if (!Objects.equals(this.nonResourceRules, that.nonResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.resourceRules, that.resourceRules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.evaluationError != null) {
            sb.append("evaluationError:");
            sb.append(this.evaluationError + ",");
        }
        if (this.incomplete != null) {
            sb.append("incomplete:");
            sb.append(this.incomplete + ",");
        }
        if (this.nonResourceRules != null && !this.nonResourceRules.isEmpty()) {
            sb.append("nonResourceRules:");
            sb.append(this.nonResourceRules + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncomplete() {
        return this.withIncomplete(true);
    }

    public class ResourceRulesNested<N>
    extends ResourceRuleFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        ResourceRuleBuilder builder;
        int index;

        ResourceRulesNested(int index, ResourceRule item) {
            this.index = index;
            this.builder = new ResourceRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectRulesReviewStatusFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }

    public class NonResourceRulesNested<N>
    extends NonResourceRuleFluent<NonResourceRulesNested<N>>
    implements Nested<N> {
        NonResourceRuleBuilder builder;
        int index;

        NonResourceRulesNested(int index, NonResourceRule item) {
            this.index = index;
            this.builder = new NonResourceRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubjectRulesReviewStatusFluent.this.setToNonResourceRules(this.index, this.builder.build());
        }

        public N endNonResourceRule() {
            return this.and();
        }
    }
}

