/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.Quantity;
import io.fabric8.kubernetes.api.model.v6_9.ResourceClaim;
import io.fabric8.kubernetes.api.model.v6_9.ResourceClaimBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ResourceClaimFluent;
import io.fabric8.kubernetes.api.model.v6_9.ResourceRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceRequirementsFluent<A extends ResourceRequirementsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ResourceClaimBuilder> claims = new ArrayList();
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;
    private Map<String, Object> additionalProperties;

    public ResourceRequirementsFluent() {
    }

    public ResourceRequirementsFluent(ResourceRequirements instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceRequirements instance) {
        ResourceRequirements resourceRequirements = instance = instance != null ? instance : new ResourceRequirements();
        if (instance != null) {
            this.withClaims(instance.getClaims());
            this.withLimits(instance.getLimits());
            this.withRequests(instance.getRequests());
            this.withClaims(instance.getClaims());
            this.withLimits(instance.getLimits());
            this.withRequests(instance.getRequests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClaims(int index, ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get("claims").add(index, builder);
            this.claims.add(index, builder);
        }
        return (A)this;
    }

    public A setToClaims(int index, ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get("claims").set(index, builder);
            this.claims.set(index, builder);
        }
        return (A)this;
    }

    public A addToClaims(ResourceClaim ... items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    public A addAllToClaims(Collection<ResourceClaim> items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    public A removeFromClaims(ResourceClaim ... items) {
        if (this.claims == null) {
            return (A)this;
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            this.claims.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromClaims(Collection<ResourceClaim> items) {
        if (this.claims == null) {
            return (A)this;
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            this.claims.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromClaims(Predicate<ResourceClaimBuilder> predicate) {
        if (this.claims == null) {
            return (A)this;
        }
        Iterator<ResourceClaimBuilder> each = this.claims.iterator();
        Object visitables = this._visitables.get("claims");
        while (each.hasNext()) {
            ResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourceClaim> buildClaims() {
        return this.claims != null ? ResourceRequirementsFluent.build(this.claims) : null;
    }

    public ResourceClaim buildClaim(int index) {
        return this.claims.get(index).build();
    }

    public ResourceClaim buildFirstClaim() {
        return this.claims.get(0).build();
    }

    public ResourceClaim buildLastClaim() {
        return this.claims.get(this.claims.size() - 1).build();
    }

    public ResourceClaim buildMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        for (ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        for (ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClaims(List<ResourceClaim> claims) {
        if (this.claims != null) {
            this._visitables.get("claims").clear();
        }
        if (claims != null) {
            this.claims = new ArrayList();
            for (ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        } else {
            this.claims = null;
        }
        return (A)this;
    }

    public A withClaims(ResourceClaim ... claims) {
        if (this.claims != null) {
            this.claims.clear();
            this._visitables.remove("claims");
        }
        if (claims != null) {
            for (ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        }
        return (A)this;
    }

    public boolean hasClaims() {
        return this.claims != null && !this.claims.isEmpty();
    }

    public A addNewClaim(String name) {
        return this.addToClaims(new ResourceClaim(name));
    }

    public ClaimsNested<A> addNewClaim() {
        return new ClaimsNested(-1, null);
    }

    public ClaimsNested<A> addNewClaimLike(ResourceClaim item) {
        return new ClaimsNested(-1, item);
    }

    public ClaimsNested<A> setNewClaimLike(int index, ResourceClaim item) {
        return new ClaimsNested(index, item);
    }

    public ClaimsNested<A> editClaim(int index) {
        if (this.claims.size() <= index) {
            throw new RuntimeException("Can't edit claims. Index exceeds size.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public ClaimsNested<A> editFirstClaim() {
        if (this.claims.size() == 0) {
            throw new RuntimeException("Can't edit first claims. The list is empty.");
        }
        return this.setNewClaimLike(0, this.buildClaim(0));
    }

    public ClaimsNested<A> editLastClaim() {
        int index = this.claims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last claims. The list is empty.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public ClaimsNested<A> editMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!predicate.test(this.claims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching claims. No match found.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public <K, V> A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    public boolean hasLimits() {
        return this.limits != null;
    }

    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public <K, V> A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirementsFluent that = (ResourceRequirementsFluent)o;
        if (!Objects.equals(this.claims, that.claims)) {
            return false;
        }
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claims != null && !this.claims.isEmpty()) {
            sb.append("claims:");
            sb.append(this.claims + ",");
        }
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClaimsNested<N>
    extends ResourceClaimFluent<ClaimsNested<N>>
    implements Nested<N> {
        ResourceClaimBuilder builder;
        int index;

        ClaimsNested(int index, ResourceClaim item) {
            this.index = index;
            this.builder = new ResourceClaimBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceRequirementsFluent.this.setToClaims(this.index, this.builder.build());
        }

        public N endClaim() {
            return this.and();
        }
    }
}

