/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.Quantity;
import io.fabric8.kubernetes.api.model.v6_9.QuantityBuilder;
import io.fabric8.kubernetes.api.model.v6_9.QuantityFluent;
import io.fabric8.kubernetes.api.model.v6_9.ResourceFieldSelector;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceFieldSelectorFluent<A extends ResourceFieldSelectorFluent<A>>
extends BaseFluent<A> {
    private String containerName;
    private QuantityBuilder divisor;
    private String resource;
    private Map<String, Object> additionalProperties;

    public ResourceFieldSelectorFluent() {
    }

    public ResourceFieldSelectorFluent(ResourceFieldSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceFieldSelector instance) {
        ResourceFieldSelector resourceFieldSelector = instance = instance != null ? instance : new ResourceFieldSelector();
        if (instance != null) {
            this.withContainerName(instance.getContainerName());
            this.withDivisor(instance.getDivisor());
            this.withResource(instance.getResource());
            this.withContainerName(instance.getContainerName());
            this.withDivisor(instance.getDivisor());
            this.withResource(instance.getResource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getContainerName() {
        return this.containerName;
    }

    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    public boolean hasContainerName() {
        return this.containerName != null;
    }

    public Quantity buildDivisor() {
        return this.divisor != null ? this.divisor.build() : null;
    }

    public A withDivisor(Quantity divisor) {
        this._visitables.get("divisor").remove(this.divisor);
        if (divisor != null) {
            this.divisor = new QuantityBuilder(divisor);
            this._visitables.get("divisor").add(this.divisor);
        } else {
            this.divisor = null;
            this._visitables.get("divisor").remove(this.divisor);
        }
        return (A)this;
    }

    public boolean hasDivisor() {
        return this.divisor != null;
    }

    public A withNewDivisor(String amount, String format) {
        return this.withDivisor(new Quantity(amount, format));
    }

    public A withNewDivisor(String amount) {
        return this.withDivisor(new Quantity(amount));
    }

    public DivisorNested<A> withNewDivisor() {
        return new DivisorNested(null);
    }

    public DivisorNested<A> withNewDivisorLike(Quantity item) {
        return new DivisorNested(item);
    }

    public DivisorNested<A> editDivisor() {
        return this.withNewDivisorLike(Optional.ofNullable(this.buildDivisor()).orElse(null));
    }

    public DivisorNested<A> editOrNewDivisor() {
        return this.withNewDivisorLike(Optional.ofNullable(this.buildDivisor()).orElse(new QuantityBuilder().build()));
    }

    public DivisorNested<A> editOrNewDivisorLike(Quantity item) {
        return this.withNewDivisorLike(Optional.ofNullable(this.buildDivisor()).orElse(item));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceFieldSelectorFluent that = (ResourceFieldSelectorFluent)o;
        if (!Objects.equals(this.containerName, that.containerName)) {
            return false;
        }
        if (!Objects.equals(this.divisor, that.divisor)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerName != null) {
            sb.append("containerName:");
            sb.append(this.containerName + ",");
        }
        if (this.divisor != null) {
            sb.append("divisor:");
            sb.append(this.divisor + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DivisorNested<N>
    extends QuantityFluent<DivisorNested<N>>
    implements Nested<N> {
        QuantityBuilder builder;

        DivisorNested(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceFieldSelectorFluent.this.withDivisor(this.builder.build());
        }

        public N endDivisor() {
            return this.and();
        }
    }
}

