/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ProjectedVolumeSource;
import io.fabric8.kubernetes.api.model.v6_9.VolumeProjection;
import io.fabric8.kubernetes.api.model.v6_9.VolumeProjectionBuilder;
import io.fabric8.kubernetes.api.model.v6_9.VolumeProjectionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectedVolumeSourceFluent<A extends ProjectedVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<VolumeProjectionBuilder> sources = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ProjectedVolumeSourceFluent() {
    }

    public ProjectedVolumeSourceFluent(ProjectedVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProjectedVolumeSource instance) {
        ProjectedVolumeSource projectedVolumeSource = instance = instance != null ? instance : new ProjectedVolumeSource();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withSources(instance.getSources());
            this.withDefaultMode(instance.getDefaultMode());
            this.withSources(instance.getSources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToSources(int index, VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)this;
    }

    public A setToSources(int index, VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    public A addToSources(VolumeProjection ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A addAllToSources(Collection<VolumeProjection> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A removeFromSources(VolumeProjection ... items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSources(Collection<VolumeProjection> items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSources(Predicate<VolumeProjectionBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<VolumeProjectionBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            VolumeProjectionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<VolumeProjection> buildSources() {
        return this.sources != null ? ProjectedVolumeSourceFluent.build(this.sources) : null;
    }

    public VolumeProjection buildSource(int index) {
        return this.sources.get(index).build();
    }

    public VolumeProjection buildFirstSource() {
        return this.sources.get(0).build();
    }

    public VolumeProjection buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public VolumeProjection buildMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        for (VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        for (VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<VolumeProjection> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (VolumeProjection item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    public A withSources(VolumeProjection ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove("sources");
        }
        if (sources != null) {
            for (VolumeProjection item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(VolumeProjection item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, VolumeProjection item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectedVolumeSourceFluent that = (ProjectedVolumeSourceFluent)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourcesNested<N>
    extends VolumeProjectionFluent<SourcesNested<N>>
    implements Nested<N> {
        VolumeProjectionBuilder builder;
        int index;

        SourcesNested(int index, VolumeProjection item) {
            this.index = index;
            this.builder = new VolumeProjectionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProjectedVolumeSourceFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

