/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.AttachedVolume;
import io.fabric8.kubernetes.api.model.v6_9.AttachedVolumeBuilder;
import io.fabric8.kubernetes.api.model.v6_9.AttachedVolumeFluent;
import io.fabric8.kubernetes.api.model.v6_9.ContainerImage;
import io.fabric8.kubernetes.api.model.v6_9.ContainerImageBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeAddress;
import io.fabric8.kubernetes.api.model.v6_9.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeCondition;
import io.fabric8.kubernetes.api.model.v6_9.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeConditionFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigStatus;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigStatusBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigStatusFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.v6_9.NodeDaemonEndpointsBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeDaemonEndpointsFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeStatus;
import io.fabric8.kubernetes.api.model.v6_9.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.v6_9.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.v6_9.Quantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NodeStatusFluent<A extends NodeStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NodeAddressBuilder> addresses = new ArrayList();
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private ArrayList<NodeConditionBuilder> conditions = new ArrayList();
    private NodeConfigStatusBuilder config;
    private NodeDaemonEndpointsBuilder daemonEndpoints;
    private ArrayList<ContainerImageBuilder> images = new ArrayList();
    private NodeSystemInfoBuilder nodeInfo;
    private String phase;
    private ArrayList<AttachedVolumeBuilder> volumesAttached = new ArrayList();
    private List<String> volumesInUse = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NodeStatusFluent() {
    }

    public NodeStatusFluent(NodeStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeStatus instance) {
        NodeStatus nodeStatus = instance = instance != null ? instance : new NodeStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withAllocatable(instance.getAllocatable());
            this.withCapacity(instance.getCapacity());
            this.withConditions(instance.getConditions());
            this.withConfig(instance.getConfig());
            this.withDaemonEndpoints(instance.getDaemonEndpoints());
            this.withImages(instance.getImages());
            this.withNodeInfo(instance.getNodeInfo());
            this.withPhase(instance.getPhase());
            this.withVolumesAttached(instance.getVolumesAttached());
            this.withVolumesInUse(instance.getVolumesInUse());
            this.withAddresses(instance.getAddresses());
            this.withAllocatable(instance.getAllocatable());
            this.withCapacity(instance.getCapacity());
            this.withConditions(instance.getConditions());
            this.withConfig(instance.getConfig());
            this.withDaemonEndpoints(instance.getDaemonEndpoints());
            this.withImages(instance.getImages());
            this.withNodeInfo(instance.getNodeInfo());
            this.withPhase(instance.getPhase());
            this.withVolumesAttached(instance.getVolumesAttached());
            this.withVolumesInUse(instance.getVolumesInUse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<NodeAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<NodeAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            NodeAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NodeAddress> buildAddresses() {
        return this.addresses != null ? NodeStatusFluent.build(this.addresses) : null;
    }

    public NodeAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public NodeAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public NodeAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<NodeAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(NodeAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, NodeAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)this;
    }

    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)this;
    }

    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    public <K, V> A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? null : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)this;
    }

    public boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public A addToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(NodeCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<NodeCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(NodeCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<NodeCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<NodeConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<NodeConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            NodeConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NodeCondition> buildConditions() {
        return this.conditions != null ? NodeStatusFluent.build(this.conditions) : null;
    }

    public NodeCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public NodeCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public NodeCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<NodeCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(NodeCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(NodeCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, NodeCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public NodeConfigStatus buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    public A withConfig(NodeConfigStatus config) {
        this._visitables.get("config").remove(this.config);
        if (config != null) {
            this.config = new NodeConfigStatusBuilder(config);
            this._visitables.get("config").add(this.config);
        } else {
            this.config = null;
            this._visitables.get("config").remove(this.config);
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConfigNested<A> withNewConfig() {
        return new ConfigNested(null);
    }

    public ConfigNested<A> withNewConfigLike(NodeConfigStatus item) {
        return new ConfigNested(item);
    }

    public ConfigNested<A> editConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(null));
    }

    public ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(new NodeConfigStatusBuilder().build()));
    }

    public ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item) {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(item));
    }

    public NodeDaemonEndpoints buildDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        this._visitables.get("daemonEndpoints").remove(this.daemonEndpoints);
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.get("daemonEndpoints").add(this.daemonEndpoints);
        } else {
            this.daemonEndpoints = null;
            this._visitables.get("daemonEndpoints").remove(this.daemonEndpoints);
        }
        return (A)this;
    }

    public boolean hasDaemonEndpoints() {
        return this.daemonEndpoints != null;
    }

    public DaemonEndpointsNested<A> withNewDaemonEndpoints() {
        return new DaemonEndpointsNested(null);
    }

    public DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return new DaemonEndpointsNested(item);
    }

    public DaemonEndpointsNested<A> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(null));
    }

    public DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(new NodeDaemonEndpointsBuilder().build()));
    }

    public DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(item));
    }

    public A addToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").add(index, builder);
            this.images.add(index, builder);
        }
        return (A)this;
    }

    public A setToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
            this.images.set(index, builder);
        }
        return (A)this;
    }

    public A addToImages(ContainerImage ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    public A addAllToImages(Collection<ContainerImage> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    public A removeFromImages(ContainerImage ... items) {
        if (this.images == null) {
            return (A)this;
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImages(Collection<ContainerImage> items) {
        if (this.images == null) {
            return (A)this;
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImages(Predicate<ContainerImageBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ContainerImageBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ContainerImageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerImage> buildImages() {
        return this.images != null ? NodeStatusFluent.build(this.images) : null;
    }

    public ContainerImage buildImage(int index) {
        return this.images.get(index).build();
    }

    public ContainerImage buildFirstImage() {
        return this.images.get(0).build();
    }

    public ContainerImage buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImages(List<ContainerImage> images) {
        if (this.images != null) {
            this._visitables.get("images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    public A withImages(ContainerImage ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove("images");
        }
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public ImagesNested<A> addNewImage() {
        return new ImagesNested(-1, null);
    }

    public ImagesNested<A> addNewImageLike(ContainerImage item) {
        return new ImagesNested(-1, item);
    }

    public ImagesNested<A> setNewImageLike(int index, ContainerImage item) {
        return new ImagesNested(index, item);
    }

    public ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    public ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        this._visitables.get("nodeInfo").remove(this.nodeInfo);
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.get("nodeInfo").add(this.nodeInfo);
        } else {
            this.nodeInfo = null;
            this._visitables.get("nodeInfo").remove(this.nodeInfo);
        }
        return (A)this;
    }

    public boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    public NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNested(null);
    }

    public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNested(item);
    }

    public NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(null));
    }

    public NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
    }

    public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(item));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        if (index < 0 || index >= this.volumesAttached.size()) {
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        } else {
            this._visitables.get("volumesAttached").add(index, builder);
            this.volumesAttached.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        if (index < 0 || index >= this.volumesAttached.size()) {
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        } else {
            this._visitables.get("volumesAttached").set(index, builder);
            this.volumesAttached.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumesAttached(AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumesAttached(Collection<AttachedVolume> items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumesAttached(AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            return (A)this;
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").remove(builder);
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumesAttached(Collection<AttachedVolume> items) {
        if (this.volumesAttached == null) {
            return (A)this;
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").remove(builder);
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        if (this.volumesAttached == null) {
            return (A)this;
        }
        Iterator<AttachedVolumeBuilder> each = this.volumesAttached.iterator();
        Object visitables = this._visitables.get("volumesAttached");
        while (each.hasNext()) {
            AttachedVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AttachedVolume> buildVolumesAttached() {
        return this.volumesAttached != null ? NodeStatusFluent.build(this.volumesAttached) : null;
    }

    public AttachedVolume buildVolumesAttached(int index) {
        return this.volumesAttached.get(index).build();
    }

    public AttachedVolume buildFirstVolumesAttached() {
        return this.volumesAttached.get(0).build();
    }

    public AttachedVolume buildLastVolumesAttached() {
        return this.volumesAttached.get(this.volumesAttached.size() - 1).build();
    }

    public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumesAttached(List<AttachedVolume> volumesAttached) {
        if (this.volumesAttached != null) {
            this._visitables.get("volumesAttached").clear();
        }
        if (volumesAttached != null) {
            this.volumesAttached = new ArrayList();
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        } else {
            this.volumesAttached = null;
        }
        return (A)this;
    }

    public A withVolumesAttached(AttachedVolume ... volumesAttached) {
        if (this.volumesAttached != null) {
            this.volumesAttached.clear();
            this._visitables.remove("volumesAttached");
        }
        if (volumesAttached != null) {
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumesAttached() {
        return this.volumesAttached != null && !this.volumesAttached.isEmpty();
    }

    public A addNewVolumesAttached(String devicePath, String name) {
        return this.addToVolumesAttached(new AttachedVolume(devicePath, name));
    }

    public VolumesAttachedNested<A> addNewVolumesAttached() {
        return new VolumesAttachedNested(-1, null);
    }

    public VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item) {
        return new VolumesAttachedNested(-1, item);
    }

    public VolumesAttachedNested<A> setNewVolumesAttachedLike(int index, AttachedVolume item) {
        return new VolumesAttachedNested(index, item);
    }

    public VolumesAttachedNested<A> editVolumesAttached(int index) {
        if (this.volumesAttached.size() <= index) {
            throw new RuntimeException("Can't edit volumesAttached. Index exceeds size.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public VolumesAttachedNested<A> editFirstVolumesAttached() {
        if (this.volumesAttached.size() == 0) {
            throw new RuntimeException("Can't edit first volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(0, this.buildVolumesAttached(0));
    }

    public VolumesAttachedNested<A> editLastVolumesAttached() {
        int index = this.volumesAttached.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumesAttached.size(); ++i) {
            if (!predicate.test(this.volumesAttached.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumesAttached. No match found.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public A addToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(index, item);
        return (A)this;
    }

    public A setToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.set(index, item);
        return (A)this;
    }

    public A addToVolumesInUse(String ... items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    public A addAllToVolumesInUse(Collection<String> items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    public A removeFromVolumesInUse(String ... items) {
        if (this.volumesInUse == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVolumesInUse(Collection<String> items) {
        if (this.volumesInUse == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public String getVolumesInUse(int index) {
        return this.volumesInUse.get(index);
    }

    public String getFirstVolumesInUse() {
        return this.volumesInUse.get(0);
    }

    public String getLastVolumesInUse() {
        return this.volumesInUse.get(this.volumesInUse.size() - 1);
    }

    public String getMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumesInUse(List<String> volumesInUse) {
        if (volumesInUse != null) {
            this.volumesInUse = new ArrayList<String>();
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        } else {
            this.volumesInUse = null;
        }
        return (A)this;
    }

    public A withVolumesInUse(String ... volumesInUse) {
        if (this.volumesInUse != null) {
            this.volumesInUse.clear();
            this._visitables.remove("volumesInUse");
        }
        if (volumesInUse != null) {
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumesInUse() {
        return this.volumesInUse != null && !this.volumesInUse.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluent that = (NodeStatusFluent)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.daemonEndpoints, that.daemonEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals(this.nodeInfo, that.nodeInfo)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.volumesAttached, that.volumesAttached)) {
            return false;
        }
        if (!Objects.equals(this.volumesInUse, that.volumesInUse)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.images, this.nodeInfo, this.phase, this.volumesAttached, this.volumesInUse, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.allocatable != null && !this.allocatable.isEmpty()) {
            sb.append("allocatable:");
            sb.append(this.allocatable + ",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(this.capacity + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.daemonEndpoints != null) {
            sb.append("daemonEndpoints:");
            sb.append(this.daemonEndpoints + ",");
        }
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(this.images + ",");
        }
        if (this.nodeInfo != null) {
            sb.append("nodeInfo:");
            sb.append(this.nodeInfo + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.volumesAttached != null && !this.volumesAttached.isEmpty()) {
            sb.append("volumesAttached:");
            sb.append(this.volumesAttached + ",");
        }
        if (this.volumesInUse != null && !this.volumesInUse.isEmpty()) {
            sb.append("volumesInUse:");
            sb.append(this.volumesInUse + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VolumesAttachedNested<N>
    extends AttachedVolumeFluent<VolumesAttachedNested<N>>
    implements Nested<N> {
        AttachedVolumeBuilder builder;
        int index;

        VolumesAttachedNested(int index, AttachedVolume item) {
            this.index = index;
            this.builder = new AttachedVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.setToVolumesAttached(this.index, this.builder.build());
        }

        public N endVolumesAttached() {
            return this.and();
        }
    }

    public class NodeInfoNested<N>
    extends NodeSystemInfoFluent<NodeInfoNested<N>>
    implements Nested<N> {
        NodeSystemInfoBuilder builder;

        NodeInfoNested(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.withNodeInfo(this.builder.build());
        }

        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNested<N>
    extends ContainerImageFluent<ImagesNested<N>>
    implements Nested<N> {
        ContainerImageBuilder builder;
        int index;

        ImagesNested(int index, ContainerImage item) {
            this.index = index;
            this.builder = new ContainerImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.setToImages(this.index, this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class DaemonEndpointsNested<N>
    extends NodeDaemonEndpointsFluent<DaemonEndpointsNested<N>>
    implements Nested<N> {
        NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNested(NodeDaemonEndpoints item) {
            this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.withDaemonEndpoints(this.builder.build());
        }

        public N endDaemonEndpoints() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends NodeConfigStatusFluent<ConfigNested<N>>
    implements Nested<N> {
        NodeConfigStatusBuilder builder;

        ConfigNested(NodeConfigStatus item) {
            this.builder = new NodeConfigStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.withConfig(this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends NodeConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        NodeConditionBuilder builder;
        int index;

        ConditionsNested(int index, NodeCondition item) {
            this.index = index;
            this.builder = new NodeConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends NodeAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        NodeAddressBuilder builder;
        int index;

        AddressesNested(int index, NodeAddress item) {
            this.index = index;
            this.builder = new NodeAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

