/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSource;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSourceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSourceFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeConfigStatusFluent<A extends NodeConfigStatusFluent<A>>
extends BaseFluent<A> {
    private NodeConfigSourceBuilder active;
    private NodeConfigSourceBuilder assigned;
    private String error;
    private NodeConfigSourceBuilder lastKnownGood;
    private Map<String, Object> additionalProperties;

    public NodeConfigStatusFluent() {
    }

    public NodeConfigStatusFluent(NodeConfigStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeConfigStatus instance) {
        NodeConfigStatus nodeConfigStatus = instance = instance != null ? instance : new NodeConfigStatus();
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withAssigned(instance.getAssigned());
            this.withError(instance.getError());
            this.withLastKnownGood(instance.getLastKnownGood());
            this.withActive(instance.getActive());
            this.withAssigned(instance.getAssigned());
            this.withError(instance.getError());
            this.withLastKnownGood(instance.getLastKnownGood());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NodeConfigSource buildActive() {
        return this.active != null ? this.active.build() : null;
    }

    public A withActive(NodeConfigSource active) {
        this._visitables.get("active").remove(this.active);
        if (active != null) {
            this.active = new NodeConfigSourceBuilder(active);
            this._visitables.get("active").add(this.active);
        } else {
            this.active = null;
            this._visitables.get("active").remove(this.active);
        }
        return (A)this;
    }

    public boolean hasActive() {
        return this.active != null;
    }

    public ActiveNested<A> withNewActive() {
        return new ActiveNested(null);
    }

    public ActiveNested<A> withNewActiveLike(NodeConfigSource item) {
        return new ActiveNested(item);
    }

    public ActiveNested<A> editActive() {
        return this.withNewActiveLike(Optional.ofNullable(this.buildActive()).orElse(null));
    }

    public ActiveNested<A> editOrNewActive() {
        return this.withNewActiveLike(Optional.ofNullable(this.buildActive()).orElse(new NodeConfigSourceBuilder().build()));
    }

    public ActiveNested<A> editOrNewActiveLike(NodeConfigSource item) {
        return this.withNewActiveLike(Optional.ofNullable(this.buildActive()).orElse(item));
    }

    public NodeConfigSource buildAssigned() {
        return this.assigned != null ? this.assigned.build() : null;
    }

    public A withAssigned(NodeConfigSource assigned) {
        this._visitables.get("assigned").remove(this.assigned);
        if (assigned != null) {
            this.assigned = new NodeConfigSourceBuilder(assigned);
            this._visitables.get("assigned").add(this.assigned);
        } else {
            this.assigned = null;
            this._visitables.get("assigned").remove(this.assigned);
        }
        return (A)this;
    }

    public boolean hasAssigned() {
        return this.assigned != null;
    }

    public AssignedNested<A> withNewAssigned() {
        return new AssignedNested(null);
    }

    public AssignedNested<A> withNewAssignedLike(NodeConfigSource item) {
        return new AssignedNested(item);
    }

    public AssignedNested<A> editAssigned() {
        return this.withNewAssignedLike(Optional.ofNullable(this.buildAssigned()).orElse(null));
    }

    public AssignedNested<A> editOrNewAssigned() {
        return this.withNewAssignedLike(Optional.ofNullable(this.buildAssigned()).orElse(new NodeConfigSourceBuilder().build()));
    }

    public AssignedNested<A> editOrNewAssignedLike(NodeConfigSource item) {
        return this.withNewAssignedLike(Optional.ofNullable(this.buildAssigned()).orElse(item));
    }

    public String getError() {
        return this.error;
    }

    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public NodeConfigSource buildLastKnownGood() {
        return this.lastKnownGood != null ? this.lastKnownGood.build() : null;
    }

    public A withLastKnownGood(NodeConfigSource lastKnownGood) {
        this._visitables.get("lastKnownGood").remove(this.lastKnownGood);
        if (lastKnownGood != null) {
            this.lastKnownGood = new NodeConfigSourceBuilder(lastKnownGood);
            this._visitables.get("lastKnownGood").add(this.lastKnownGood);
        } else {
            this.lastKnownGood = null;
            this._visitables.get("lastKnownGood").remove(this.lastKnownGood);
        }
        return (A)this;
    }

    public boolean hasLastKnownGood() {
        return this.lastKnownGood != null;
    }

    public LastKnownGoodNested<A> withNewLastKnownGood() {
        return new LastKnownGoodNested(null);
    }

    public LastKnownGoodNested<A> withNewLastKnownGoodLike(NodeConfigSource item) {
        return new LastKnownGoodNested(item);
    }

    public LastKnownGoodNested<A> editLastKnownGood() {
        return this.withNewLastKnownGoodLike(Optional.ofNullable(this.buildLastKnownGood()).orElse(null));
    }

    public LastKnownGoodNested<A> editOrNewLastKnownGood() {
        return this.withNewLastKnownGoodLike(Optional.ofNullable(this.buildLastKnownGood()).orElse(new NodeConfigSourceBuilder().build()));
    }

    public LastKnownGoodNested<A> editOrNewLastKnownGoodLike(NodeConfigSource item) {
        return this.withNewLastKnownGoodLike(Optional.ofNullable(this.buildLastKnownGood()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigStatusFluent that = (NodeConfigStatusFluent)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.assigned, that.assigned)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        if (!Objects.equals(this.lastKnownGood, that.lastKnownGood)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.assigned, this.error, this.lastKnownGood, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.assigned != null) {
            sb.append("assigned:");
            sb.append(this.assigned + ",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error + ",");
        }
        if (this.lastKnownGood != null) {
            sb.append("lastKnownGood:");
            sb.append(this.lastKnownGood + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LastKnownGoodNested<N>
    extends NodeConfigSourceFluent<LastKnownGoodNested<N>>
    implements Nested<N> {
        NodeConfigSourceBuilder builder;

        LastKnownGoodNested(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeConfigStatusFluent.this.withLastKnownGood(this.builder.build());
        }

        public N endLastKnownGood() {
            return this.and();
        }
    }

    public class AssignedNested<N>
    extends NodeConfigSourceFluent<AssignedNested<N>>
    implements Nested<N> {
        NodeConfigSourceBuilder builder;

        AssignedNested(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeConfigStatusFluent.this.withAssigned(this.builder.build());
        }

        public N endAssigned() {
            return this.and();
        }
    }

    public class ActiveNested<N>
    extends NodeConfigSourceFluent<ActiveNested<N>>
    implements Nested<N> {
        NodeConfigSourceBuilder builder;

        ActiveNested(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeConfigStatusFluent.this.withActive(this.builder.build());
        }

        public N endActive() {
            return this.and();
        }
    }
}

