/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMapNodeConfigSource;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMapNodeConfigSourceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMapNodeConfigSourceFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeConfigSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeConfigSourceFluent<A extends NodeConfigSourceFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNodeConfigSourceBuilder configMap;
    private Map<String, Object> additionalProperties;

    public NodeConfigSourceFluent() {
    }

    public NodeConfigSourceFluent(NodeConfigSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeConfigSource instance) {
        NodeConfigSource nodeConfigSource = instance = instance != null ? instance : new NodeConfigSource();
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withConfigMap(instance.getConfigMap());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNodeConfigSource buildConfigMap() {
        return this.configMap != null ? this.configMap.build() : null;
    }

    public A withConfigMap(ConfigMapNodeConfigSource configMap) {
        this._visitables.get("configMap").remove(this.configMap);
        if (configMap != null) {
            this.configMap = new ConfigMapNodeConfigSourceBuilder(configMap);
            this._visitables.get("configMap").add(this.configMap);
        } else {
            this.configMap = null;
            this._visitables.get("configMap").remove(this.configMap);
        }
        return (A)this;
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public A withNewConfigMap(String kubeletConfigKey, String name, String namespace, String resourceVersion, String uid) {
        return this.withConfigMap(new ConfigMapNodeConfigSource(kubeletConfigKey, name, namespace, resourceVersion, uid));
    }

    public ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNested(null);
    }

    public ConfigMapNested<A> withNewConfigMapLike(ConfigMapNodeConfigSource item) {
        return new ConfigMapNested(item);
    }

    public ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(null));
    }

    public ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(new ConfigMapNodeConfigSourceBuilder().build()));
    }

    public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapNodeConfigSource item) {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigSourceFluent that = (NodeConfigSourceFluent)o;
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configMap, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigMapNested<N>
    extends ConfigMapNodeConfigSourceFluent<ConfigMapNested<N>>
    implements Nested<N> {
        ConfigMapNodeConfigSourceBuilder builder;

        ConfigMapNested(ConfigMapNodeConfigSource item) {
            this.builder = new ConfigMapNodeConfigSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeConfigSourceFluent.this.withConfigMap(this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }
}

