/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.v6_9.Editable;
import io.fabric8.kubernetes.api.model.v6_9.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.v6_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_9.Namespaced;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "binaryData", "data", "immutable"})
@Version(value="v1")
@Group(value="")
public class ConfigMap
implements Editable<ConfigMapBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="binaryData")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> binaryData = new LinkedHashMap<String, String>();
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> data = new LinkedHashMap<String, String>();
    @JsonProperty(value="immutable")
    private Boolean immutable;
    @JsonProperty(value="kind")
    private String kind = "ConfigMap";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ConfigMap() {
    }

    public ConfigMap(String apiVersion, Map<String, String> binaryData, Map<String, String> data, Boolean immutable, String kind, ObjectMeta metadata) {
        this.apiVersion = apiVersion;
        this.binaryData = binaryData;
        this.data = data;
        this.immutable = immutable;
        this.kind = kind;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="binaryData")
    public Map<String, String> getBinaryData() {
        return this.binaryData;
    }

    @JsonProperty(value="binaryData")
    public void setBinaryData(Map<String, String> binaryData) {
        this.binaryData = binaryData;
    }

    @JsonProperty(value="data")
    public Map<String, String> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @JsonProperty(value="immutable")
    public Boolean getImmutable() {
        return this.immutable;
    }

    @JsonProperty(value="immutable")
    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @Override
    @JsonIgnore
    public ConfigMapBuilder edit() {
        return new ConfigMapBuilder(this);
    }

    @JsonIgnore
    public ConfigMapBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ConfigMap(apiVersion=" + this.getApiVersion() + ", binaryData=" + this.getBinaryData() + ", data=" + this.getData() + ", immutable=" + this.getImmutable() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigMap)) {
            return false;
        }
        ConfigMap other = (ConfigMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$immutable = this.getImmutable();
        Boolean other$immutable = other.getImmutable();
        if (this$immutable == null ? other$immutable != null : !((Object)this$immutable).equals(other$immutable)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        Map<String, String> this$binaryData = this.getBinaryData();
        Map<String, String> other$binaryData = other.getBinaryData();
        if (this$binaryData == null ? other$binaryData != null : !((Object)this$binaryData).equals(other$binaryData)) {
            return false;
        }
        Map<String, String> this$data = this.getData();
        Map<String, String> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $immutable = this.getImmutable();
        result = result * 59 + ($immutable == null ? 43 : ((Object)$immutable).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        Map<String, String> $binaryData = this.getBinaryData();
        result = result * 59 + ($binaryData == null ? 43 : ((Object)$binaryData).hashCode());
        Map<String, String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

