/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy;
import io.fabric8.openshift.api.model.operator.v1.HostNetworkStrategy;
import io.fabric8.openshift.api.model.operator.v1.HostNetworkStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.HostNetworkStrategyFluent;
import io.fabric8.openshift.api.model.operator.v1.LoadBalancerStrategy;
import io.fabric8.openshift.api.model.operator.v1.LoadBalancerStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.LoadBalancerStrategyFluent;
import io.fabric8.openshift.api.model.operator.v1.NodePortStrategy;
import io.fabric8.openshift.api.model.operator.v1.NodePortStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodePortStrategyFluent;
import io.fabric8.openshift.api.model.operator.v1.PrivateStrategy;
import io.fabric8.openshift.api.model.operator.v1.PrivateStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.PrivateStrategyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EndpointPublishingStrategyFluent<A extends EndpointPublishingStrategyFluent<A>>
extends BaseFluent<A> {
    private HostNetworkStrategyBuilder hostNetwork;
    private LoadBalancerStrategyBuilder loadBalancer;
    private NodePortStrategyBuilder nodePort;
    private PrivateStrategyBuilder _private;
    private String type;
    private Map<String, Object> additionalProperties;

    public EndpointPublishingStrategyFluent() {
    }

    public EndpointPublishingStrategyFluent(EndpointPublishingStrategy instance) {
        EndpointPublishingStrategy endpointPublishingStrategy = instance = instance != null ? instance : new EndpointPublishingStrategy();
        if (instance != null) {
            this.withHostNetwork(instance.getHostNetwork());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withNodePort(instance.getNodePort());
            this.withPrivate(instance.getPrivate());
            this.withType(instance.getType());
            this.withHostNetwork(instance.getHostNetwork());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withNodePort(instance.getNodePort());
            this.withPrivate(instance.getPrivate());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HostNetworkStrategy buildHostNetwork() {
        return this.hostNetwork != null ? this.hostNetwork.build() : null;
    }

    public A withHostNetwork(HostNetworkStrategy hostNetwork) {
        this._visitables.get("hostNetwork").remove(this.hostNetwork);
        if (hostNetwork != null) {
            this.hostNetwork = new HostNetworkStrategyBuilder(hostNetwork);
            this._visitables.get("hostNetwork").add(this.hostNetwork);
        } else {
            this.hostNetwork = null;
            this._visitables.get("hostNetwork").remove(this.hostNetwork);
        }
        return (A)this;
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public A withNewHostNetwork(Integer httpPort, Integer httpsPort, String protocol, Integer statsPort) {
        return this.withHostNetwork(new HostNetworkStrategy(httpPort, httpsPort, protocol, statsPort));
    }

    public HostNetworkNested<A> withNewHostNetwork() {
        return new HostNetworkNested(null);
    }

    public HostNetworkNested<A> withNewHostNetworkLike(HostNetworkStrategy item) {
        return new HostNetworkNested(item);
    }

    public HostNetworkNested<A> editHostNetwork() {
        return this.withNewHostNetworkLike(Optional.ofNullable(this.buildHostNetwork()).orElse(null));
    }

    public HostNetworkNested<A> editOrNewHostNetwork() {
        return this.withNewHostNetworkLike(Optional.ofNullable(this.buildHostNetwork()).orElse(new HostNetworkStrategyBuilder().build()));
    }

    public HostNetworkNested<A> editOrNewHostNetworkLike(HostNetworkStrategy item) {
        return this.withNewHostNetworkLike(Optional.ofNullable(this.buildHostNetwork()).orElse(item));
    }

    public LoadBalancerStrategy buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    public A withLoadBalancer(LoadBalancerStrategy loadBalancer) {
        this._visitables.get("loadBalancer").remove(this.loadBalancer);
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerStrategyBuilder(loadBalancer);
            this._visitables.get("loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get("loadBalancer").remove(this.loadBalancer);
        }
        return (A)this;
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStrategy item) {
        return new LoadBalancerNested(item);
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new LoadBalancerStrategyBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStrategy item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    public NodePortStrategy buildNodePort() {
        return this.nodePort != null ? this.nodePort.build() : null;
    }

    public A withNodePort(NodePortStrategy nodePort) {
        this._visitables.get("nodePort").remove(this.nodePort);
        if (nodePort != null) {
            this.nodePort = new NodePortStrategyBuilder(nodePort);
            this._visitables.get("nodePort").add(this.nodePort);
        } else {
            this.nodePort = null;
            this._visitables.get("nodePort").remove(this.nodePort);
        }
        return (A)this;
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public A withNewNodePort(String protocol) {
        return this.withNodePort(new NodePortStrategy(protocol));
    }

    public NodePortNested<A> withNewNodePort() {
        return new NodePortNested(null);
    }

    public NodePortNested<A> withNewNodePortLike(NodePortStrategy item) {
        return new NodePortNested(item);
    }

    public NodePortNested<A> editNodePort() {
        return this.withNewNodePortLike(Optional.ofNullable(this.buildNodePort()).orElse(null));
    }

    public NodePortNested<A> editOrNewNodePort() {
        return this.withNewNodePortLike(Optional.ofNullable(this.buildNodePort()).orElse(new NodePortStrategyBuilder().build()));
    }

    public NodePortNested<A> editOrNewNodePortLike(NodePortStrategy item) {
        return this.withNewNodePortLike(Optional.ofNullable(this.buildNodePort()).orElse(item));
    }

    public PrivateStrategy buildPrivate() {
        return this._private != null ? this._private.build() : null;
    }

    public A withPrivate(PrivateStrategy _private) {
        this._visitables.get("_private").remove(this._private);
        if (_private != null) {
            this._private = new PrivateStrategyBuilder(_private);
            this._visitables.get("_private").add(this._private);
        } else {
            this._private = null;
            this._visitables.get("_private").remove(this._private);
        }
        return (A)this;
    }

    public boolean hasPrivate() {
        return this._private != null;
    }

    public A withNewPrivate(String protocol) {
        return this.withPrivate(new PrivateStrategy(protocol));
    }

    public PrivateNested<A> withNewPrivate() {
        return new PrivateNested(null);
    }

    public PrivateNested<A> withNewPrivateLike(PrivateStrategy item) {
        return new PrivateNested(item);
    }

    public PrivateNested<A> editPrivate() {
        return this.withNewPrivateLike(Optional.ofNullable(this.buildPrivate()).orElse(null));
    }

    public PrivateNested<A> editOrNewPrivate() {
        return this.withNewPrivateLike(Optional.ofNullable(this.buildPrivate()).orElse(new PrivateStrategyBuilder().build()));
    }

    public PrivateNested<A> editOrNewPrivateLike(PrivateStrategy item) {
        return this.withNewPrivateLike(Optional.ofNullable(this.buildPrivate()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointPublishingStrategyFluent that = (EndpointPublishingStrategyFluent)o;
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancer, that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        if (!Objects.equals(this._private, that._private)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostNetwork, this.loadBalancer, this.nodePort, this._private, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(this.loadBalancer + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this._private != null) {
            sb.append("_private:");
            sb.append(this._private + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrivateNested<N>
    extends PrivateStrategyFluent<PrivateNested<N>>
    implements Nested<N> {
        PrivateStrategyBuilder builder;

        PrivateNested(PrivateStrategy item) {
            this.builder = new PrivateStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointPublishingStrategyFluent.this.withPrivate(this.builder.build());
        }

        public N endPrivate() {
            return this.and();
        }
    }

    public class NodePortNested<N>
    extends NodePortStrategyFluent<NodePortNested<N>>
    implements Nested<N> {
        NodePortStrategyBuilder builder;

        NodePortNested(NodePortStrategy item) {
            this.builder = new NodePortStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointPublishingStrategyFluent.this.withNodePort(this.builder.build());
        }

        public N endNodePort() {
            return this.and();
        }
    }

    public class LoadBalancerNested<N>
    extends LoadBalancerStrategyFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        LoadBalancerStrategyBuilder builder;

        LoadBalancerNested(LoadBalancerStrategy item) {
            this.builder = new LoadBalancerStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointPublishingStrategyFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class HostNetworkNested<N>
    extends HostNetworkStrategyFluent<HostNetworkNested<N>>
    implements Nested<N> {
        HostNetworkStrategyBuilder builder;

        HostNetworkNested(HostNetworkStrategy item) {
            this.builder = new HostNetworkStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointPublishingStrategyFluent.this.withHostNetwork(this.builder.build());
        }

        public N endHostNetwork() {
            return this.and();
        }
    }
}

