/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.WebSpec;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebSpecFluent<A extends WebSpecFluent<A>>
extends BaseFluent<A> {
    private String pageTitle;
    private WebTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public WebSpecFluent() {
    }

    public WebSpecFluent(WebSpec instance) {
        WebSpec webSpec = instance = instance != null ? instance : new WebSpec();
        if (instance != null) {
            this.withPageTitle(instance.getPageTitle());
            this.withTlsConfig(instance.getTlsConfig());
            this.withPageTitle(instance.getPageTitle());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public A withPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return (A)this;
    }

    public boolean hasPageTitle() {
        return this.pageTitle != null;
    }

    public WebTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(WebTLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new WebTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(WebTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new WebTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(WebTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebSpecFluent that = (WebSpecFluent)o;
        if (!Objects.equals(this.pageTitle, that.pageTitle)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pageTitle, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pageTitle != null) {
            sb.append("pageTitle:");
            sb.append(this.pageTitle + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsConfigNested<N>
    extends WebTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        WebTLSConfigBuilder builder;

        TlsConfigNested(WebTLSConfig item) {
            this.builder = new WebTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebSpecFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }
}

