/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatus;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogBuilder;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLogFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class APIRequestCountStatusFluent<A extends APIRequestCountStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private PerResourceAPIRequestLogBuilder currentHour;
    private ArrayList<PerResourceAPIRequestLogBuilder> last24h = new ArrayList();
    private String removedInRelease;
    private Long requestCount;
    private Map<String, Object> additionalProperties;

    public APIRequestCountStatusFluent() {
    }

    public APIRequestCountStatusFluent(APIRequestCountStatus instance) {
        APIRequestCountStatus aPIRequestCountStatus = instance = instance != null ? instance : new APIRequestCountStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentHour(instance.getCurrentHour());
            this.withLast24h(instance.getLast24h());
            this.withRemovedInRelease(instance.getRemovedInRelease());
            this.withRequestCount(instance.getRequestCount());
            this.withConditions(instance.getConditions());
            this.withCurrentHour(instance.getCurrentHour());
            this.withLast24h(instance.getLast24h());
            this.withRemovedInRelease(instance.getRemovedInRelease());
            this.withRequestCount(instance.getRequestCount());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public PerResourceAPIRequestLog buildCurrentHour() {
        return this.currentHour != null ? this.currentHour.build() : null;
    }

    public A withCurrentHour(PerResourceAPIRequestLog currentHour) {
        this._visitables.get("currentHour").remove(this.currentHour);
        if (currentHour != null) {
            this.currentHour = new PerResourceAPIRequestLogBuilder(currentHour);
            this._visitables.get("currentHour").add(this.currentHour);
        } else {
            this.currentHour = null;
            this._visitables.get("currentHour").remove(this.currentHour);
        }
        return (A)this;
    }

    public boolean hasCurrentHour() {
        return this.currentHour != null;
    }

    public CurrentHourNested<A> withNewCurrentHour() {
        return new CurrentHourNested(null);
    }

    public CurrentHourNested<A> withNewCurrentHourLike(PerResourceAPIRequestLog item) {
        return new CurrentHourNested(item);
    }

    public CurrentHourNested<A> editCurrentHour() {
        return this.withNewCurrentHourLike(Optional.ofNullable(this.buildCurrentHour()).orElse(null));
    }

    public CurrentHourNested<A> editOrNewCurrentHour() {
        return this.withNewCurrentHourLike(Optional.ofNullable(this.buildCurrentHour()).orElse(new PerResourceAPIRequestLogBuilder().build()));
    }

    public CurrentHourNested<A> editOrNewCurrentHourLike(PerResourceAPIRequestLog item) {
        return this.withNewCurrentHourLike(Optional.ofNullable(this.buildCurrentHour()).orElse(item));
    }

    public A addToLast24h(int index, PerResourceAPIRequestLog item) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
        if (index < 0 || index >= this.last24h.size()) {
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        } else {
            this._visitables.get("last24h").add(index, builder);
            this.last24h.add(index, builder);
        }
        return (A)this;
    }

    public A setToLast24h(int index, PerResourceAPIRequestLog item) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
        if (index < 0 || index >= this.last24h.size()) {
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        } else {
            this._visitables.get("last24h").set(index, builder);
            this.last24h.set(index, builder);
        }
        return (A)this;
    }

    public A addToLast24h(PerResourceAPIRequestLog ... items) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        }
        return (A)this;
    }

    public A addAllToLast24h(Collection<PerResourceAPIRequestLog> items) {
        if (this.last24h == null) {
            this.last24h = new ArrayList();
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").add(builder);
            this.last24h.add(builder);
        }
        return (A)this;
    }

    public A removeFromLast24h(PerResourceAPIRequestLog ... items) {
        if (this.last24h == null) {
            return (A)this;
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").remove(builder);
            this.last24h.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromLast24h(Collection<PerResourceAPIRequestLog> items) {
        if (this.last24h == null) {
            return (A)this;
        }
        for (PerResourceAPIRequestLog item : items) {
            PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
            this._visitables.get("last24h").remove(builder);
            this.last24h.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        if (this.last24h == null) {
            return (A)this;
        }
        Iterator<PerResourceAPIRequestLogBuilder> each = this.last24h.iterator();
        Object visitables = this._visitables.get("last24h");
        while (each.hasNext()) {
            PerResourceAPIRequestLogBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PerResourceAPIRequestLog> buildLast24h() {
        return this.last24h != null ? APIRequestCountStatusFluent.build(this.last24h) : null;
    }

    public PerResourceAPIRequestLog buildLast24h(int index) {
        return this.last24h.get(index).build();
    }

    public PerResourceAPIRequestLog buildFirstLast24h() {
        return this.last24h.get(0).build();
    }

    public PerResourceAPIRequestLog buildLastLast24h() {
        return this.last24h.get(this.last24h.size() - 1).build();
    }

    public PerResourceAPIRequestLog buildMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        for (PerResourceAPIRequestLogBuilder item : this.last24h) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        for (PerResourceAPIRequestLogBuilder item : this.last24h) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLast24h(List<PerResourceAPIRequestLog> last24h) {
        if (this.last24h != null) {
            this._visitables.get("last24h").clear();
        }
        if (last24h != null) {
            this.last24h = new ArrayList();
            for (PerResourceAPIRequestLog item : last24h) {
                this.addToLast24h(item);
            }
        } else {
            this.last24h = null;
        }
        return (A)this;
    }

    public A withLast24h(PerResourceAPIRequestLog ... last24h) {
        if (this.last24h != null) {
            this.last24h.clear();
            this._visitables.remove("last24h");
        }
        if (last24h != null) {
            for (PerResourceAPIRequestLog item : last24h) {
                this.addToLast24h(item);
            }
        }
        return (A)this;
    }

    public boolean hasLast24h() {
        return this.last24h != null && !this.last24h.isEmpty();
    }

    public Last24hNested<A> addNewLast24h() {
        return new Last24hNested(-1, null);
    }

    public Last24hNested<A> addNewLast24hLike(PerResourceAPIRequestLog item) {
        return new Last24hNested(-1, item);
    }

    public Last24hNested<A> setNewLast24hLike(int index, PerResourceAPIRequestLog item) {
        return new Last24hNested(index, item);
    }

    public Last24hNested<A> editLast24h(int index) {
        if (this.last24h.size() <= index) {
            throw new RuntimeException("Can't edit last24h. Index exceeds size.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    public Last24hNested<A> editFirstLast24h() {
        if (this.last24h.size() == 0) {
            throw new RuntimeException("Can't edit first last24h. The list is empty.");
        }
        return this.setNewLast24hLike(0, this.buildLast24h(0));
    }

    public Last24hNested<A> editLastLast24h() {
        int index = this.last24h.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last last24h. The list is empty.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    public Last24hNested<A> editMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.last24h.size(); ++i) {
            if (!predicate.test(this.last24h.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching last24h. No match found.");
        }
        return this.setNewLast24hLike(index, this.buildLast24h(index));
    }

    public String getRemovedInRelease() {
        return this.removedInRelease;
    }

    public A withRemovedInRelease(String removedInRelease) {
        this.removedInRelease = removedInRelease;
        return (A)this;
    }

    public boolean hasRemovedInRelease() {
        return this.removedInRelease != null;
    }

    public Long getRequestCount() {
        return this.requestCount;
    }

    public A withRequestCount(Long requestCount) {
        this.requestCount = requestCount;
        return (A)this;
    }

    public boolean hasRequestCount() {
        return this.requestCount != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIRequestCountStatusFluent that = (APIRequestCountStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentHour, that.currentHour)) {
            return false;
        }
        if (!Objects.equals(this.last24h, that.last24h)) {
            return false;
        }
        if (!Objects.equals(this.removedInRelease, that.removedInRelease)) {
            return false;
        }
        if (!Objects.equals(this.requestCount, that.requestCount)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHour, this.last24h, this.removedInRelease, this.requestCount, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentHour != null) {
            sb.append("currentHour:");
            sb.append(this.currentHour + ",");
        }
        if (this.last24h != null && !this.last24h.isEmpty()) {
            sb.append("last24h:");
            sb.append(this.last24h + ",");
        }
        if (this.removedInRelease != null) {
            sb.append("removedInRelease:");
            sb.append(this.removedInRelease + ",");
        }
        if (this.requestCount != null) {
            sb.append("requestCount:");
            sb.append(this.requestCount + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class Last24hNested<N>
    extends PerResourceAPIRequestLogFluent<Last24hNested<N>>
    implements Nested<N> {
        PerResourceAPIRequestLogBuilder builder;
        int index;

        Last24hNested(int index, PerResourceAPIRequestLog item) {
            this.index = index;
            this.builder = new PerResourceAPIRequestLogBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIRequestCountStatusFluent.this.setToLast24h(this.index, this.builder.build());
        }

        public N endLast24h() {
            return this.and();
        }
    }

    public class CurrentHourNested<N>
    extends PerResourceAPIRequestLogFluent<CurrentHourNested<N>>
    implements Nested<N> {
        PerResourceAPIRequestLogBuilder builder;

        CurrentHourNested(PerResourceAPIRequestLog item) {
            this.builder = new PerResourceAPIRequestLogBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIRequestCountStatusFluent.this.withCurrentHour(this.builder.build());
        }

        public N endCurrentHour() {
            return this.and();
        }
    }
}

