/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolCondition;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolConditionBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolConditionFluent;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatus;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfiguration;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolStatusConfigurationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigPoolStatusFluent<A extends MachineConfigPoolStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<MachineConfigPoolConditionBuilder> conditions = new ArrayList();
    private MachineConfigPoolStatusConfigurationBuilder configuration;
    private Integer degradedMachineCount;
    private Integer machineCount;
    private Long observedGeneration;
    private Integer readyMachineCount;
    private Integer unavailableMachineCount;
    private Integer updatedMachineCount;
    private Map<String, Object> additionalProperties;

    public MachineConfigPoolStatusFluent() {
    }

    public MachineConfigPoolStatusFluent(MachineConfigPoolStatus instance) {
        MachineConfigPoolStatus machineConfigPoolStatus = instance = instance != null ? instance : new MachineConfigPoolStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withDegradedMachineCount(instance.getDegradedMachineCount());
            this.withMachineCount(instance.getMachineCount());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyMachineCount(instance.getReadyMachineCount());
            this.withUnavailableMachineCount(instance.getUnavailableMachineCount());
            this.withUpdatedMachineCount(instance.getUpdatedMachineCount());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withDegradedMachineCount(instance.getDegradedMachineCount());
            this.withMachineCount(instance.getMachineCount());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyMachineCount(instance.getReadyMachineCount());
            this.withUnavailableMachineCount(instance.getUnavailableMachineCount());
            this.withUpdatedMachineCount(instance.getUpdatedMachineCount());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, MachineConfigPoolCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, MachineConfigPoolCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(MachineConfigPoolCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<MachineConfigPoolCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(MachineConfigPoolCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<MachineConfigPoolCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (MachineConfigPoolCondition item : items) {
            MachineConfigPoolConditionBuilder builder = new MachineConfigPoolConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<MachineConfigPoolConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            MachineConfigPoolConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MachineConfigPoolCondition> buildConditions() {
        return this.conditions != null ? MachineConfigPoolStatusFluent.build(this.conditions) : null;
    }

    public MachineConfigPoolCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public MachineConfigPoolCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public MachineConfigPoolCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public MachineConfigPoolCondition buildMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        for (MachineConfigPoolConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        for (MachineConfigPoolConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<MachineConfigPoolCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (MachineConfigPoolCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(MachineConfigPoolCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (MachineConfigPoolCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new MachineConfigPoolCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(MachineConfigPoolCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, MachineConfigPoolCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<MachineConfigPoolConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public MachineConfigPoolStatusConfiguration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
        this._visitables.get("configuration").remove(this.configuration);
        if (configuration != null) {
            this.configuration = new MachineConfigPoolStatusConfigurationBuilder(configuration);
            this._visitables.get("configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get("configuration").remove(this.configuration);
        }
        return (A)this;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new MachineConfigPoolStatusConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Integer getDegradedMachineCount() {
        return this.degradedMachineCount;
    }

    public A withDegradedMachineCount(Integer degradedMachineCount) {
        this.degradedMachineCount = degradedMachineCount;
        return (A)this;
    }

    public boolean hasDegradedMachineCount() {
        return this.degradedMachineCount != null;
    }

    public Integer getMachineCount() {
        return this.machineCount;
    }

    public A withMachineCount(Integer machineCount) {
        this.machineCount = machineCount;
        return (A)this;
    }

    public boolean hasMachineCount() {
        return this.machineCount != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyMachineCount() {
        return this.readyMachineCount;
    }

    public A withReadyMachineCount(Integer readyMachineCount) {
        this.readyMachineCount = readyMachineCount;
        return (A)this;
    }

    public boolean hasReadyMachineCount() {
        return this.readyMachineCount != null;
    }

    public Integer getUnavailableMachineCount() {
        return this.unavailableMachineCount;
    }

    public A withUnavailableMachineCount(Integer unavailableMachineCount) {
        this.unavailableMachineCount = unavailableMachineCount;
        return (A)this;
    }

    public boolean hasUnavailableMachineCount() {
        return this.unavailableMachineCount != null;
    }

    public Integer getUpdatedMachineCount() {
        return this.updatedMachineCount;
    }

    public A withUpdatedMachineCount(Integer updatedMachineCount) {
        this.updatedMachineCount = updatedMachineCount;
        return (A)this;
    }

    public boolean hasUpdatedMachineCount() {
        return this.updatedMachineCount != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigPoolStatusFluent that = (MachineConfigPoolStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.degradedMachineCount, that.degradedMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.machineCount, that.machineCount)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyMachineCount, that.readyMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.unavailableMachineCount, that.unavailableMachineCount)) {
            return false;
        }
        if (!Objects.equals(this.updatedMachineCount, that.updatedMachineCount)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.configuration, this.degradedMachineCount, this.machineCount, this.observedGeneration, this.readyMachineCount, this.unavailableMachineCount, this.updatedMachineCount, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.degradedMachineCount != null) {
            sb.append("degradedMachineCount:");
            sb.append(this.degradedMachineCount + ",");
        }
        if (this.machineCount != null) {
            sb.append("machineCount:");
            sb.append(this.machineCount + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyMachineCount != null) {
            sb.append("readyMachineCount:");
            sb.append(this.readyMachineCount + ",");
        }
        if (this.unavailableMachineCount != null) {
            sb.append("unavailableMachineCount:");
            sb.append(this.unavailableMachineCount + ",");
        }
        if (this.updatedMachineCount != null) {
            sb.append("updatedMachineCount:");
            sb.append(this.updatedMachineCount + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends MachineConfigPoolStatusConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        MachineConfigPoolStatusConfigurationBuilder builder;

        ConfigurationNested(MachineConfigPoolStatusConfiguration item) {
            this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends MachineConfigPoolConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        MachineConfigPoolConditionBuilder builder;
        int index;

        ConditionsNested(int index, MachineConfigPoolCondition item) {
            this.index = index;
            this.builder = new MachineConfigPoolConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigPoolStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

