/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneSpec;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSDNSZoneSpecFluent;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneSpec;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.AzureDNSZoneSpecFluent;
import io.fabric8.openshift.api.model.hive.v1.DNSZoneSpec;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneSpec;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.GCPDNSZoneSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DNSZoneSpecFluent<A extends DNSZoneSpecFluent<A>>
extends BaseFluent<A> {
    private AWSDNSZoneSpecBuilder aws;
    private AzureDNSZoneSpecBuilder azure;
    private GCPDNSZoneSpecBuilder gcp;
    private Boolean linkToParentDomain;
    private Boolean preserveOnDelete;
    private String zone;
    private Map<String, Object> additionalProperties;

    public DNSZoneSpecFluent() {
    }

    public DNSZoneSpecFluent(DNSZoneSpec instance) {
        DNSZoneSpec dNSZoneSpec = instance = instance != null ? instance : new DNSZoneSpec();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withGcp(instance.getGcp());
            this.withLinkToParentDomain(instance.getLinkToParentDomain());
            this.withPreserveOnDelete(instance.getPreserveOnDelete());
            this.withZone(instance.getZone());
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withGcp(instance.getGcp());
            this.withLinkToParentDomain(instance.getLinkToParentDomain());
            this.withPreserveOnDelete(instance.getPreserveOnDelete());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSDNSZoneSpec buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(AWSDNSZoneSpec aws) {
        this._visitables.get("aws").remove(this.aws);
        if (aws != null) {
            this.aws = new AWSDNSZoneSpecBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get("aws").remove(this.aws);
        }
        return (A)this;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(AWSDNSZoneSpec item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AWSDNSZoneSpecBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AWSDNSZoneSpec item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public AzureDNSZoneSpec buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    public A withAzure(AzureDNSZoneSpec azure) {
        this._visitables.get("azure").remove(this.azure);
        if (azure != null) {
            this.azure = new AzureDNSZoneSpecBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get("azure").remove(this.azure);
        }
        return (A)this;
    }

    public boolean hasAzure() {
        return this.azure != null;
    }

    public AzureNested<A> withNewAzure() {
        return new AzureNested(null);
    }

    public AzureNested<A> withNewAzureLike(AzureDNSZoneSpec item) {
        return new AzureNested(item);
    }

    public AzureNested<A> editAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(null));
    }

    public AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(new AzureDNSZoneSpecBuilder().build()));
    }

    public AzureNested<A> editOrNewAzureLike(AzureDNSZoneSpec item) {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(item));
    }

    public GCPDNSZoneSpec buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    public A withGcp(GCPDNSZoneSpec gcp) {
        this._visitables.get("gcp").remove(this.gcp);
        if (gcp != null) {
            this.gcp = new GCPDNSZoneSpecBuilder(gcp);
            this._visitables.get("gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get("gcp").remove(this.gcp);
        }
        return (A)this;
    }

    public boolean hasGcp() {
        return this.gcp != null;
    }

    public GcpNested<A> withNewGcp() {
        return new GcpNested(null);
    }

    public GcpNested<A> withNewGcpLike(GCPDNSZoneSpec item) {
        return new GcpNested(item);
    }

    public GcpNested<A> editGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(null));
    }

    public GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(new GCPDNSZoneSpecBuilder().build()));
    }

    public GcpNested<A> editOrNewGcpLike(GCPDNSZoneSpec item) {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(item));
    }

    public Boolean getLinkToParentDomain() {
        return this.linkToParentDomain;
    }

    public A withLinkToParentDomain(Boolean linkToParentDomain) {
        this.linkToParentDomain = linkToParentDomain;
        return (A)this;
    }

    public boolean hasLinkToParentDomain() {
        return this.linkToParentDomain != null;
    }

    public Boolean getPreserveOnDelete() {
        return this.preserveOnDelete;
    }

    public A withPreserveOnDelete(Boolean preserveOnDelete) {
        this.preserveOnDelete = preserveOnDelete;
        return (A)this;
    }

    public boolean hasPreserveOnDelete() {
        return this.preserveOnDelete != null;
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSZoneSpecFluent that = (DNSZoneSpecFluent)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        if (!Objects.equals(this.linkToParentDomain, that.linkToParentDomain)) {
            return false;
        }
        if (!Objects.equals(this.preserveOnDelete, that.preserveOnDelete)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.gcp, this.linkToParentDomain, this.preserveOnDelete, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append(this.gcp + ",");
        }
        if (this.linkToParentDomain != null) {
            sb.append("linkToParentDomain:");
            sb.append(this.linkToParentDomain + ",");
        }
        if (this.preserveOnDelete != null) {
            sb.append("preserveOnDelete:");
            sb.append(this.preserveOnDelete + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withLinkToParentDomain() {
        return this.withLinkToParentDomain(true);
    }

    public A withPreserveOnDelete() {
        return this.withPreserveOnDelete(true);
    }

    public class GcpNested<N>
    extends GCPDNSZoneSpecFluent<GcpNested<N>>
    implements Nested<N> {
        GCPDNSZoneSpecBuilder builder;

        GcpNested(GCPDNSZoneSpec item) {
            this.builder = new GCPDNSZoneSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneSpecFluent.this.withGcp(this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class AzureNested<N>
    extends AzureDNSZoneSpecFluent<AzureNested<N>>
    implements Nested<N> {
        AzureDNSZoneSpecBuilder builder;

        AzureNested(AzureDNSZoneSpec item) {
            this.builder = new AzureDNSZoneSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneSpecFluent.this.withAzure(this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AWSDNSZoneSpecFluent<AwsNested<N>>
    implements Nested<N> {
        AWSDNSZoneSpecBuilder builder;

        AwsNested(AWSDNSZoneSpec item) {
            this.builder = new AWSDNSZoneSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSZoneSpecFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

